/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.Arrays;

public class UserAttributeSubpacket {
    int type;
    private boolean forceLongLength;
    protected byte[] data;

    protected UserAttributeSubpacket(int n, boolean bl, byte[] byArray) {
        this.type = n;
        this.forceLongLength = bl;
        this.data = byArray;
    }

    protected UserAttributeSubpacket(int n, byte[] byArray) {
        this(n, false, byArray);
    }

    public void encode(OutputStream outputStream) throws IOException {
        int n = this.data.length + 1;
        if (n < 192 && !this.forceLongLength) {
            outputStream.write((byte)n);
        } else if (n <= 8383 && !this.forceLongLength) {
            outputStream.write((byte)(((n -= 192) >> 8 & 0xFF) + 192));
            outputStream.write((byte)n);
        } else {
            outputStream.write(255);
            outputStream.write((byte)(n >> 24));
            outputStream.write((byte)(n >> 16));
            outputStream.write((byte)(n >> 8));
            outputStream.write((byte)n);
        }
        outputStream.write(this.type);
        outputStream.write(this.data);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UserAttributeSubpacket)) {
            return false;
        }
        UserAttributeSubpacket userAttributeSubpacket = (UserAttributeSubpacket)object;
        return this.type == userAttributeSubpacket.type && Arrays.areEqual((byte[])this.data, (byte[])userAttributeSubpacket.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type ^ Arrays.hashCode((byte[])this.data);
    }
}

