/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class UserIDPacket
extends ContainedPacket {
    private byte[] idData;

    public UserIDPacket(String string) {
        this.idData = Strings.toUTF8ByteArray((String)string);
    }

    public UserIDPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.idData = bCPGInputStream.readAll();
    }

    public UserIDPacket(byte[] byArray) {
        this.idData = Arrays.clone((byte[])byArray);
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(13, this.idData);
    }

    public boolean equals(Object object) {
        if (object instanceof UserIDPacket) {
            return Arrays.areEqual((byte[])this.idData, (byte[])((UserIDPacket)object).idData);
        }
        return false;
    }

    public String getID() {
        return Strings.fromUTF8ByteArray((byte[])this.idData);
    }

    public byte[] getRawID() {
        return Arrays.clone((byte[])this.idData);
    }

    public int hashCode() {
        return Arrays.hashCode((byte[])this.idData);
    }
}

