/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.util.Characters;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

public class SExpression {
    private static final Set labelStop = new HashSet(){
        {
            this.add(Characters.valueOf((char)' '));
            this.add(Characters.valueOf((char)')'));
            this.add(Characters.valueOf((char)'('));
            this.add(Characters.valueOf((char)'#'));
            this.add(Characters.valueOf((char)'\"'));
            this.add(Characters.valueOf((char)':'));
        }
    };
    private final ArrayList values = new ArrayList();
    private boolean canonical = false;

    public SExpression() {
    }

    public SExpression(List list) {
        this.values.addAll(list);
    }

    public void addValue(Object object) {
        this.values.add(object);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void consumeUntil(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, char c) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) > -1) {
            if (n == c) {
                return;
            }
            byteArrayOutputStream.write(n);
        }
    }

    private static int consumeUntilSkipCRorLF(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, char c) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        boolean bl = false;
        while ((n = inputStream.read()) > -1) {
            if (bl && n <= 32) {
                bl = false;
                continue;
            }
            if (n == 10) {
                bl = true;
                continue;
            }
            if (c == n) {
                return n;
            }
            byteArrayOutputStream.write(n);
        }
        return -1;
    }

    private static int consumeUntilSkipCRorLF(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, Set set) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        boolean bl = false;
        while ((n = inputStream.read()) > -1) {
            if (bl && n <= 32) {
                bl = false;
                continue;
            }
            if (n == 10) {
                bl = true;
                continue;
            }
            if (set.contains(Characters.valueOf((char)((char)n)))) {
                return n;
            }
            byteArrayOutputStream.write(n);
        }
        return -1;
    }

    private static void consumeUntilSkipWhiteSpace(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, char c) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) > -1) {
            if (n <= 32) continue;
            if (n == c) {
                return;
            }
            byteArrayOutputStream.write(n);
        }
    }

    public SExpression filterIn(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        SExpression sExpression = new SExpression();
        Iterator iterator = ((AbstractList)this.values).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof SExpression) {
                String string;
                if (!((SExpression)e).values.isEmpty() && !hashSet.contains(string = ((SExpression)e).values.get(0).toString())) continue;
                sExpression.values.add(e);
                continue;
            }
            if (!hashSet.contains(e.toString())) continue;
            sExpression.values.add(e);
        }
        return sExpression;
    }

    public SExpression filterOut(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        SExpression sExpression = new SExpression();
        Iterator iterator = ((AbstractList)this.values).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (hashSet.contains(e.toString())) continue;
            if (e instanceof SExpression) {
                String string;
                if (!((SExpression)e).values.isEmpty() && hashSet.contains(string = ((SExpression)e).values.get(0).toString())) continue;
                sExpression.values.add(((SExpression)e).filterOut(stringArray));
                continue;
            }
            sExpression.values.add(e);
        }
        return sExpression;
    }

    public byte[] getBytes(int n) {
        return (byte[])this.values.get(n);
    }

    public SExpression getExpression(int n) {
        return (SExpression)this.values.get(n);
    }

    public SExpression getExpressionWithLabel(String string) {
        Iterator iterator = ((AbstractList)this.values).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SExpression) || !((SExpression)e).hasLabel(string)) continue;
            return (SExpression)e;
        }
        return null;
    }

    public SExpression getExpressionWithLabelOrFail(String string) {
        Iterator iterator = ((AbstractList)this.values).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SExpression) || !((SExpression)e).hasLabel(string)) continue;
            return (SExpression)e;
        }
        throw new IllegalArgumentException("label " + string + " was not found");
    }

    public int getInt(int n) {
        return Integer.parseInt(this.getString(n));
    }

    public String getString(int n) {
        Object e = this.values.get(n);
        if (e instanceof byte[]) {
            return Strings.fromUTF8ByteArray((byte[])((byte[])e));
        }
        return this.values.get(n).toString();
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    public List getValues() {
        return this.values;
    }

    public boolean hasLabel(String string) {
        if (this.values.isEmpty()) {
            throw new IllegalArgumentException("S-Expression is empty");
        }
        Object object = this.values.get(0);
        object = object instanceof String || object instanceof QuotedString ? object.toString() : Strings.fromByteArray((byte[])((byte[])object));
        return object.equals(string);
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    public static SExpression parse(InputStream inputStream, int n) throws IOException {
        SExpression sExpression = null;
        return SExpression.parseExpression(inputStream, sExpression, new ByteArrayOutputStream(), n);
    }

    public static SExpression parse(byte[] byArray, int n) throws IOException {
        return SExpression.parse(new ByteArrayInputStream(byArray), n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SExpression parseExpression(InputStream inputStream, SExpression sExpression, ByteArrayOutputStream byteArrayOutputStream, int n) throws IOException {
        block13: {
            SExpression sExpression2;
            block12: {
                Object var4_4 = null;
                if (byteArrayOutputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                }
                try {
                    if (--n < 0) {
                        throw new IllegalStateException("S-Expression exceeded maximum depth");
                    }
                    int n2 = 0;
                    while (true) {
                        if ((n2 = SExpression.consumeUntilSkipCRorLF(inputStream, byteArrayOutputStream, labelStop)) == 58) {
                            int n3 = Integer.parseInt(Strings.fromByteArray((byte[])byteArrayOutputStream.toByteArray()));
                            byte[] byArray = new byte[n3];
                            Streams.readFully((InputStream)inputStream, (byte[])byArray);
                            sExpression.addValue(byArray);
                            sExpression.setCanonical(true);
                            continue;
                        }
                        if (byteArrayOutputStream.size() > 0) {
                            sExpression.addValue(Strings.fromByteArray((byte[])byteArrayOutputStream.toByteArray()));
                        }
                        if (n2 == 40) {
                            if (sExpression == null) {
                                sExpression = new SExpression();
                                SExpression.parseExpression(inputStream, sExpression, byteArrayOutputStream, n);
                                SExpression sExpression3 = sExpression;
                                Object var7_10 = null;
                                ++n;
                                return sExpression3;
                            }
                            sExpression.addValue(SExpression.parseExpression(inputStream, new SExpression(), byteArrayOutputStream, n));
                            continue;
                        }
                        if (n2 == 35) {
                            SExpression.consumeUntilSkipWhiteSpace(inputStream, byteArrayOutputStream, '#');
                            sExpression.addValue(Hex.decode((String)Strings.fromByteArray((byte[])byteArrayOutputStream.toByteArray())));
                            continue;
                        }
                        if (n2 == 34) {
                            SExpression.consumeUntilSkipCRorLF(inputStream, byteArrayOutputStream, '\"');
                            sExpression.addValue(new QuotedString(Strings.fromByteArray((byte[])byteArrayOutputStream.toByteArray())));
                            continue;
                        }
                        if (n2 == 41) {
                            sExpression2 = sExpression;
                            break block12;
                        }
                        if (n2 == -1) break;
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    ++n;
                    throw throwable;
                }
            }
            Object var7_11 = null;
            ++n;
            return sExpression2;
        }
        Object var7_12 = null;
        ++n;
        return sExpression;
    }

    private void setCanonical(boolean bl) {
        this.canonical = bl;
    }

    public PGPExtendedKeyAttribute toAttribute() {
        PGPExtendedKeyAttribute.Builder builder = PGPExtendedKeyAttribute.builder();
        Iterator iterator = ((AbstractList)this.values).iterator();
        while (iterator.hasNext()) {
            builder.addAttribute(iterator.next());
        }
        return builder.build();
    }

    public byte[] toCanonicalForm() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.toCanonicalForm(byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new PGPRuntimeOperationException(exception.getMessage(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void toCanonicalForm(OutputStream outputStream) throws IOException {
        outputStream.write(40);
        boolean bl = false;
        Iterator iterator = ((AbstractList)this.values).iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof QuotedString) {
                object = ((QuotedString)e).value;
                outputStream.write(Strings.toByteArray((String)Integer.toString(((String)object).length())));
                outputStream.write(58);
                outputStream.write(Strings.toUTF8ByteArray((String)object));
                continue;
            }
            if (e instanceof String) {
                object = (String)e;
                outputStream.write(Strings.toByteArray((String)Integer.toString(((String)object).length())));
                outputStream.write(58);
                outputStream.write(Strings.toUTF8ByteArray((String)object));
                continue;
            }
            if (e instanceof byte[]) {
                object = (byte[])e;
                outputStream.write(Strings.toByteArray((String)Integer.toString(((Object)object).length)));
                outputStream.write(58);
                outputStream.write((byte[])object);
                continue;
            }
            if (e instanceof SExpression) {
                ((SExpression)e).toCanonicalForm(outputStream);
                continue;
            }
            throw new IllegalStateException("unhandled type " + e.getClass().getName() + " in value list");
        }
        outputStream.write(41);
        outputStream.flush();
    }

    public static class QuotedString {
        private final String value;

        public QuotedString(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }

    public static class Builder {
        List values = new ArrayList();

        public Builder addContent(SExpression sExpression) {
            Iterator iterator = ((AbstractList)sExpression.values).iterator();
            while (iterator.hasNext()) {
                this.values.add(iterator.next());
            }
            return this;
        }

        public Builder addValue(Object object) {
            this.values.add(object);
            return this;
        }

        public SExpression build() {
            return new SExpression(this.values);
        }
    }
}

