/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.util.io.Streams;

class SXprUtils {
    SXprUtils() {
    }

    static S2K parseS2K(InputStream inputStream) throws IOException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String string = SXprUtils.readString(inputStream, inputStream.read());
        byte[] byArray = SXprUtils.readBytes(inputStream, inputStream.read());
        final long l = Long.parseLong(SXprUtils.readString(inputStream, inputStream.read()));
        SXprUtils.skipCloseParenthesis(inputStream);
        S2K s2K = new S2K(2, byArray, (int)l){

            public long getIterationCount() {
                return l;
            }
        };
        return s2K;
    }

    static byte[] readBytes(InputStream inputStream, int n) throws IOException {
        int n2 = SXprUtils.readLength(inputStream, n);
        byte[] byArray = new byte[n2];
        Streams.readFully((InputStream)inputStream, (byte[])byArray);
        return byArray;
    }

    private static int readLength(InputStream inputStream, int n) throws IOException {
        int n2 = n - 48;
        while ((n = inputStream.read()) >= 0 && n != 58) {
            n2 = n2 * 10 + n - 48;
        }
        return n2;
    }

    static String readString(InputStream inputStream, int n) throws IOException {
        int n2 = SXprUtils.readLength(inputStream, n);
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 != cArray.length) {
            cArray[n3] = (char)inputStream.read();
            ++n3;
        }
        return new String(cArray);
    }

    static void skipCloseParenthesis(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n != 41) {
            throw new IOException("unknown character encountered");
        }
    }

    static void skipOpenParenthesis(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n != 40) {
            throw new IOException("unknown character encountered: " + (char)n);
        }
    }
}

