/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public abstract class PGPEncryptedData
implements SymmetricKeyAlgorithmTags {
    InputStreamPacket encData;
    InputStream encStream;
    TruncatedStream truncStream;
    PGPDigestCalculator integrityCalculator;

    PGPEncryptedData(InputStreamPacket inputStreamPacket) {
        this.encData = inputStreamPacket;
    }

    public int getAlgorithm() {
        throw new UnsupportedOperationException("not supported - override required");
    }

    public InputStream getInputStream() {
        return this.encData.getInputStream();
    }

    public int getVersion() {
        throw new UnsupportedOperationException("not supported - override required");
    }

    public boolean isIntegrityProtected() {
        return this.encData instanceof SymmetricEncIntegrityPacket;
    }

    public boolean verify() throws PGPException, IOException {
        if (!this.isIntegrityProtected()) {
            throw new PGPException("data not integrity protected.");
        }
        while (this.encStream.read() >= 0) {
        }
        int[] nArray = this.truncStream.getLookAhead();
        OutputStream outputStream = this.integrityCalculator.getOutputStream();
        outputStream.write((byte)nArray[0]);
        outputStream.write((byte)nArray[1]);
        byte[] byArray = this.integrityCalculator.getDigest();
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        while (n != byArray2.length) {
            byArray2[n] = (byte)nArray[n + 2];
            ++n;
        }
        return Arrays.constantTimeAreEqual((byte[])byArray, (byte[])byArray2);
    }

    protected class TruncatedStream
    extends InputStream {
        int[] lookAhead = new int[22];
        int bufPtr;
        InputStream in;

        TruncatedStream(InputStream inputStream) throws IOException {
            int n = 0;
            while (n != this.lookAhead.length) {
                this.lookAhead[n] = inputStream.read();
                if (this.lookAhead[n] < 0) {
                    throw new EOFException();
                }
                ++n;
            }
            this.bufPtr = 0;
            this.in = inputStream;
        }

        int[] getLookAhead() {
            int[] nArray = new int[this.lookAhead.length];
            int n = 0;
            int n2 = this.bufPtr;
            while (n2 != this.lookAhead.length) {
                nArray[n++] = this.lookAhead[n2];
                ++n2;
            }
            int n3 = 0;
            while (n3 != this.bufPtr) {
                nArray[n++] = this.lookAhead[n3];
                ++n3;
            }
            return nArray;
        }

        public int read() throws IOException {
            int n = this.in.read();
            if (n >= 0) {
                int n2 = this.lookAhead[this.bufPtr];
                this.lookAhead[this.bufPtr] = n;
                this.bufPtr = (this.bufPtr + 1) % this.lookAhead.length;
                return n2;
            }
            return -1;
        }
    }
}

