/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.Util;
import org.bouncycastle.util.Iterable;

public class PGPEncryptedDataList
implements Iterable {
    List methods = new ArrayList();
    InputStreamPacket data;

    public PGPEncryptedDataList(InputStream inputStream) throws IOException {
        this(Util.createBCPGInputStream(inputStream, 1, 3));
    }

    public PGPEncryptedDataList(BCPGInputStream bCPGInputStream) throws IOException {
        ArrayList<Packet> arrayList = new ArrayList<Packet>();
        while (bCPGInputStream.nextPacketTag() == 1 || bCPGInputStream.nextPacketTag() == 3) {
            arrayList.add(bCPGInputStream.readPacket());
        }
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof InputStreamPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (InputStreamPacket)packet;
        int n = 0;
        while (n != arrayList.size()) {
            if (arrayList.get(n) instanceof SymmetricKeyEncSessionPacket) {
                this.methods.add(new PGPPBEEncryptedData((SymmetricKeyEncSessionPacket)arrayList.get(n), this.data));
            } else {
                this.methods.add(new PGPPublicKeyEncryptedData((PublicKeyEncSessionPacket)arrayList.get(n), this.data));
            }
            ++n;
        }
    }

    public PGPEncryptedDataList(byte[] byArray) throws IOException {
        this(Util.createBCPGInputStream(new ByteArrayInputStream(byArray), 1, 3));
    }

    public PGPEncryptedData get(int n) {
        return (PGPEncryptedData)this.methods.get(n);
    }

    public Iterator getEncryptedDataObjects() {
        return this.methods.iterator();
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    public Iterator iterator() {
        return this.getEncryptedDataObjects();
    }

    public int size() {
        return this.methods.size();
    }
}

