/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class PGPKeyRingGenerator {
    List keys = new ArrayList();
    private PBESecretKeyEncryptor keyEncryptor;
    private PGPDigestCalculator checksumCalculator;
    private PGPKeyPair masterKey;
    private PGPSignatureSubpacketVector hashedPcks;
    private PGPSignatureSubpacketVector unhashedPcks;
    private PGPContentSignerBuilder keySignerBuilder;

    public PGPKeyRingGenerator(int n, PGPKeyPair pGPKeyPair, String string, PGPDigestCalculator pGPDigestCalculator, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this.masterKey = pGPKeyPair;
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        this.hashedPcks = pGPSignatureSubpacketVector;
        this.unhashedPcks = pGPSignatureSubpacketVector2;
        this.keys.add(new PGPSecretKey(n, pGPKeyPair, string, pGPDigestCalculator, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, pGPContentSignerBuilder, pBESecretKeyEncryptor));
    }

    public PGPKeyRingGenerator(PGPKeyPair pGPKeyPair, PGPDigestCalculator pGPDigestCalculator, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator;
        this.masterKey = pGPKeyPair;
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        this.hashedPcks = pGPSignatureSubpacketVector;
        this.unhashedPcks = pGPSignatureSubpacketVector2;
        try {
            pGPSignatureGenerator = new PGPSignatureGenerator(pGPContentSignerBuilder);
        }
        catch (Exception exception) {
            throw new PGPException("creating signature generator: " + exception, exception);
        }
        pGPSignatureGenerator.init(31, pGPKeyPair.getPrivateKey());
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
        pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
        PGPSecretKey pGPSecretKey = new PGPSecretKey(pGPKeyPair.getPrivateKey(), pGPKeyPair.getPublicKey(), pGPDigestCalculator, true, pBESecretKeyEncryptor);
        PGPPublicKey pGPPublicKey = pGPSecretKey.getPublicKey();
        try {
            PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(pGPKeyPair.getPublicKey());
            pGPPublicKey = PGPPublicKey.addCertification(pGPPublicKey, pGPSignature);
        }
        catch (Exception exception) {
            throw new PGPException("exception doing direct-key signature: " + exception, exception);
        }
        pGPSecretKey = PGPSecretKey.replacePublicKey(pGPSecretKey, pGPPublicKey);
        this.keys.add(pGPSecretKey);
    }

    public PGPKeyRingGenerator(PGPSecretKeyRing pGPSecretKeyRing, PBESecretKeyDecryptor pBESecretKeyDecryptor, PGPDigestCalculator pGPDigestCalculator, PGPContentSignerBuilder pGPContentSignerBuilder, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        this.masterKey = new PGPKeyPair(pGPSecretKeyRing.getPublicKey(), pGPSecretKeyRing.getSecretKey().extractPrivateKey(pBESecretKeyDecryptor));
        this.keyEncryptor = pBESecretKeyEncryptor;
        this.checksumCalculator = pGPDigestCalculator;
        this.keySignerBuilder = pGPContentSignerBuilder;
        PGPSignature pGPSignature = (PGPSignature)pGPSecretKeyRing.getPublicKey().getSignatures().next();
        ArrayList<SignatureSubpacket> arrayList = new ArrayList<SignatureSubpacket>();
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets();
        int n = 0;
        while (n != pGPSignatureSubpacketVector.size()) {
            if (pGPSignatureSubpacketVector.packets[n].getType() != 2) {
                arrayList.add(pGPSignatureSubpacketVector.packets[n]);
            }
            ++n;
        }
        this.hashedPcks = new PGPSignatureSubpacketVector(arrayList.toArray(new SignatureSubpacket[arrayList.size()]));
        this.unhashedPcks = pGPSignature.getUnhashedSubPackets();
        this.keys.addAll(pGPSecretKeyRing.keys);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair) throws PGPException {
        this.addSubKey(pGPKeyPair, this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2) throws PGPException {
        this.addSubKey(pGPKeyPair, pGPSignatureSubpacketVector, pGPSignatureSubpacketVector2, null);
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPSignatureSubpacketVector pGPSignatureSubpacketVector, PGPSignatureSubpacketVector pGPSignatureSubpacketVector2, PGPContentSignerBuilder pGPContentSignerBuilder) throws PGPException {
        try {
            Object object;
            Object object2;
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.keySignerBuilder);
            pGPSignatureGenerator.init(24, this.masterKey.getPrivateKey());
            if (pGPContentSignerBuilder != null) {
                object2 = new PGPSignatureGenerator(pGPContentSignerBuilder);
                ((PGPSignatureGenerator)object2).init(25, pGPKeyPair.getPrivateKey());
                object = new PGPSignatureSubpacketGenerator(pGPSignatureSubpacketVector);
                ((PGPSignatureSubpacketGenerator)object).addEmbeddedSignature(false, ((PGPSignatureGenerator)object2).generateCertification(this.masterKey.getPublicKey(), pGPKeyPair.getPublicKey()));
                pGPSignatureGenerator.setHashedSubpackets(((PGPSignatureSubpacketGenerator)object).generate());
            } else {
                pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
            }
            pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketVector2);
            object2 = new ArrayList();
            object2.add(pGPSignatureGenerator.generateCertification(this.masterKey.getPublicKey(), pGPKeyPair.getPublicKey()));
            object = new PGPPublicKey(pGPKeyPair.getPublicKey(), null, (List)object2);
            ((PGPPublicKey)object).publicPk = new PublicSubkeyPacket(((PGPPublicKey)object).getAlgorithm(), ((PGPPublicKey)object).getCreationTime(), ((PGPPublicKey)object).publicPk.getKey());
            this.keys.add(new PGPSecretKey(pGPKeyPair.getPrivateKey(), (PGPPublicKey)object, this.checksumCalculator, this.keyEncryptor));
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception adding subkey: ", exception);
        }
    }

    public void addSubKey(PGPKeyPair pGPKeyPair, PGPContentSignerBuilder pGPContentSignerBuilder) throws PGPException {
        this.addSubKey(pGPKeyPair, this.hashedPcks, this.unhashedPcks, pGPContentSignerBuilder);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator iterator = this.keys.iterator();
        ArrayList<PGPPublicKey> arrayList = new ArrayList<PGPPublicKey>();
        arrayList.add(((PGPSecretKey)iterator.next()).getPublicKey());
        while (iterator.hasNext()) {
            arrayList.add(((PGPSecretKey)iterator.next()).getPublicKey());
        }
        return new PGPPublicKeyRing(arrayList);
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }
}

