/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.LiteralDataPacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.openpgp.Util;

public class PGPLiteralData {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final char MIME = 'm';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = new Date(0L);
    LiteralDataPacket data;

    public PGPLiteralData(InputStream inputStream) throws IOException {
        this(Util.createBCPGInputStream(inputStream, 11));
    }

    public PGPLiteralData(BCPGInputStream bCPGInputStream) throws IOException {
        Packet packet = bCPGInputStream.readPacket();
        if (!(packet instanceof LiteralDataPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (LiteralDataPacket)packet;
    }

    public PGPLiteralData(byte[] byArray) throws IOException {
        this(Util.createBCPGInputStream(new ByteArrayInputStream(byArray), 11));
    }

    public InputStream getDataStream() {
        return this.getInputStream();
    }

    public String getFileName() {
        return this.data.getFileName();
    }

    public int getFormat() {
        return this.data.getFormat();
    }

    public InputStream getInputStream() {
        return this.data.getInputStream();
    }

    public Date getModificationTime() {
        return new Date(this.data.getModificationTime());
    }

    public byte[] getRawFileName() {
        return this.data.getRawFileName();
    }
}

