/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;

public class PGPOnePassSignature {
    private OnePassSignaturePacket sigPack;
    private int signatureType;
    private PGPContentVerifier verifier;
    private byte lastb;
    private OutputStream sigOut;

    PGPOnePassSignature(BCPGInputStream bCPGInputStream) throws IOException, PGPException {
        this(PGPOnePassSignature.cast(bCPGInputStream.readPacket()));
    }

    PGPOnePassSignature(OnePassSignaturePacket onePassSignaturePacket) throws PGPException {
        this.sigPack = onePassSignaturePacket;
        this.signatureType = onePassSignaturePacket.getSignatureType();
    }

    private void blockUpdate(byte[] byArray, int n, int n2) {
        try {
            this.sigOut.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException(iOException.getMessage(), iOException);
        }
    }

    private void byteUpdate(byte by) {
        try {
            this.sigOut.write(by);
        }
        catch (IOException iOException) {
            throw new PGPRuntimeOperationException(iOException.getMessage(), iOException);
        }
    }

    private static OnePassSignaturePacket cast(Packet packet) throws IOException {
        if (!(packet instanceof OnePassSignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (OnePassSignaturePacket)packet;
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.sigPack);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public int getHashAlgorithm() {
        return this.sigPack.getHashAlgorithm();
    }

    public int getKeyAlgorithm() {
        return this.sigPack.getKeyAlgorithm();
    }

    public long getKeyID() {
        return this.sigPack.getKeyID();
    }

    public int getSignatureType() {
        return this.sigPack.getSignatureType();
    }

    public void init(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, PGPPublicKey pGPPublicKey) throws PGPException {
        PGPContentVerifierBuilder pGPContentVerifierBuilder = pGPContentVerifierBuilderProvider.get(this.sigPack.getKeyAlgorithm(), this.sigPack.getHashAlgorithm());
        this.verifier = pGPContentVerifierBuilder.build(pGPPublicKey);
        this.lastb = 0;
        this.sigOut = this.verifier.getOutputStream();
    }

    public void update(byte by) {
        if (this.signatureType == 1) {
            if (by == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (by == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(by);
            }
            this.lastb = by;
        } else {
            this.byteUpdate(by);
        }
    }

    public void update(byte[] byArray) {
        if (this.signatureType == 1) {
            int n = 0;
            while (n != byArray.length) {
                this.update(byArray[n]);
                ++n;
            }
        } else {
            this.blockUpdate(byArray, 0, byArray.length);
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.signatureType == 1) {
            int n3 = n + n2;
            int n4 = n;
            while (n4 != n3) {
                this.update(byArray[n4]);
                ++n4;
            }
        } else {
            this.blockUpdate(byArray, n, n2);
        }
    }

    public boolean verify(PGPSignature pGPSignature) throws PGPException {
        try {
            this.sigOut.write(pGPSignature.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException iOException) {
            throw new PGPException("unable to add trailer: " + iOException.getMessage(), iOException);
        }
        return this.verifier.verify(pGPSignature.getSignature());
    }
}

