/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.TeeInputStream;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket publicKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = publicKeyEncSessionPacket;
    }

    private boolean confirmCheckSum(byte[] byArray) {
        int n = 0;
        int n2 = 1;
        while (n2 != byArray.length - 2) {
            n += byArray[n2] & 0xFF;
            ++n2;
        }
        return byArray[byArray.length - 2] == (byte)(n >> 8) && byArray[byArray.length - 1] == (byte)n;
    }

    public int getAlgorithm() {
        return this.keyData.getAlgorithm();
    }

    private InputStream getDataStream(PGPDataDecryptorFactory pGPDataDecryptorFactory, PGPSessionKey pGPSessionKey) throws PGPException {
        if (pGPSessionKey.getAlgorithm() != 0) {
            try {
                int n;
                boolean bl = this.encData instanceof SymmetricEncIntegrityPacket;
                PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(bl, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
                BCPGInputStream bCPGInputStream = this.encData.getInputStream();
                this.encStream = new BCPGInputStream(pGPDataDecryptor.getInputStream(bCPGInputStream));
                if (bl) {
                    PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = this;
                    pGPPublicKeyEncryptedData.getClass();
                    this.truncStream = pGPPublicKeyEncryptedData.new PGPEncryptedData.TruncatedStream(this.encStream);
                    this.integrityCalculator = pGPDataDecryptor.getIntegrityCalculator();
                    this.encStream = new TeeInputStream((InputStream)this.truncStream, this.integrityCalculator.getOutputStream());
                }
                byte[] byArray = new byte[pGPDataDecryptor.getBlockSize()];
                int n2 = 0;
                while (n2 != byArray.length) {
                    n = this.encStream.read();
                    if (n < 0) {
                        throw new EOFException("unexpected end of stream.");
                    }
                    byArray[n2] = (byte)n;
                    ++n2;
                }
                n = this.encStream.read();
                int n3 = this.encStream.read();
                if (n < 0 || n3 < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                return this.encStream;
            }
            catch (PGPException pGPException) {
                throw pGPException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception starting decryption", exception);
            }
        }
        return this.encData.getInputStream();
    }

    public InputStream getDataStream(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        return this.getDataStream(publicKeyDataDecryptorFactory, this.getSessionKey(publicKeyDataDecryptorFactory));
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory) throws PGPException {
        return this.getDataStream(sessionKeyDataDecryptorFactory, sessionKeyDataDecryptorFactory.getSessionKey());
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public PGPSessionKey getSessionKey(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        byte[] byArray = publicKeyDataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        if (!this.confirmCheckSum(byArray)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        return new PGPSessionKey(byArray[0] & 0xFF, Arrays.copyOfRange((byte[])byArray, (int)1, (int)(byArray.length - 2)));
    }

    public int getSymmetricAlgorithm(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        byte[] byArray = publicKeyDataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        return byArray[0];
    }

    public int getVersion() {
        return this.keyData.getVersion();
    }
}

