/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.examples.PGPExampleUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class DetachedSignatureProcessor {
    private static void createSignature(String string, InputStream inputStream, OutputStream outputStream, char[] cArray, boolean bl) throws GeneralSecurityException, IOException, PGPException {
        int n;
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPSecretKey pGPSecretKey = PGPExampleUtil.readSecretKey(inputStream);
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(cArray));
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pGPSecretKey.getPublicKey().getAlgorithm(), 2).setProvider("BC"));
        pGPSignatureGenerator.init(0, pGPPrivateKey);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(outputStream);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        while ((n = ((InputStream)bufferedInputStream).read()) >= 0) {
            pGPSignatureGenerator.update((byte)n);
        }
        ((InputStream)bufferedInputStream).close();
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        if (bl) {
            outputStream.close();
        }
    }

    private static void createSignature(String string, String string2, String string3, char[] cArray, boolean bl) throws GeneralSecurityException, IOException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3));
        try {
            DetachedSignatureProcessor.createSignature(string, bufferedInputStream, bufferedOutputStream, cArray, bl);
        }
        finally {
            Object var8_7 = null;
            ((OutputStream)bufferedOutputStream).close();
            ((InputStream)bufferedInputStream).close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            if (stringArray[1].equals("-a")) {
                DetachedSignatureProcessor.createSignature(stringArray[2], stringArray[3], String.valueOf(stringArray[2]) + ".asc", stringArray[4].toCharArray(), true);
            } else {
                DetachedSignatureProcessor.createSignature(stringArray[1], stringArray[2], String.valueOf(stringArray[1]) + ".bpg", stringArray[3].toCharArray(), false);
            }
        } else if (stringArray[0].equals("-v")) {
            DetachedSignatureProcessor.verifySignature(stringArray[1], stringArray[2], stringArray[3]);
        } else {
            System.err.println("usage: DetachedSignatureProcessor [-s [-a] file keyfile passPhrase]|[-v file sigFile keyFile]");
        }
    }

    private static void verifySignature(String string, InputStream inputStream, InputStream inputStream2) throws GeneralSecurityException, IOException, PGPException {
        int n;
        PGPSignatureList pGPSignatureList;
        Object object;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream = PGPUtil.getDecoderStream(inputStream));
        Object object2 = jcaPGPObjectFactory.nextObject();
        if (object2 instanceof PGPCompressedData) {
            object = (PGPCompressedData)object2;
            jcaPGPObjectFactory = new JcaPGPObjectFactory(((PGPCompressedData)object).getDataStream());
            pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
        } else {
            pGPSignatureList = (PGPSignatureList)object2;
        }
        object = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(inputStream2), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        PGPPublicKey pGPPublicKey = ((PGPPublicKeyRingCollection)object).getPublicKey(pGPSignature.getKeyID());
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
        while ((n = ((InputStream)bufferedInputStream).read()) >= 0) {
            pGPSignature.update((byte)n);
        }
        ((InputStream)bufferedInputStream).close();
        if (pGPSignature.verify()) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static void verifySignature(String string, String string2, String string3) throws GeneralSecurityException, IOException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(string3));
        try {
            DetachedSignatureProcessor.verifySignature(string, bufferedInputStream, bufferedInputStream2);
        }
        finally {
            Object var6_5 = null;
            ((InputStream)bufferedInputStream2).close();
            ((InputStream)bufferedInputStream).close();
        }
    }
}

