/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPUtil;

public abstract class PBEKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    private char[] passPhrase;
    private PGPDigestCalculator s2kDigestCalculator;
    private S2K s2k;
    private SecureRandom random;
    private int s2kCount;

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        this(cArray, pGPDigestCalculator, 96);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        this.passPhrase = cArray;
        this.s2kDigestCalculator = pGPDigestCalculator;
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("s2kCount value outside of range 0 to 255.");
        }
        this.s2kCount = n;
    }

    protected abstract byte[] encryptSessionInfo(int var1, byte[] var2, byte[] var3) throws PGPException;

    public ContainedPacket generate(int n, byte[] byArray) throws PGPException {
        byte[] byArray2 = this.getKey(n);
        if (byArray == null) {
            return new SymmetricKeyEncSessionPacket(n, this.s2k, null);
        }
        byte[] byArray3 = new byte[byArray.length - 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
        return new SymmetricKeyEncSessionPacket(n, this.s2k, this.encryptSessionInfo(n, byArray2, byArray3));
    }

    public byte[] getKey(int n) throws PGPException {
        if (this.s2k == null) {
            byte[] byArray = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            this.s2k = new S2K(this.s2kDigestCalculator.getAlgorithm(), byArray, this.s2kCount);
        }
        return PGPUtil.makeKeyFromPassPhrase(this.s2kDigestCalculator, n, this.s2k, this.passPhrase);
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }
}

