/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Properties;

public abstract class PublicKeyKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    public static final String SESSION_KEY_OBFUSCATION_PROPERTY = "org.bouncycastle.openpgp.session_key_obfuscation";
    private PGPPublicKey pubKey;
    protected boolean sessionKeyObfuscation;

    protected PublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        switch (pGPPublicKey.getAlgorithm()) {
            case 3: {
                throw new IllegalArgumentException("Can't use an RSA_SIGN key for encryption.");
            }
            case 17: {
                throw new IllegalArgumentException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new IllegalArgumentException("Can't use ECDSA for encryption.");
            }
            default: {
                throw new IllegalArgumentException("unknown asymmetric algorithm: " + pGPPublicKey.getAlgorithm());
            }
            case 1: 
            case 2: 
            case 16: 
            case 18: 
            case 20: 
        }
        this.pubKey = pGPPublicKey;
        this.sessionKeyObfuscation = PublicKeyKeyEncryptionMethodGenerator.getSessionKeyObfuscationDefault();
    }

    private byte[] convertToEncodedMPI(byte[] byArray) throws PGPException {
        try {
            return new MPInteger(new BigInteger(1, byArray)).getEncoded();
        }
        catch (IOException iOException) {
            throw new PGPException("Invalid MPI encoding: " + iOException.getMessage(), iOException);
        }
    }

    protected abstract byte[] encryptSessionInfo(PGPPublicKey var1, byte[] var2) throws PGPException;

    public ContainedPacket generate(int n, byte[] byArray) throws PGPException {
        return new PublicKeyEncSessionPacket(this.pubKey.getKeyID(), this.pubKey.getAlgorithm(), this.processSessionInfo(this.encryptSessionInfo(this.pubKey, byArray)));
    }

    private static boolean getSessionKeyObfuscationDefault() {
        return Properties.isOverrideSetTo((String)SESSION_KEY_OBFUSCATION_PROPERTY, (boolean)false) ^ true;
    }

    public byte[][] processSessionInfo(byte[] byArray) throws PGPException {
        byte[][] byArray2;
        switch (this.pubKey.getAlgorithm()) {
            case 1: 
            case 2: {
                byArray2 = new byte[][]{this.convertToEncodedMPI(byArray)};
                break;
            }
            case 16: 
            case 20: {
                byte[] byArray3 = new byte[byArray.length / 2];
                byte[] byArray4 = new byte[byArray.length / 2];
                System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
                System.arraycopy(byArray, byArray3.length, byArray4, 0, byArray4.length);
                byArray2 = new byte[][]{this.convertToEncodedMPI(byArray3), this.convertToEncodedMPI(byArray4)};
                break;
            }
            case 18: {
                byArray2 = new byte[][]{byArray};
                break;
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
            }
        }
        return byArray2;
    }

    public PublicKeyKeyEncryptionMethodGenerator setSessionKeyObfuscation(boolean bl) {
        this.sessionKeyObfuscation = bl;
        return this;
    }
}

