/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.SignerOutputStream;

public class BcPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new BcPGPContentVerifierBuilder(n, n2);
    }

    private class BcPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public BcPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        static /* synthetic */ int access$0(BcPGPContentVerifierBuilder bcPGPContentVerifierBuilder) {
            return bcPGPContentVerifierBuilder.hashAlgorithm;
        }

        static /* synthetic */ int access$1(BcPGPContentVerifierBuilder bcPGPContentVerifierBuilder) {
            return bcPGPContentVerifierBuilder.keyAlgorithm;
        }

        public PGPContentVerifier build(PGPPublicKey pGPPublicKey) throws PGPException {
            AsymmetricKeyParameter asymmetricKeyParameter = BcPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey);
            Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, (CipherParameters)asymmetricKeyParameter);
            signer.init(false, (CipherParameters)asymmetricKeyParameter);
            return new PGPContentVerifier(pGPPublicKey, signer, this){
                private final /* synthetic */ Signer val$signer;
                private final /* synthetic */ PGPPublicKey val$publicKey;
                private final /* synthetic */ BcPGPContentVerifierBuilder this$1;
                {
                    this.val$publicKey = pGPPublicKey;
                    this.val$signer = signer;
                    this.this$1 = bcPGPContentVerifierBuilder;
                }

                public int getHashAlgorithm() {
                    return BcPGPContentVerifierBuilder.access$0(this.this$1);
                }

                public int getKeyAlgorithm() {
                    return BcPGPContentVerifierBuilder.access$1(this.this$1);
                }

                public long getKeyID() {
                    return this.val$publicKey.getKeyID();
                }

                public OutputStream getOutputStream() {
                    return new SignerOutputStream(this.val$signer);
                }

                public boolean verify(byte[] byArray) {
                    return this.val$signer.verifySignature(byArray);
                }
            };
        }
    }
}

