/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPDigestCalculatorProviderBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcaPGPDigestCalculatorProviderBuilder() {
    }

    JcaPGPDigestCalculatorProviderBuilder(OperatorHelper operatorHelper) {
        this.helper = operatorHelper;
    }

    public PGPDigestCalculatorProvider build() throws PGPException {
        return new PGPDigestCalculatorProvider(){

            public PGPDigestCalculator get(int n) throws PGPException {
                DigestOutputStream digestOutputStream;
                MessageDigest messageDigest;
                try {
                    messageDigest = JcaPGPDigestCalculatorProviderBuilder.this.helper.createDigest(n);
                    digestOutputStream = new DigestOutputStream(messageDigest);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new PGPException("exception on setup: " + generalSecurityException, generalSecurityException);
                }
                return new PGPDigestCalculator(n, messageDigest, digestOutputStream){
                    private final /* synthetic */ MessageDigest val$dig;
                    private final /* synthetic */ DigestOutputStream val$stream;
                    private final /* synthetic */ int val$algorithm;
                    {
                        this.val$algorithm = n;
                        this.val$dig = messageDigest;
                        this.val$stream = digestOutputStream;
                    }

                    public int getAlgorithm() {
                        return this.val$algorithm;
                    }

                    public byte[] getDigest() {
                        return this.val$stream.getDigest();
                    }

                    public OutputStream getOutputStream() {
                        return this.val$stream;
                    }

                    public void reset() {
                        this.val$dig.reset();
                    }
                };
            }
        };
    }

    public JcaPGPDigestCalculatorProviderBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    public JcaPGPDigestCalculatorProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    private class DigestOutputStream
    extends OutputStream {
        private MessageDigest dig;

        DigestOutputStream(MessageDigest messageDigest) {
            this.dig = messageDigest;
        }

        byte[] getDigest() {
            return this.dig.digest();
        }

        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }

        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }
    }
}

