/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.Provider;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JceSessionKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public SessionKeyDataDecryptorFactory build(PGPSessionKey pGPSessionKey) {
        return new JceSessionKeyDataDecryptorFactory(this.helper, pGPSessionKey);
    }

    public JceSessionKeyDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public JceSessionKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    private static class JceSessionKeyDataDecryptorFactory
    implements SessionKeyDataDecryptorFactory {
        private final OperatorHelper helper;
        private final PGPSessionKey sessionKey;

        public JceSessionKeyDataDecryptorFactory(OperatorHelper operatorHelper, PGPSessionKey pGPSessionKey) {
            this.helper = operatorHelper;
            this.sessionKey = pGPSessionKey;
        }

        public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
            return this.helper.createDataDecryptor(bl, n, byArray);
        }

        public PGPSessionKey getSessionKey() {
            return this.sessionKey;
        }

        public byte[] recoverSessionData(int n, byte[] byArray, byte[] byArray2) throws PGPException {
            throw new IllegalStateException("trying to recover session data from session key!");
        }

        public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
            throw new IllegalStateException("trying to recover session data from session key!");
        }
    }
}

