/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;

class SHA1PGPDigestCalculator
implements PGPDigestCalculator {
    private MessageDigest digest;

    SHA1PGPDigestCalculator() {
        try {
            this.digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("cannot find SHA-1: " + noSuchAlgorithmException.getMessage());
        }
    }

    public int getAlgorithm() {
        return 2;
    }

    public byte[] getDigest() {
        return this.digest.digest();
    }

    public OutputStream getOutputStream() {
        return OutputStreamFactory.createStream((MessageDigest)this.digest);
    }

    public void reset() {
        this.digest.reset();
    }
}

