/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PGPArmoredTest
extends SimpleTest {
    byte[] sample = Base64.decode((String)"mQGiBEA83v0RBADzKVLVCnpWQxX0LCsevw/3OLs0H7MOcLBQ4wMO9sYmzGYnxpVj+4e4PiCP7QBayWyy4lugL6Lnw7tESvq3A4v3fefcxaCTkJrryiKn4+Cgy5rIBbrSKNtCEhVi7xjtdnDjP5kFKgHYjVOeIKn4Cz/yzPG3qz75kDknldLfyHxp2wCgwW1vAE5EnZU4/UmY7l8kTNkMltMEAJP4/uY4zcRwLI9Q2raPqAOJTYLd7h+3k/BxI0gIw96niQ3KmUZDlobbWBI+VHM6H99vcttKU3BgevNf8M9Gx/AbtW3SS4De64wNSU3189XDG8vXf0vuyW/K6Pcrb8exJWY0E1zZQ1WXT0gZW0kH3g5ro//Tusuil9q2lVLF2ovJA/0W+57bPzi318dWeNs0tTq6Njbc/GTGFUAVJ8Ss5v2u6h7gyJ1DB334ExF/UdqZGldp0ugkEXaSwBa2R7d3HBgaYcoPCk1TrovZzEY8gm7JNVy7GW6mdOZuDOHTxyADEEP2JPxh6eRcZbzhGuJuYIifIIeLOTI5Dc4XKeV32a+bWrQidGVzdCAoVGVzdCBrZXkpIDx0ZXN0QHViaWNhbGwuY29tPohkBBMRAgAkBQJAPN79AhsDBQkB4TOABgsJCAcDAgMVAgMDFgIBAh4BAheAAAoJEJh8Njfhe8KmGDcAoJWr8xgPr75y/Cp1kKn12oCCOb8zAJ4pxSvk4K6tB2jYbdeSrmoWBZLdMLACAAC5AQ0EQDzfARAEAJeUAPvUzJJbKcc55Iyb13+Gfb8xBWE3HinQzhGr1v6A1aIZbRj47UPAD/tQxwz8VAwJySx82ggNLxCk4jW9YtTL3uZqfczsJngV25GoIN10f4/j2BVqZAaX3q79a3eMiql1T0oEAGmD7tO1LkTvWfm3VvA0+t8/6ZeRLEiIqAOHAAQNBACD0mVMlAUgd7REYy/1mL99Zlu9XU0uKyUex99sJNrcx1aj8rIiZtWaHz6CN1XptdwpDeSYEOFZ0PSuqH9ByM3OfjU/ya0//xdvhwYXupn6P1Kep85efMBA9jUv/DeBOzRWMFG6sC6yk8NGG7Swea7EHKeQI40G3jgO/+xANtMyTIhPBBgRAgAPBQJAPN8BAhsMBQkB4TOAAAoJEJh8Njfhe8KmG7kAn00mTPGJCWqmskmzgdzeky5fWd7rAKCNCp3uZJhfg0htdgAfIy8ppm05vLACAAA=");
    byte[] marker = Hex.decode((String)"2d2d2d2d2d454e4420504750205055424c4943204b455920424c4f434b2d2d2d2d2d");
    private static final String blankLineData = "-----BEGIN PGP MESSAGE-----\nVersion: BCPG v1.32\nComment: A dummy message\n \t \t\nSGVsbG8gV29ybGQh\n=d9Xi\n-----END PGP MESSAGE-----\n";

    private void blankLineTest() throws Exception {
        int n;
        byte[] byArray = Strings.toByteArray((String)blankLineData);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = armoredInputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        byte[] byArray2 = Strings.toByteArray((String)"Hello World!");
        if (!Arrays.areEqual((byte[])byArray2, (byte[])byteArrayOutputStream.toByteArray())) {
            this.fail("Incorrect message retrieved in blank line test.");
        }
    }

    public String getName() {
        return "PGPArmoredTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest((Test)new PGPArmoredTest());
    }

    private int markerCount(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            if (byArray[n] == 45) {
                int n3 = 0;
                while (n3 < this.marker.length) {
                    if (byArray[n + n3] != this.marker[n3]) break;
                    ++n3;
                }
                if (n3 == this.marker.length) {
                    ++n2;
                }
                n += n3;
                continue;
            }
            ++n;
        }
        return n2;
    }

    public void performTest() throws Exception {
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
        armoredOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length != 0) {
            this.fail("No data should have been written");
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
        armoredOutputStream.write(this.sample);
        armoredOutputStream.close();
        armoredOutputStream.close();
        int n = this.markerCount(byteArrayOutputStream.toByteArray());
        if (n < 1) {
            this.fail("No end marker found");
        }
        if (n > 1) {
            this.fail("More than one end marker found");
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
        armoredOutputStream.write(this.sample);
        armoredOutputStream.close();
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(armoredInputStream);
        int n2 = 0;
        while (jcaPGPObjectFactory.nextObject() != null) {
            ++n2;
        }
        if (n2 != 1) {
            this.fail("wrong number of objects found: " + n2);
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
        armoredOutputStream.write(this.sample);
        armoredOutputStream.write(this.sample);
        armoredOutputStream.close();
        armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        jcaPGPObjectFactory = new JcaPGPObjectFactory(armoredInputStream);
        n2 = 0;
        while (jcaPGPObjectFactory.nextObject() != null) {
            ++n2;
        }
        if (n2 != 2) {
            this.fail("wrong number of objects found: " + n2);
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
        armoredOutputStream.write(this.sample);
        armoredOutputStream.close();
        armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
        armoredOutputStream.write(this.sample);
        armoredOutputStream.close();
        armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        n2 = 0;
        do {
            bl = false;
            jcaPGPObjectFactory = new JcaPGPObjectFactory(armoredInputStream);
            while (jcaPGPObjectFactory.nextObject() != null) {
                bl = true;
                ++n2;
            }
        } while (bl);
        if (n2 != 2) {
            this.fail("wrong number of objects found: " + n2);
        }
        this.blankLineTest();
        this.pgpUtilTest();
        this.repeatHeaderTest();
    }

    private void pgpUtilTest() throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Strings.toByteArray((String)"abcde"));
        try {
            PGPUtil.getDecoderStream(byteArrayInputStream);
            this.fail("no exception");
        }
        catch (IOException iOException) {}
    }

    private void repeatHeaderTest() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
        armoredOutputStream.setHeader("Comment", "Line 1");
        armoredOutputStream.addHeader("Comment", "Line 2");
        armoredOutputStream.write(this.sample);
        armoredOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream, true);
        String[] stringArray = armoredInputStream.getArmorHeaders();
        int n = 0;
        int n2 = 0;
        while (n2 != stringArray.length) {
            if (stringArray[n2].indexOf("Comment: ") == 0) {
                ++n;
            }
            ++n2;
        }
        this.isEquals(2, n);
    }
}

