/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.openpgp.PGPCanonicalizedDataGenerator;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PGPCanonicalizedDataGeneratorTest
extends SimpleTest {
    private void checkBackingConversion(String string, String string2) throws IOException {
        PGPCanonicalizedDataGenerator pGPCanonicalizedDataGenerator = new PGPCanonicalizedDataGenerator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        File file = File.createTempFile("bcpgp", ".back");
        OutputStream outputStream = pGPCanonicalizedDataGenerator.open((OutputStream)byteArrayOutputStream, 't', "_CONSOLE", new Date(), file);
        outputStream.write(Strings.toByteArray((String)string));
        outputStream.close();
        PGPLiteralData pGPLiteralData = new PGPLiteralData(byteArrayOutputStream.toByteArray());
        this.isEquals(string2, Strings.fromByteArray((byte[])Streams.readAll((InputStream)pGPLiteralData.getDataStream())));
        file.delete();
    }

    private void checkBinaryConversion(String string, String string2) throws IOException {
        PGPCanonicalizedDataGenerator pGPCanonicalizedDataGenerator = new PGPCanonicalizedDataGenerator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = pGPCanonicalizedDataGenerator.open(byteArrayOutputStream, 'b', "_CONSOLE", new Date());
        outputStream.write(Strings.toByteArray((String)string));
        outputStream.close();
        PGPLiteralData pGPLiteralData = new PGPLiteralData(byteArrayOutputStream.toByteArray());
        this.isEquals(string, Strings.fromByteArray((byte[])Streams.readAll((InputStream)pGPLiteralData.getDataStream())));
    }

    private void checkConversion(String string, String string2) throws IOException {
        PGPCanonicalizedDataGenerator pGPCanonicalizedDataGenerator = new PGPCanonicalizedDataGenerator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = pGPCanonicalizedDataGenerator.open(byteArrayOutputStream, 't', "_CONSOLE", new Date());
        outputStream.write(Strings.toByteArray((String)string));
        outputStream.close();
        PGPLiteralData pGPLiteralData = new PGPLiteralData(byteArrayOutputStream.toByteArray());
        this.isEquals(string2, Strings.fromByteArray((byte[])Streams.readAll((InputStream)pGPLiteralData.getDataStream())));
    }

    private void checkIndefiniteConversion(String string, String string2) throws IOException {
        PGPCanonicalizedDataGenerator pGPCanonicalizedDataGenerator = new PGPCanonicalizedDataGenerator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = pGPCanonicalizedDataGenerator.open((OutputStream)byteArrayOutputStream, 't', "_CONSOLE", new Date(), new byte[16]);
        outputStream.write(Strings.toByteArray((String)string));
        outputStream.close();
        PGPLiteralData pGPLiteralData = new PGPLiteralData(byteArrayOutputStream.toByteArray());
        this.isEquals(string2, Strings.fromByteArray((byte[])Streams.readAll((InputStream)pGPLiteralData.getDataStream())));
    }

    public String getName() {
        return "PGPCanonicalizedDataGeneratorTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest((Test)new PGPCanonicalizedDataGeneratorTest());
    }

    public void performTest() throws Exception {
        String string = "Now is the time for all good men\nTo come to the aid of the party\n";
        String string2 = "Now is the time for all good men\rTo come to the aid of the party\r";
        String string3 = "Now is the time for all good men\r\nTo come to the aid of the party\r\n";
        this.checkConversion(string, string3);
        this.checkConversion(string2, string3);
        this.checkConversion(string3, string3);
        this.checkIndefiniteConversion(string, string3);
        this.checkIndefiniteConversion(string2, string3);
        this.checkIndefiniteConversion(string3, string3);
        this.checkBackingConversion(string, string3);
        this.checkBackingConversion(string2, string3);
        this.checkBackingConversion(string3, string3);
        this.checkBinaryConversion(string, string3);
        this.checkBinaryConversion(string2, string3);
        this.checkBinaryConversion(string3, string3);
    }
}

