/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PGPClearSignedSignatureTest
extends SimpleTest {
    byte[] publicKey = Base64.decode((String)"mQELBEQh2+wBCAD26kte0hO6flr7Y2aetpPYutHY4qsmDPy+GwmmqVeCDkX+r1g7DuFbMhVeu0NkKDnVl7GsJ9VarYsFYyqu0NzLa9XS2qlTIkmJV+2/xKa1tzjn18fT/cnAWL88ZLCOWUr241aPVhLuIc6vpHnySpEMkCh4rvMaimnTrKwO42kgeDGd5cXfs4J4ovRcTbc4hmU2BRVsRjiYMZWWx0kkyL2zDVyaJSs4yVX7Jm4/LSR1uC/wDT0IJJuZT/gQPCMJNMEsVCziRgYkAxQK3OWojPSuv4rXpyd4Gvo6IbvyTgIskfpSkCnQtORNLIudQSuK7pW+LkL62N+ohuKdMvdxauOnAAYptBNnZ2dnZ2dnZyA8Z2dnQGdnZ2c+iQE2BBMBAgAgBQJEIdvsAhsDBgsJCAcDAgQVAggDBBYCAwECHgECF4AACgkQ4M/Ier3f9xagdAf/fbKWBjLQM8xR7JkRP4ri8YKOQPhK+VrddGUD59/wzVnvaGyl9MZE7TXFUeniQq5iXKnm22EQbYchv2Jcxyt2H9yptpzyh4tP6tEHl1C887p2J4qe7F2ATua9CzVGwXQSUbKtj2fgUZP5SsNp25guhPiZdtkf2sHMeiotmykFErzqGMrvOAUThrO63GiYsRk4hF6rcQ01d+EUVpY/sBcCxgNyOiB7a84sDtrxnX5BTEZDTEj8LvuEyEV3TMUuAjx17Eyd+9JtKzwV4v3hlTaWOvGro9nPS7YaPuG+RtufzXCUJPbPfTjTvtGOqvEzoztls8tuWA0OGHba9XfX9rfgorACAAM=");
    byte[] secretKey = Base64.decode((String)"lQOWBEQh2+wBCAD26kte0hO6flr7Y2aetpPYutHY4qsmDPy+GwmmqVeCDkX+r1g7DuFbMhVeu0NkKDnVl7GsJ9VarYsFYyqu0NzLa9XS2qlTIkmJV+2/xKa1tzjn18fT/cnAWL88ZLCOWUr241aPVhLuIc6vpHnySpEMkCh4rvMaimnTrKwO42kgeDGd5cXfs4J4ovRcTbc4hmU2BRVsRjiYMZWWx0kkyL2zDVyaJSs4yVX7Jm4/LSR1uC/wDT0IJJuZT/gQPCMJNMEsVCziRgYkAxQK3OWojPSuv4rXpyd4Gvo6IbvyTgIskfpSkCnQtORNLIudQSuK7pW+LkL62N+ohuKdMvdxauOnAAYpAAf+JCJJeAXEcrTVHotsrRR5idzmg6RK/1MSQUijwPmP7ZGy1BmpAmYUfbxnB56GvXyFV3Pbj9PgyJZGS7cY+l0BF4ZqN9USiQtC9OEpCVT5LVMCFXC/lahC/O3EkjQy0CYK+GwyIXa+Flxcr460L/Hvw2ZEXJZ6/aPdiR+DU1l5h99Zw8V1Y625MpfwN6ufJfqE0HLoqIjlqCfi1iwcKAK2oVx2SwnT1W0NwUUXjagGhD2sVzJVpLqhlwmS0A+RE9Niqrf80/zwE7QNDF2DtHxmMHJ3RY/pfu5u1rrFg9YElmS60mzOe31CaD8Li0k5YCJBPnmvM9mN3/DWWprSZZKtmQQA96C2/VJF5EWm+/Yxi5J06dG6Bkz311Ui4p2zHm9/4GvTPCIKNpGx9Zn47YFD3tIg3fIBVPOEktG38pEPx++dSSFF9Ep5UgmYFNOKNUVq3yGpatBtCQBXb1LQLAMBJCJ5TQmk68hMOEaqjMHSOa18cS63INgA6okb/ueAKIHxYQcEAP9DaXu5n9dZQw7pshbNNu/T5IP0/D/wqM+W5r+j4P1N7PgiAnfKA4JjKrUgl8PGnI2qM/Qu+g3qK++cF1ESHasnJPjvNvY+cfti06xnJVtCB/EBOA2UZkAr//Tqa76xEwYAWRBnO2Y+KIVOT+nMiBFkjPTrNAD6fSr1O4aOueBhBAC6aA35IfjC2h5MYk8+Z+S4io2omRxUZ/dUuS+kITvWph2e4DT28Xpycpl2n1Pa5dCDO1lRqe/5JnaDYDKqxfmF5tTG8GR4d4nVawwLlifXH5Ll7t5NcukGNMCsGuQAHMy0QHuAaOvMdLs5kGHn8VxfKEVKhVrXsvJSwyXXSBtMtUcRtBNnZ2dnZ2dnZyA8Z2dnQGdnZ2c+iQE2BBMBAgAgBQJEIdvsAhsDBgsJCAcDAgQVAggDBBYCAwECHgECF4AACgkQ4M/Ier3f9xagdAf/fbKWBjLQM8xR7JkRP4ri8YKOQPhK+VrddGUD59/wzVnvaGyl9MZE7TXFUeniQq5iXKnm22EQbYchv2Jcxyt2H9yptpzyh4tP6tEHl1C887p2J4qe7F2ATua9CzVGwXQSUbKtj2fgUZP5SsNp25guhPiZdtkf2sHMeiotmykFErzqGMrvOAUThrO63GiYsRk4hF6rcQ01d+EUVpY/sBcCxgNyOiB7a84sDtrxnX5BTEZDTEj8LvuEyEV3TMUuAjx17Eyd+9JtKzwV4v3hlTaWOvGro9nPS7YaPuG+RtufzXCUJPbPfTjTvtGOqvEzoztls8tuWA0OGHba9XfX9rfgorACAAA=");
    String crOnlyMessage = "\r hello world!\r\r- dash\r";
    String nlOnlyMessage = "\n hello world!\n\n- dash\n";
    String crNlMessage = "\r\n hello world!\r\n\r\n- dash\r\n";
    String crOnlySignedMessage = "-----BEGIN PGP SIGNED MESSAGE-----\rHash: SHA256\r\r\r hello world!\r\r- - dash\r-----BEGIN PGP SIGNATURE-----\rVersion: GnuPG v1.4.2.1 (GNU/Linux)\r\riQEVAwUBRCNS8+DPyHq93/cWAQi6SwgAj3ItmSLr/sd/ixAQLW7/12jzEjfNmFDt\rWOZpJFmXj0fnMzTrOILVnbxHv2Ru+U8Y1K6nhzFSR7d28n31/XGgFtdohDEaFJpx\rFl+KvASKIonnpEDjFJsPIvT1/G/eCPalwO9IuxaIthmKj0z44SO1VQtmNKxdLAfK\r+xTnXGawXS1WUE4CQGPM45mIGSqXcYrLtJkAg3jtRa8YRUn2d7b2BtmWH+jVaVuC\rhNrXYv7iHFOu25yRWhUQJisvdC13D/gKIPRvARXPgPhAC2kovIy6VS8tDoyG6Hm5\rdMgLEGhmqsgaetVq1ZIuBZj5S4j2apBJCDpF6GBfpBOfwIZs0Tpmlw==\r=84Nd\r-----END PGP SIGNATURE-----\r";
    String nlOnlySignedMessage = "-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA256\n\n\n hello world!\n\n- - dash\n-----BEGIN PGP SIGNATURE-----\nVersion: GnuPG v1.4.2.1 (GNU/Linux)\n\niQEVAwUBRCNS8+DPyHq93/cWAQi6SwgAj3ItmSLr/sd/ixAQLW7/12jzEjfNmFDt\nWOZpJFmXj0fnMzTrOILVnbxHv2Ru+U8Y1K6nhzFSR7d28n31/XGgFtdohDEaFJpx\nFl+KvASKIonnpEDjFJsPIvT1/G/eCPalwO9IuxaIthmKj0z44SO1VQtmNKxdLAfK\n+xTnXGawXS1WUE4CQGPM45mIGSqXcYrLtJkAg3jtRa8YRUn2d7b2BtmWH+jVaVuC\nhNrXYv7iHFOu25yRWhUQJisvdC13D/gKIPRvARXPgPhAC2kovIy6VS8tDoyG6Hm5\ndMgLEGhmqsgaetVq1ZIuBZj5S4j2apBJCDpF6GBfpBOfwIZs0Tpmlw==\n=84Nd\n-----END PGP SIGNATURE-----\n";
    String crNlSignedMessage = "-----BEGIN PGP SIGNED MESSAGE-----\r\nHash: SHA256\r\n\r\n\r\n hello world!\r\n\r\n- - dash\r\n-----BEGIN PGP SIGNATURE-----\r\nVersion: GnuPG v1.4.2.1 (GNU/Linux)\r\n\r\niQEVAwUBRCNS8+DPyHq93/cWAQi6SwgAj3ItmSLr/sd/ixAQLW7/12jzEjfNmFDt\r\nWOZpJFmXj0fnMzTrOILVnbxHv2Ru+U8Y1K6nhzFSR7d28n31/XGgFtdohDEaFJpx\r\nFl+KvASKIonnpEDjFJsPIvT1/G/eCPalwO9IuxaIthmKj0z44SO1VQtmNKxdLAfK\r\n+xTnXGawXS1WUE4CQGPM45mIGSqXcYrLtJkAg3jtRa8YRUn2d7b2BtmWH+jVaVuC\r\nhNrXYv7iHFOu25yRWhUQJisvdC13D/gKIPRvARXPgPhAC2kovIy6VS8tDoyG6Hm5\r\ndMgLEGhmqsgaetVq1ZIuBZj5S4j2apBJCDpF6GBfpBOfwIZs0Tpmlw==\r\n=84Nd\r-----END PGP SIGNATURE-----\r\n";
    String crNlSignedMessageTrailingWhiteSpace = "-----BEGIN PGP SIGNED MESSAGE-----\r\nHash: SHA256\r\n\r\n\r\n hello world! \t\r\n\r\n- - dash\r\n-----BEGIN PGP SIGNATURE-----\r\nVersion: GnuPG v1.4.2.1 (GNU/Linux)\r\n\r\niQEVAwUBRCNS8+DPyHq93/cWAQi6SwgAj3ItmSLr/sd/ixAQLW7/12jzEjfNmFDt\r\nWOZpJFmXj0fnMzTrOILVnbxHv2Ru+U8Y1K6nhzFSR7d28n31/XGgFtdohDEaFJpx\r\nFl+KvASKIonnpEDjFJsPIvT1/G/eCPalwO9IuxaIthmKj0z44SO1VQtmNKxdLAfK\r\n+xTnXGawXS1WUE4CQGPM45mIGSqXcYrLtJkAg3jtRa8YRUn2d7b2BtmWH+jVaVuC\r\nhNrXYv7iHFOu25yRWhUQJisvdC13D/gKIPRvARXPgPhAC2kovIy6VS8tDoyG6Hm5\r\ndMgLEGhmqsgaetVq1ZIuBZj5S4j2apBJCDpF6GBfpBOfwIZs0Tpmlw==\r\n=84Nd\r-----END PGP SIGNATURE-----\r\n";
    final String edDsaSignedMessage = "-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA256\n\nperson:  First Person\naddress: St James Street\naddress: Burnley\naddress: UK\nphone:   +44 282 420469\nnic-hdl: FP1-TEST\nmnt-by:  OWNER-MNT\nsource:  TEST\n-----BEGIN PGP SIGNATURE-----\nComment: GPGTools - http://gpgtools.org\n\niHUEARYIAB0WIQRiNGNQyuJDPiQAHXKU+mLDZIGuNAUCXiWfSQAKCRCU+mLDZIGu\nNIiqAQD+sksm61T9mYmoLRPhV+D3jSg2IE19id3WyjaH0vCwXQEA6v5xpZQ7AXQe\nvbSHvSrRBNBSAUuJfIYQLsAf6l80MAI=\n=pQ32\n-----END PGP SIGNATURE-----";
    final String edDsaPublicKey = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: GPGTools - http://gpgtools.org\n\nmDMEXiWeSRYJKwYBBAHaRw8BAQdAEo+4wi/WI0xtbQF+PoIGxaDFJw23d+3w/ov+\ngo85qdi0GVRlc3QgVXNlciA8dGVzdEByaXBlLm5ldD6IkAQTFggAOBYhBGI0Y1DK\n4kM+JAAdcpT6YsNkga40BQJeJZ5JAhsDBQsJCAcCBhUKCQgLAgQWAgMBAh4BAheA\nAAoJEJT6YsNkga40WLEBAKGMQaC1zKbmuD5Pav0ssuhxaznoMbuZqJ45VNiGKzLE\nAQCGFbH+9pAvcEuorOa180+GLDZOpVYgQy40KsGaQgC5Drg4BF4lnkkSCisGAQQB\nl1UBBQEBB0DFLFEhV9RSM92t1LwC/ClmND/Yw9P0a3paC2XGzTNTAwMBCAeIeAQY\nFggAIBYhBGI0Y1DK4kM+JAAdcpT6YsNkga40BQJeJZ5JAhsMAAoJEJT6YsNkga40\nLbQBALZ5BaNX5OxdS++mzwdWAVLZXAPRDFr6Q2otdxbnR0FTAP4ok4PiOpe1BfdF\nitv84V9zda3NL6zJLhR3kewd30UDCA==\n=Dxc9\n-----END PGP PUBLIC KEY BLOCK-----\n";

    private void edDsaBcTest() throws Exception {
        Object object;
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)"-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: GPGTools - http://gpgtools.org\n\nmDMEXiWeSRYJKwYBBAHaRw8BAQdAEo+4wi/WI0xtbQF+PoIGxaDFJw23d+3w/ov+\ngo85qdi0GVRlc3QgVXNlciA8dGVzdEByaXBlLm5ldD6IkAQTFggAOBYhBGI0Y1DK\n4kM+JAAdcpT6YsNkga40BQJeJZ5JAhsDBQsJCAcCBhUKCQgLAgQWAgMBAh4BAheA\nAAoJEJT6YsNkga40WLEBAKGMQaC1zKbmuD5Pav0ssuhxaznoMbuZqJ45VNiGKzLE\nAQCGFbH+9pAvcEuorOa180+GLDZOpVYgQy40KsGaQgC5Drg4BF4lnkkSCisGAQQB\nl1UBBQEBB0DFLFEhV9RSM92t1LwC/ClmND/Yw9P0a3paC2XGzTNTAwMBCAeIeAQY\nFggAIBYhBGI0Y1DK4kM+JAAdcpT6YsNkga40BQJeJZ5JAhsMAAoJEJT6YsNkga40\nLbQBALZ5BaNX5OxdS++mzwdWAVLZXAPRDFr6Q2otdxbnR0FTAP4ok4PiOpe1BfdF\nitv84V9zda3NL6zJLhR3kewd30UDCA==\n=Dxc9\n-----END PGP PUBLIC KEY BLOCK-----\n")));
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(armoredInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        this.isTrue(this.areEqual(Hex.decode((String)"6234 6350 CAE2 433E 2400  1D72 94FA 62C3 6481 AE34"), pGPPublicKeyRing.getPublicKey().getFingerprint()));
        armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)"-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA256\n\nperson:  First Person\naddress: St James Street\naddress: Burnley\naddress: UK\nphone:   +44 282 420469\nnic-hdl: FP1-TEST\nmnt-by:  OWNER-MNT\nsource:  TEST\n-----BEGIN PGP SIGNATURE-----\nComment: GPGTools - http://gpgtools.org\n\niHUEARYIAB0WIQRiNGNQyuJDPiQAHXKU+mLDZIGuNAUCXiWfSQAKCRCU+mLDZIGu\nNIiqAQD+sksm61T9mYmoLRPhV+D3jSg2IE19id3WyjaH0vCwXQEA6v5xpZQ7AXQe\nvbSHvSrRBNBSAUuJfIYQLsAf6l80MAI=\n=pQ32\n-----END PGP SIGNATURE-----")));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        int n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, armoredInputStream);
        byte[] byArray = Strings.toByteArray((String)"\n");
        if (n != -1 && armoredInputStream.isClearText()) {
            object = byteArrayOutputStream2.toByteArray();
            byteArrayOutputStream.write((byte[])object, 0, PGPClearSignedSignatureTest.getLengthWithoutSeparatorOrTrailingWhitespace((byte[])object));
            byteArrayOutputStream.write(byArray);
            while (n != -1 && armoredInputStream.isClearText()) {
                n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, n, armoredInputStream);
                object = byteArrayOutputStream2.toByteArray();
                byteArrayOutputStream.write((byte[])object, 0, PGPClearSignedSignatureTest.getLengthWithoutSeparatorOrTrailingWhitespace((byte[])object));
                byteArrayOutputStream.write(byArray);
            }
        }
        object = new BcPGPObjectFactory(armoredInputStream);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)((PGPObjectFactory)object).nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(pGPSignature.getKeyID());
        pGPSignature.init(new BcPGPContentVerifierBuilderProvider(), pGPPublicKey);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, byteArrayInputStream);
        PGPClearSignedSignatureTest.processLine(pGPSignature, byteArrayOutputStream2.toByteArray());
        if (n != -1) {
            do {
                n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, n, byteArrayInputStream);
                pGPSignature.update((byte)13);
                pGPSignature.update((byte)10);
                PGPClearSignedSignatureTest.processLine(pGPSignature, byteArrayOutputStream2.toByteArray());
            } while (n != -1);
        }
        ((InputStream)byteArrayInputStream).close();
        this.isTrue("sig failed", pGPSignature.verify());
    }

    private void edDsaTest() throws Exception {
        Object object;
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)"-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: GPGTools - http://gpgtools.org\n\nmDMEXiWeSRYJKwYBBAHaRw8BAQdAEo+4wi/WI0xtbQF+PoIGxaDFJw23d+3w/ov+\ngo85qdi0GVRlc3QgVXNlciA8dGVzdEByaXBlLm5ldD6IkAQTFggAOBYhBGI0Y1DK\n4kM+JAAdcpT6YsNkga40BQJeJZ5JAhsDBQsJCAcCBhUKCQgLAgQWAgMBAh4BAheA\nAAoJEJT6YsNkga40WLEBAKGMQaC1zKbmuD5Pav0ssuhxaznoMbuZqJ45VNiGKzLE\nAQCGFbH+9pAvcEuorOa180+GLDZOpVYgQy40KsGaQgC5Drg4BF4lnkkSCisGAQQB\nl1UBBQEBB0DFLFEhV9RSM92t1LwC/ClmND/Yw9P0a3paC2XGzTNTAwMBCAeIeAQY\nFggAIBYhBGI0Y1DK4kM+JAAdcpT6YsNkga40BQJeJZ5JAhsMAAoJEJT6YsNkga40\nLbQBALZ5BaNX5OxdS++mzwdWAVLZXAPRDFr6Q2otdxbnR0FTAP4ok4PiOpe1BfdF\nitv84V9zda3NL6zJLhR3kewd30UDCA==\n=Dxc9\n-----END PGP PUBLIC KEY BLOCK-----\n")));
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(armoredInputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        this.isTrue(this.areEqual(Hex.decode((String)"6234 6350 CAE2 433E 2400  1D72 94FA 62C3 6481 AE34"), pGPPublicKeyRing.getPublicKey().getFingerprint()));
        armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)"-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA256\n\nperson:  First Person\naddress: St James Street\naddress: Burnley\naddress: UK\nphone:   +44 282 420469\nnic-hdl: FP1-TEST\nmnt-by:  OWNER-MNT\nsource:  TEST\n-----BEGIN PGP SIGNATURE-----\nComment: GPGTools - http://gpgtools.org\n\niHUEARYIAB0WIQRiNGNQyuJDPiQAHXKU+mLDZIGuNAUCXiWfSQAKCRCU+mLDZIGu\nNIiqAQD+sksm61T9mYmoLRPhV+D3jSg2IE19id3WyjaH0vCwXQEA6v5xpZQ7AXQe\nvbSHvSrRBNBSAUuJfIYQLsAf6l80MAI=\n=pQ32\n-----END PGP SIGNATURE-----")));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        int n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, armoredInputStream);
        byte[] byArray = Strings.toByteArray((String)"\n");
        if (n != -1 && armoredInputStream.isClearText()) {
            object = byteArrayOutputStream2.toByteArray();
            byteArrayOutputStream.write((byte[])object, 0, PGPClearSignedSignatureTest.getLengthWithoutSeparatorOrTrailingWhitespace((byte[])object));
            byteArrayOutputStream.write(byArray);
            while (n != -1 && armoredInputStream.isClearText()) {
                n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, n, armoredInputStream);
                object = byteArrayOutputStream2.toByteArray();
                byteArrayOutputStream.write((byte[])object, 0, PGPClearSignedSignatureTest.getLengthWithoutSeparatorOrTrailingWhitespace((byte[])object));
                byteArrayOutputStream.write(byArray);
            }
        }
        object = new JcaPGPObjectFactory(armoredInputStream);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)((PGPObjectFactory)object).nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(pGPSignature.getKeyID());
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, byteArrayInputStream);
        PGPClearSignedSignatureTest.processLine(pGPSignature, byteArrayOutputStream2.toByteArray());
        if (n != -1) {
            do {
                n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, n, byteArrayInputStream);
                pGPSignature.update((byte)13);
                pGPSignature.update((byte)10);
                PGPClearSignedSignatureTest.processLine(pGPSignature, byteArrayOutputStream2.toByteArray());
            } while (n != -1);
        }
        ((InputStream)byteArrayInputStream).close();
        this.isTrue(pGPSignature.verify());
    }

    private void generateTest(String string, String string2) throws Exception {
        PGPSecretKey pGPSecretKey = this.readSecretKey(new ByteArrayInputStream(this.secretKey));
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build("".toCharArray()));
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pGPSecretKey.getPublicKey().getAlgorithm(), 8).setProvider("BC"));
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureGenerator.init(1, pGPPrivateKey);
        Iterator iterator = pGPSecretKey.getPublicKey().getUserIDs();
        if (iterator.hasNext()) {
            pGPSignatureSubpacketGenerator.setSignerUserID(false, (String)iterator.next());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        armoredOutputStream.beginClearText(8);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        int n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, byteArrayInputStream);
        PGPClearSignedSignatureTest.processLine(armoredOutputStream, pGPSignatureGenerator, byteArrayOutputStream2.toByteArray());
        if (n != -1) {
            do {
                n = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, n, byteArrayInputStream);
                pGPSignatureGenerator.update((byte)13);
                pGPSignatureGenerator.update((byte)10);
                PGPClearSignedSignatureTest.processLine(armoredOutputStream, pGPSignatureGenerator, byteArrayOutputStream2.toByteArray());
            } while (n != -1);
        }
        armoredOutputStream.endClearText();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(armoredOutputStream);
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        armoredOutputStream.close();
        this.messageTest(new String(byteArrayOutputStream.toByteArray()), string2);
    }

    private static int getLengthWithoutSeparatorOrTrailingWhitespace(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0 && PGPClearSignedSignatureTest.isWhiteSpace(byArray[n])) {
            --n;
        }
        return n + 1;
    }

    private static int getLengthWithoutWhiteSpace(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0 && PGPClearSignedSignatureTest.isWhiteSpace(byArray[n])) {
            --n;
        }
        return n + 1;
    }

    public String getName() {
        return "PGPClearSignedSignature";
    }

    private static boolean isWhiteSpace(byte by) {
        return by == 13 || by == 10 || by == 9 || by == 32;
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPClearSignedSignatureTest());
    }

    private void messageTest(String string, String string2) throws Exception {
        int n;
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(string.getBytes()));
        String[] stringArray = armoredInputStream.getArmorHeaders();
        if (stringArray == null || stringArray.length != 1) {
            this.fail("wrong number of headers found");
        }
        if (!"Hash: SHA256".equals(stringArray[0])) {
            this.fail("header value wrong: " + stringArray[0]);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = armoredInputStream.read()) >= 0 && armoredInputStream.isClearText()) {
            byteArrayOutputStream.write((byte)n);
        }
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(this.publicKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(armoredInputStream);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKeyRingCollection.getPublicKey(pGPSignature.getKeyID()));
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        int n2 = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, byteArrayInputStream);
        PGPClearSignedSignatureTest.processLine(pGPSignature, byteArrayOutputStream2.toByteArray());
        if (n2 != -1) {
            do {
                n2 = PGPClearSignedSignatureTest.readInputLine(byteArrayOutputStream2, n2, byteArrayInputStream);
                pGPSignature.update((byte)13);
                pGPSignature.update((byte)10);
                PGPClearSignedSignatureTest.processLine(pGPSignature, byteArrayOutputStream2.toByteArray());
            } while (n2 != -1);
        }
        if (!pGPSignature.verify()) {
            this.fail("signature failed to verify in " + string2);
        }
    }

    public void performTest() throws Exception {
        this.messageTest(this.crOnlySignedMessage, "\\r");
        this.messageTest(this.nlOnlySignedMessage, "\\n");
        this.messageTest(this.crNlSignedMessage, "\\r\\n");
        this.messageTest(this.crNlSignedMessageTrailingWhiteSpace, "\\r\\n");
        this.generateTest(this.nlOnlyMessage, "\\r");
        this.generateTest(this.crOnlyMessage, "\\n");
        this.generateTest(this.crNlMessage, "\\r\\n");
        this.edDsaTest();
        this.edDsaBcTest();
    }

    private static void processLine(OutputStream outputStream, PGPSignatureGenerator pGPSignatureGenerator, byte[] byArray) throws SignatureException, IOException {
        int n = PGPClearSignedSignatureTest.getLengthWithoutWhiteSpace(byArray);
        if (n > 0) {
            pGPSignatureGenerator.update(byArray, 0, n);
        }
        outputStream.write(byArray, 0, byArray.length);
    }

    private static void processLine(PGPSignature pGPSignature, byte[] byArray) throws SignatureException, IOException {
        int n = PGPClearSignedSignatureTest.getLengthWithoutWhiteSpace(byArray);
        if (n > 0) {
            pGPSignature.update(byArray, 0, n);
        }
    }

    private static int readInputLine(ByteArrayOutputStream byteArrayOutputStream, int n, InputStream inputStream) throws IOException {
        byteArrayOutputStream.reset();
        int n2 = n;
        do {
            byteArrayOutputStream.write(n2);
            if (n2 != 13 && n2 != 10) continue;
            n = PGPClearSignedSignatureTest.readPassedEOL(byteArrayOutputStream, n2, inputStream);
            break;
        } while ((n2 = inputStream.read()) >= 0);
        return n;
    }

    private static int readInputLine(ByteArrayOutputStream byteArrayOutputStream, InputStream inputStream) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        int n2 = -1;
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
            if (n != 13 && n != 10) continue;
            n2 = PGPClearSignedSignatureTest.readPassedEOL(byteArrayOutputStream, n, inputStream);
            break;
        }
        return n2;
    }

    private static int readPassedEOL(ByteArrayOutputStream byteArrayOutputStream, int n, InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n == 13 && n2 == 10) {
            byteArrayOutputStream.write(n2);
            n2 = inputStream.read();
        }
        return n2;
    }

    private PGPSecretKey readSecretKey(InputStream inputStream) throws IOException, PGPException {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(inputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPSecretKey pGPSecretKey = null;
        Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
        while (pGPSecretKey == null && iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
            while (pGPSecretKey == null && iterator2.hasNext()) {
                PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator2.next();
                if (!pGPSecretKey2.isSigningKey()) continue;
                pGPSecretKey = pGPSecretKey2;
            }
        }
        if (pGPSecretKey == null) {
            throw new IllegalArgumentException("Can't find signing key in key ring.");
        }
        return pGPSecretKey;
    }
}

