/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.UncloseableOutputStream;

public class PGPCompressionTest
extends SimpleTest {
    public String getName() {
        return "PGPCompressionTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPCompressionTest());
    }

    public void performTest() throws Exception {
        this.testCompression(new byte[0]);
        this.testCompression("hello world!".getBytes());
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[1000000];
        secureRandom.nextBytes(byArray);
        this.testCompression(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        OutputStream outputStream = pGPCompressedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream), new byte[4]);
        outputStream.write("hello world! !dlrow olleh".getBytes());
        outputStream.close();
        this.validateData(byteArrayOutputStream.toByteArray());
        try {
            outputStream.close();
            pGPCompressedDataGenerator.close();
        }
        catch (Exception exception) {
            this.fail("Redundant close() should be ignored");
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        outputStream = pGPCompressedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream), new byte[4]);
        outputStream.write("hello world! !dlrow olleh".getBytes());
        pGPCompressedDataGenerator.close();
        this.validateData(byteArrayOutputStream.toByteArray());
        try {
            outputStream.close();
            pGPCompressedDataGenerator.close();
        }
        catch (Exception exception) {
            this.fail("Redundant close() should be ignored");
        }
    }

    private void testCompression(byte[] byArray) throws IOException, PGPException {
        this.testCompression(byArray, 0);
        this.testCompression(byArray, 1);
        this.testCompression(byArray, 2);
        this.testCompression(byArray, 3);
    }

    private void testCompression(byte[] byArray, int n) throws IOException, PGPException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n);
        OutputStream outputStream = pGPCompressedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream));
        outputStream.write(byArray);
        outputStream.close();
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byteArrayOutputStream.toByteArray());
        PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
        InputStream inputStream = pGPCompressedData.getDataStream();
        byteArrayOutputStream.reset();
        while ((n2 = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n2);
        }
        if (!this.areEqual(byteArrayOutputStream.toByteArray(), byArray)) {
            this.fail("compression test failed");
        }
    }

    private void validateData(byte[] byArray) throws IOException, PGPException {
        int n;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byArray);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
        InputStream inputStream = pGPCompressedData.getDataStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        if (!this.areEqual(byteArrayOutputStream.toByteArray(), "hello world! !dlrow olleh".getBytes())) {
            this.fail("compression test failed");
        }
    }
}

