/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.UncloseableOutputStream;

public class PGPDSAElGamalTest
extends SimpleTest {
    byte[] testPubKeyRing = Base64.decode((String)"mQGiBEAR8jYRBADNifuSopd20JOQ5x30ljIaY0M6927+vo09NeNxS3KqItbanz9o5e2aqdT0W1xgdHYZmdElOHTTsugZxdXTEhghyxoo3KhVcNnTABQyrrvXqouvmP2fEDEw0Vpyk+90BpyY9YlgeX/dEA8OfooRLCJde/iDTl7r9FT+mts8g3azjwCgx+pOLD9LPBF5E4FhUOdXISJ0f4EEAKXSOi9nZzajpdhe8W2ZL9gcBpzZi6AcrRZBHOEMqd69gtUxA4eD8xycUQ42yH89imEcwLz8XdJ98uHUxGJiqp6hq4oakmw8GQfiL7yQIFgaM0dOAI9Afe3m84cEYZsoAFYpB4/s9pVMpPRHNsVspU0qd3NHnSZ0QXs8L8DXGO1uBACjDUj+8GsfDCIP2QF3JC+nPUNa0Y5twKPKl+T8hX/0FBD7fnNeC6c9j5Ir/Fp/QtdaDAOoBKiyNLh1JaB1NY6US5zcqFks2seZPjXEiE6OIDXYra494mjNKGUobA4hqT2peKWXt/uBcuL1mjKOy8QfJxgEd0MOcGJO+1PFFZWGzLQ3RXJpYyBILiBFY2hpZG5hICh0ZXN0IGtleSBvbmx5KSA8ZXJpY0Bib3VuY3ljYXN0bGUub3JnPohZBBMRAgAZBQJAEfI2BAsHAwIDFQIDAxYCAQIeAQIXgAAKCRAOtk6iUOgnkDdnAKC/CfLWikSBdbngY6OK5UN3+o7q1ACcDRqjT3yjBU3WmRUNlxBg3tSuljmwAgAAuQENBEAR8jgQBAC2kr57iuOaV7Ga1xcU14MNbKcA0PVembRCjcVjei/3yVfT/fuCVtGHOmYLEBqHbn5aaJ0P/6vMbLCHKuN61NZlts+LEctfwoya43RtcubqMc7eKw4k0JnnoYgBocLXOtloCb7jfubOsnfORvrUkK0+Ne6anRhFBYfaBmGU75cQgwADBQP/XxR2qGHiwn+0YiMioRDRiIAxp6UiC/JQIri2AKSqAi0zeAMdrRsBN7kyzYVVpWwN5u13gPdQ2HnJ7d4wLWAuizUdKIQxBG8VoCxkbipnwh2RR4xCXFDhJrJFQUm+4nKx9JvAmZTBIlI5Wsi5qxst/9p5MgP3flXsNi1tRbTmRhqIRgQYEQIABgUCQBHyOAAKCRAOtk6iUOgnkBStAJoCZBVM61B1LG2xip294MZecMtCwQCbBbskJVCXP0/Szm05GB+WN+MOCT2wAgAA");
    byte[] testPrivKeyRing = Base64.decode((String)"lQHhBEAR8jYRBADNifuSopd20JOQ5x30ljIaY0M6927+vo09NeNxS3KqItbanz9o5e2aqdT0W1xgdHYZmdElOHTTsugZxdXTEhghyxoo3KhVcNnTABQyrrvXqouvmP2fEDEw0Vpyk+90BpyY9YlgeX/dEA8OfooRLCJde/iDTl7r9FT+mts8g3azjwCgx+pOLD9LPBF5E4FhUOdXISJ0f4EEAKXSOi9nZzajpdhe8W2ZL9gcBpzZi6AcrRZBHOEMqd69gtUxA4eD8xycUQ42yH89imEcwLz8XdJ98uHUxGJiqp6hq4oakmw8GQfiL7yQIFgaM0dOAI9Afe3m84cEYZsoAFYpB4/s9pVMpPRHNsVspU0qd3NHnSZ0QXs8L8DXGO1uBACjDUj+8GsfDCIP2QF3JC+nPUNa0Y5twKPKl+T8hX/0FBD7fnNeC6c9j5Ir/Fp/QtdaDAOoBKiyNLh1JaB1NY6US5zcqFks2seZPjXEiE6OIDXYra494mjNKGUobA4hqT2peKWXt/uBcuL1mjKOy8QfJxgEd0MOcGJO+1PFFZWGzP4DAwLeUcsVxIC2s2Bb9ab2XD860TQ2BI2rMD/r7/psx9WQ+Vz/aFAT3rXkEJ97nFeqEACgKmUCAEk9939EwLQ3RXJpYyBILiBFY2hpZG5hICh0ZXN0IGtleSBvbmx5KSA8ZXJpY0Bib3VuY3ljYXN0bGUub3JnPohZBBMRAgAZBQJAEfI2BAsHAwIDFQIDAxYCAQIeAQIXgAAKCRAOtk6iUOgnkDdnAJ9Ala3OcwEV1DbK906CheYWo4zIQwCfUqUOLMp/zj6QAk02bbJAhV1rsAewAgAAnQFYBEAR8jgQBAC2kr57iuOaV7Ga1xcU14MNbKcA0PVembRCjcVjei/3yVfT/fuCVtGHOmYLEBqHbn5aaJ0P/6vMbLCHKuN61NZlts+LEctfwoya43RtcubqMc7eKw4k0JnnoYgBocLXOtloCb7jfubOsnfORvrUkK0+Ne6anRhFBYfaBmGU75cQgwADBQP/XxR2qGHiwn+0YiMioRDRiIAxp6UiC/JQIri2AKSqAi0zeAMdrRsBN7kyzYVVpWwN5u13gPdQ2HnJ7d4wLWAuizUdKIQxBG8VoCxkbipnwh2RR4xCXFDhJrJFQUm+4nKx9JvAmZTBIlI5Wsi5qxst/9p5MgP3flXsNi1tRbTmRhr+AwMC3lHLFcSAtrNg/EiWFLAnKNXH27zjwuhje8u2r+9iMTYsGjbRxaxRY0GKRhttCwqe2BC0lHhzifdlEcc9yjIjuKfepG2fnnSIRgQYEQIABgUCQBHyOAAKCRAOtk6iUOgnkBStAJ9HFejVtVJ/A9LM/mDPe0ExhEXt/QCgm/KM7hJ/JrfnLQl7IaZsdg1F6vCwAgAA");
    byte[] encMessage = Base64.decode((String)"hQEOAynbo4lhNjcHEAP/dgCkMtPB6mIgjFvNiotjaoh4sAXf4vFNkSeehQ2cr+IMt9CgIYodJI3FoJXxOuTcwesqTp5hRzgUBJS0adLDJwcNubFMy0M2tp5oKTWpXulIiqyO6f5jI/oEDHPzFoYgBmR4x72l/YpMy8UoYGtNxNvR7LVOfqJvuDY/71KMtPQEAIadOWpf1P5Td+61Zqn2VH2UV7H8eI6hGa6Lsy4sb9iZNE7fc+spGJlgkiOt8TrQoq3iOK9UN9nHZLiCSIEGCzsEn3uNuorD++Qs065ij+Oy36TKeuJ+38CfT7u47dEshHCPqWhBKEYrxZWHUJU/izw2Q1Yxd2XRxN+nafTLX1fQ0lABQUASa18s0BkkEERIdcKQXVLEswWcGqWNv1ZghC7xO2VDBX4HrPjpdrjL63p2UHzJ7/4gPWGGtnqq1Xita/1mrImn7pzLThDWiT55vjw6Hw==");
    byte[] signedAndEncMessage = Base64.decode((String)"hQEOAynbo4lhNjcHEAP+K20MVhzdX57hf/cU8TH0prP0VePr9mmeBedzqqMnfp2p8Zb68zmcMlI/WiL5XMNLYRmCgEcXyWbKdP/XV9m9LDBe1CMAGrkCeGByje69IQQ5LS9vDPyEMF4iAAv/EqACjqHkizdY/a/FRx/t2ioXYdEC2jA6kS9CMcpsNz16DE8EAIk3uKn4bGo/+15TXkyFYzW5Cf71SfRoHNmU2zAI93zhjN+TB7mGJwWXzsMkIO6FkMU5TCSrwZS3DBWCIaJ6SYoaawE/C/2j9D7bX1Jv8kum4cq+eZM7z6JYs6xend+WAwittpUxbEiyC2AJb3fBSXPAbLqWd6J6xbZZ7GDKr2Ca0pwBxwGhbMDyi2zpHLzw95H7Ah2wMcGU6kMLB+hzBSZ6mSTGFehqFQE32BnAj7MtnbghiefogacJ891jj8Y2ggJeKDuRz8j2iICaTOy+Y2rXnnJwfYzmBMWcd2h1C5+UeBJ9CrrLniCCI8s5u8z36Rno3sfhBnXdRmWSxExXtocbg1HtdyiThf6TK3W29Yy/T6x45Ws5zOasaJdsFKM=");
    char[] pass = new char[]{'h', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd'};
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getName() {
        return "PGPDSAElGamalTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPDSAElGamalTest());
    }

    public void performTest() throws Exception {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            int n;
            PGPPublicKey pGPPublicKey = null;
            JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(this.testPubKeyRing);
            PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)jcaPGPObjectFactory.nextObject();
            pGPPublicKey = pGPPublicKeyRing.getPublicKey();
            if (pGPPublicKey.getBitStrength() != 1024) {
                this.fail("failed - key strength reported incorrectly.");
            }
            PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(this.testPrivKeyRing, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPrivateKey pGPPrivateKey = pGPSecretKeyRing.getSecretKey().extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass));
            String string = "hello world!";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(17, 2).setProvider("BC"));
            pGPSignatureGenerator.init(0, pGPPrivateKey);
            PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(pGPCompressedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream)));
            pGPSignatureGenerator.generateOnePassVersion(false).encode(bCPGOutputStream);
            PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
            Date date = new Date(System.currentTimeMillis() / 1000L * 1000L);
            OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)bCPGOutputStream), 'b', "_CONSOLE", string.getBytes().length, date);
            while ((n = byteArrayInputStream.read()) >= 0) {
                outputStream.write(n);
                pGPSignatureGenerator.update((byte)n);
            }
            pGPLiteralDataGenerator.close();
            pGPSignatureGenerator.generate().encode(bCPGOutputStream);
            pGPCompressedDataGenerator.close();
            jcaPGPObjectFactory = new JcaPGPObjectFactory(byteArrayOutputStream.toByteArray());
            PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
            jcaPGPObjectFactory = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
            PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)jcaPGPObjectFactory.nextObject();
            PGPOnePassSignature pGPOnePassSignature = pGPOnePassSignatureList.get(0);
            PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
            if (!pGPLiteralData.getModificationTime().equals(date)) {
                this.fail("Modification time not preserved");
            }
            InputStream inputStream = pGPLiteralData.getInputStream();
            pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
            while ((n = inputStream.read()) >= 0) {
                pGPOnePassSignature.update((byte)n);
            }
            PGPSignatureList pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
            if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
                this.fail("Failed generated signature check");
            }
            long l = 0L;
            PublicKey publicKey = null;
            Iterator iterator = pGPPublicKeyRing.getPublicKeys();
            while (iterator.hasNext()) {
                object5 = (PGPPublicKey)iterator.next();
                if (((PGPPublicKey)object5).getAlgorithm() != 16 && ((PGPPublicKey)object5).getAlgorithm() != 20) continue;
                publicKey = new JcaPGPKeyConverter().setProvider("BC").getPublicKey((PGPPublicKey)object5);
                l = ((PGPPublicKey)object5).getKeyID();
                if (((PGPPublicKey)object5).getBitStrength() == 1024) continue;
                this.fail("failed - key strength reported incorrectly.");
            }
            object5 = Cipher.getInstance("ElGamal/None/PKCS1Padding", "BC");
            ((Cipher)object5).init(1, publicKey);
            byte[] byArray = "hello world".getBytes();
            byte[] byArray2 = ((Cipher)object5).doFinal(byArray);
            pGPPrivateKey = pGPSecretKeyRing.getSecretKey(l).extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass));
            ((Cipher)object5).init(2, new JcaPGPKeyConverter().setProvider("BC").getPrivateKey(pGPPrivateKey));
            byArray2 = ((Cipher)object5).doFinal(byArray2);
            if (!this.areEqual(byArray, byArray2)) {
                this.fail("decryption failed.");
            }
            byte[] byArray3 = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 33, 10};
            JcaPGPObjectFactory jcaPGPObjectFactory2 = new JcaPGPObjectFactory(this.encMessage);
            PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory2.nextObject();
            PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
            InputStream inputStream2 = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
            jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream2);
            pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
            jcaPGPObjectFactory = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
            PGPLiteralData pGPLiteralData2 = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (!pGPLiteralData2.getFileName().equals("test.txt")) {
                throw new RuntimeException("wrong filename in packet");
            }
            InputStream inputStream3 = pGPLiteralData2.getDataStream();
            while ((n = inputStream3.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            if (!this.areEqual(byteArrayOutputStream.toByteArray(), byArray3)) {
                this.fail("wrong plain text in decrypted packet");
            }
            jcaPGPObjectFactory2 = new JcaPGPObjectFactory(this.signedAndEncMessage);
            pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory2.nextObject();
            pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
            inputStream2 = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
            jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream2);
            pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
            jcaPGPObjectFactory = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
            pGPOnePassSignatureList = (PGPOnePassSignatureList)jcaPGPObjectFactory.nextObject();
            pGPOnePassSignature = pGPOnePassSignatureList.get(0);
            pGPLiteralData2 = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (!pGPLiteralData2.getFileName().equals("test.txt")) {
                throw new RuntimeException("wrong filename in packet");
            }
            inputStream3 = pGPLiteralData2.getDataStream();
            pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKeyRing.getPublicKey());
            while ((n = inputStream3.read()) >= 0) {
                pGPOnePassSignature.update((byte)n);
                byteArrayOutputStream.write(n);
            }
            pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
            if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
                this.fail("Failed signature check");
            }
            if (!this.areEqual(byteArrayOutputStream.toByteArray(), byArray3)) {
                this.fail("wrong plain text in decrypted packet");
            }
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(2).setSecureRandom(new SecureRandom()).setProvider("BC"));
            PGPPublicKey pGPPublicKey2 = pGPSecretKeyRing.getSecretKey(l).getPublicKey();
            pGPEncryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey2).setProvider("BC"));
            OutputStream outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), byteArrayOutputStream.toByteArray().length);
            outputStream2.write(byArray3);
            outputStream2.close();
            jcaPGPObjectFactory2 = new JcaPGPObjectFactory(byteArrayOutputStream2.toByteArray());
            pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory2.nextObject();
            pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
            pGPPrivateKey = pGPSecretKeyRing.getSecretKey(l).extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass));
            inputStream2 = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
            byteArrayOutputStream.reset();
            while ((n = inputStream2.read()) >= 0) {
                byteArrayOutputStream.write(n);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
            if (!this.areEqual(byArray2, byArray3)) {
                this.fail("wrong plain text in generated packet");
            }
            BigInteger bigInteger = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
            BigInteger bigInteger2 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ElGamal", "BC");
            ElGamalParameterSpec elGamalParameterSpec = new ElGamalParameterSpec(bigInteger2, bigInteger);
            keyPairGenerator.initialize((AlgorithmParameterSpec)elGamalParameterSpec);
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(20, keyPair, new Date());
            PGPPublicKey pGPPublicKey3 = jcaPGPKeyPair.getPublicKey();
            PGPPrivateKey pGPPrivateKey2 = jcaPGPKeyPair.getPrivateKey();
            SecureRandom secureRandom = new SecureRandom();
            int n2 = 257;
            while (n2 < 264) {
                int n3;
                object4 = AlgorithmParameterGenerator.getInstance("ElGamal", "BC");
                ((AlgorithmParameterGenerator)object4).init(n2, new SecureRandom());
                object3 = ((AlgorithmParameterGenerator)object4).generateParameters();
                object2 = (DHParameterSpec)((AlgorithmParameters)object3).getParameterSpec(class$javax$crypto$spec$DHParameterSpec != null ? class$javax$crypto$spec$DHParameterSpec : PGPDSAElGamalTest.class$("javax.crypto.spec.DHParameterSpec"));
                object = KeyPairGenerator.getInstance("ElGamal", "BC");
                ((KeyPairGenerator)object).initialize((AlgorithmParameterSpec)object2);
                keyPair = ((KeyPairGeneratorSpi)object).generateKeyPair();
                JcaPGPKeyPair jcaPGPKeyPair2 = new JcaPGPKeyPair(20, keyPair, new Date());
                pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setSecureRandom(new SecureRandom()).setProvider("BC"));
                pGPPublicKey2 = jcaPGPKeyPair2.getPublicKey();
                pGPEncryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey2).setProvider("BC"));
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)byteArrayOutputStream2, byArray3.length);
                outputStream2.write(byArray3);
                outputStream2.close();
                jcaPGPObjectFactory2 = new JcaPGPObjectFactory(byteArrayOutputStream2.toByteArray());
                pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory2.nextObject();
                pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
                pGPPrivateKey = jcaPGPKeyPair2.getPrivateKey();
                inputStream2 = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
                ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
                while ((n3 = inputStream2.read()) >= 0) {
                    byteArrayOutputStream3.write(n3);
                }
                byte[] byArray4 = byteArrayOutputStream3.toByteArray();
                if (!this.areEqual(byArray3, byArray4)) {
                    this.fail("decrypted message incorrect");
                }
                ++n2;
            }
            iterator = pGPPublicKeyRing.getPublicKeys();
            while (iterator.hasNext()) {
                object4 = (PGPPublicKey)iterator.next();
                if (((PGPPublicKey)object4).isMasterKey()) continue;
                object3 = ((PGPPublicKey)object4).getEncoded();
                object2 = new JcaPGPObjectFactory((byte[])object3);
                object = (PGPPublicKey)((PGPObjectFactory)object2).nextObject();
                publicKey = new JcaPGPKeyConverter().setProvider("BC").getPublicKey((PGPPublicKey)object);
                l = ((PGPPublicKey)object).getKeyID();
                if (((PGPPublicKey)object).getBitStrength() != 1024) {
                    this.fail("failed - key strength reported incorrectly.");
                }
                if (((PGPObjectFactory)object2).nextObject() == null) continue;
                this.fail("failed - stream not fully parsed.");
            }
        }
        catch (PGPException pGPException) {
            this.fail("exception: " + pGPException.getMessage(), pGPException.getUnderlyingException());
        }
    }
}

