/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.UncloseableOutputStream;

public class PGPECDHTest
extends SimpleTest {
    byte[] testPubKey = Base64.decode((String)"mFIEUb4GwBMIKoZIzj0DAQcCAwS8p3TFaRAx58qCG63W+UNthXBPSJDnVDPTb/sTiXePaAZ/Gh1GKXTq7k6ab/67MMeVFp/EdySumqdWLtvceFKstFBUZXN0IEVDRFNBLUVDREggKEtleSBhbmQgc3Via2V5IGFyZSAyNTYgYml0cyBsb25nKSA8dGVzdC5lY2RzYS5lY2RoQGV4YW1wbGUuY29tPoh6BBMTCAAiBQJRvgbAAhsDBgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRD3wDlWjFo9U5O2AQDi89NO6JbaIObC63jMMWsiAaQHrBCPkDZLibgNv73DLgD/faouH4YZJs+cONQBPVnP1baG1NpWR5ppN3JULFcrhcq4VgRRvgbAEggqhkjOPQMBBwIDBLtY8Nmfz0zSEa8C1snTOWN+VcT8pXPwgJRyz6kSP4nPt1xj1lPKj5zwPXKWxMkPO9ocqhKdg2mOh6/rc1ObIoMDAQgHiGEEGBMIAAkFAlG+BsACGwwACgkQ98A5VoxaPVN8cgEAj4dMNMNwRSg2ZBWunqUAHqIedVbSdmwmbysD192L3z4A/ReXEa0gtv8OFWjuALD1ovEK8TpDORLUb6IuUb5jUIzY");
    byte[] testPrivKey = Base64.decode((String)"lKUEUb4GwBMIKoZIzj0DAQcCAwS8p3TFaRAx58qCG63W+UNthXBPSJDnVDPTb/sTiXePaAZ/Gh1GKXTq7k6ab/67MMeVFp/EdySumqdWLtvceFKs/gcDAo11YYCae/K21uKGJ/uU4b4QHYnPIsAdYpuo5HIdoAOL/WwduRa8C6vSFrtMJLDqPK3BUpMz3CXNGyMhjuaHKP5MPbBZkIfgUGZO5qvU9+i0UFRlc3QgRUNEU0EtRUNESCAoS2V5IGFuZCBzdWJrZXkgYXJlIDI1NiBiaXRzIGxvbmcpIDx0ZXN0LmVjZHNhLmVjZGhAZXhhbXBsZS5jb20+iHoEExMIACIFAlG+BsACGwMGCwkIBwMCBhUIAgkKCwQWAgMBAh4BAheAAAoJEPfAOVaMWj1Tk7YBAOLz007oltog5sLreMwxayIBpAesEI+QNkuJuA2/vcMuAP99qi4fhhkmz5w41AE9Wc/VtobU2lZHmmk3clQsVyuFyg==");
    byte[] testMessage = Base64.decode((String)"hH4Dp5+FdoujIBwSAgMErx4BSvgXY3irwthgxU8zPoAoR+8rhmxdpwbw6ZJAO2GXazWJ85JNcobHKDeGeUq6wkTFu+g6yG99gIX8J5xJAjBRhyCRcaFgwbdDV4orWTe3iewiT8qs4BQ23e0c8t+thdKoK4thMsCJy7wSKqY0sJTSVAELroNbCOi2lcO15YmW6HiuFH7VKWcxPUBjXwf5+Z3uOKEp28tBgNyDrdbr1BbqlgYzIKq/pe9zUbUXfitnvFc6HcGhvmRQreQ+Yw1x3x0HJeoPwg==");

    private void doBasicKeyRingCheck(PGPPublicKeyRing pGPPublicKeyRing) throws PGPException, SignatureException {
        Iterator iterator = pGPPublicKeyRing.getPublicKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)iterator.next();
            if (pGPPublicKey.isMasterKey()) {
                if (!pGPPublicKey.isEncryptionKey()) continue;
                this.fail("master key showed as encryption key!");
                continue;
            }
            if (!pGPPublicKey.isEncryptionKey()) {
                this.fail("sub key not encryption key!");
            }
            Iterator iterator2 = pGPPublicKeyRing.getPublicKey().getSignatures();
            while (iterator2.hasNext()) {
                PGPSignature pGPSignature = (PGPSignature)iterator2.next();
                pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKeyRing.getPublicKey());
                if (pGPSignature.verifyCertification((String)pGPPublicKeyRing.getPublicKey().getUserIDs().next(), pGPPublicKeyRing.getPublicKey())) continue;
                this.fail("subkey certification does not verify");
            }
        }
    }

    private void encryptDecryptTest() throws Exception {
        int n;
        byte[] byArray = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 33, 10};
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(18, keyPair, new Date());
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)byteArrayOutputStream, 'u', "_CONSOLE", byArray.length, new Date());
        outputStream.write(byArray);
        outputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setProvider("BC").setSecureRandom(new SecureRandom()));
        pGPEncryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(jcaPGPKeyPair.getPublicKey()).setProvider("BC"));
        OutputStream outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), byArray2.length);
        outputStream2.write(byArray2);
        outputStream2.close();
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byteArrayOutputStream2.toByteArray());
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(jcaPGPKeyPair.getPrivateKey()));
        jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        inputStream = pGPLiteralData.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream3.write(n);
        }
        byte[] byArray3 = byteArrayOutputStream3.toByteArray();
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("wrong plain text in generated packet");
        }
    }

    private void generate() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(19, keyPair, new Date());
        keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        KeyPair keyPair2 = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        JcaPGPKeyPair jcaPGPKeyPair2 = new JcaPGPKeyPair(18, keyPair2, new Date());
        char[] cArray = "test".toCharArray();
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        PGPKeyRingGenerator pGPKeyRingGenerator = new PGPKeyRingGenerator(19, jcaPGPKeyPair, "test@bouncycastle.org", pGPDigestCalculator, null, null, new JcaPGPContentSignerBuilder(jcaPGPKeyPair.getPublicKey().getAlgorithm(), 2), new JcePBESecretKeyEncryptorBuilder(9, pGPDigestCalculator).setProvider("BC").build(cArray));
        pGPKeyRingGenerator.addSubKey(jcaPGPKeyPair2);
        PGPPublicKeyRing pGPPublicKeyRing = pGPKeyRingGenerator.generatePublicKeyRing();
        this.doBasicKeyRingCheck(pGPPublicKeyRing);
        PGPSecretKeyRing pGPSecretKeyRing = pGPKeyRingGenerator.generateSecretKeyRing();
        JcaKeyFingerprintCalculator jcaKeyFingerprintCalculator = new JcaKeyFingerprintCalculator();
        PGPPublicKeyRing pGPPublicKeyRing2 = new PGPPublicKeyRing(pGPPublicKeyRing.getEncoded(), (KeyFingerPrintCalculator)jcaKeyFingerprintCalculator);
        if (!Arrays.areEqual((byte[])pGPPublicKeyRing.getEncoded(), (byte[])pGPPublicKeyRing2.getEncoded())) {
            this.fail("public key ring encoding failed");
        }
        PGPSecretKeyRing pGPSecretKeyRing2 = new PGPSecretKeyRing(pGPSecretKeyRing.getEncoded(), (KeyFingerPrintCalculator)jcaKeyFingerprintCalculator);
        if (!Arrays.areEqual((byte[])pGPSecretKeyRing.getEncoded(), (byte[])pGPSecretKeyRing2.getEncoded())) {
            this.fail("secret key ring encoding failed");
        }
    }

    public String getName() {
        return "PGPECDHTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPECDHTest());
    }

    public void performTest() throws Exception {
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(this.testPubKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        this.doBasicKeyRingCheck(pGPPublicKeyRing);
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(this.testPrivKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        this.testDecrypt(pGPSecretKeyRing);
        this.encryptDecryptTest();
        this.generate();
    }

    private void testDecrypt(PGPSecretKeyRing pGPSecretKeyRing) throws Exception {
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(this.testMessage);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey();
    }
}

