/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PGPECDSATest
extends SimpleTest {
    byte[] testPubKey = Base64.decode((String)"mFIEUb4HqBMIKoZIzj0DAQcCAwSQynmjwsGJHYJakAEVYxrm3tt/1h8g9Uksx32JzG/ZH4RwaD0PbjzEe5EVBmCwSErRZxt/5AxXa0TEHWjya8FetDVFQ0RTQSAoS2V5IGlzIDI1NiBiaXRzIGxvbmcpIDx0ZXN0LmVjZHNhQGV4YW1wbGUuY29tPoh6BBMTCAAiBQJRvgeoAhsDBgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRDqO46kgPLivN1hAP4n0UApR36ziS5D8KUt7wEpBujQE4G3+efATJ+DMmY/SgEA+wbdDynFf/V8pQs0+FtCYQ9schzIur+peRvol7OrNnc=");
    byte[] testPrivKey = Base64.decode((String)"lKUEUb4HqBMIKoZIzj0DAQcCAwSQynmjwsGJHYJakAEVYxrm3tt/1h8g9Uksx32JzG/ZH4RwaD0PbjzEe5EVBmCwSErRZxt/5AxXa0TEHWjya8Fe/gcDAqTWSUiFpEno1n8izmLaWTy8GYw5/lK4R2t6D347YGgTtIiXfoNPOcosmU+3OibyTm2hc/WyG4fLa0nxFtj02j0Bt/Fw0N4VCKJwKL/QJT+0NUVDRFNBIChLZXkgaXMgMjU2IGJpdHMgbG9uZykgPHRlc3QuZWNkc2FAZXhhbXBsZS5jb20+iHoEExMIACIFAlG+B6gCGwMGCwkIBwMCBhUIAgkKCwQWAgMBAh4BAheAAAoJEOo7jqSA8uK83WEA/ifRQClHfrOJLkPwpS3vASkG6NATgbf558BMn4MyZj9KAQD7Bt0PKcV/9XylCzT4W0JhD2xyHMi6v6l5G+iXs6s2dw==");

    private void generateAndSign() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("P-256"));
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(19, keyPair, new Date());
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(19, 8).setProvider("BC"));
        pGPSignatureGenerator.init(0, jcaPGPKeyPair.getPrivateKey());
        pGPSignatureGenerator.update("hello world!".getBytes());
        PGPSignature pGPSignature = pGPSignatureGenerator.generate();
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), jcaPGPKeyPair.getPublicKey());
        pGPSignature.update("hello world!".getBytes());
        if (!pGPSignature.verify()) {
            this.fail("signature failed to verify!");
        }
        char[] cArray = "test".toCharArray();
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        PGPKeyRingGenerator pGPKeyRingGenerator = new PGPKeyRingGenerator(19, jcaPGPKeyPair, "test@bouncycastle.org", pGPDigestCalculator, null, null, new JcaPGPContentSignerBuilder(jcaPGPKeyPair.getPublicKey().getAlgorithm(), 2), new JcePBESecretKeyEncryptorBuilder(9, pGPDigestCalculator).setProvider("BC").build(cArray));
        PGPPublicKeyRing pGPPublicKeyRing = pGPKeyRingGenerator.generatePublicKeyRing();
        PGPSecretKeyRing pGPSecretKeyRing = pGPKeyRingGenerator.generateSecretKeyRing();
        JcaKeyFingerprintCalculator jcaKeyFingerprintCalculator = new JcaKeyFingerprintCalculator();
        PGPPublicKeyRing pGPPublicKeyRing2 = new PGPPublicKeyRing(pGPPublicKeyRing.getEncoded(), (KeyFingerPrintCalculator)jcaKeyFingerprintCalculator);
        if (!Arrays.areEqual((byte[])pGPPublicKeyRing.getEncoded(), (byte[])pGPPublicKeyRing2.getEncoded())) {
            this.fail("public key ring encoding failed");
        }
        PGPSecretKeyRing pGPSecretKeyRing2 = new PGPSecretKeyRing(pGPSecretKeyRing.getEncoded(), (KeyFingerPrintCalculator)jcaKeyFingerprintCalculator);
        if (!Arrays.areEqual((byte[])pGPSecretKeyRing.getEncoded(), (byte[])pGPSecretKeyRing2.getEncoded())) {
            this.fail("secret key ring encoding failed");
        }
    }

    public String getName() {
        return "PGPECDSATest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPECDSATest());
    }

    public void performTest() throws Exception {
        Object object;
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(this.testPubKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator iterator = pGPPublicKeyRing.getPublicKey().getSignatures();
        while (iterator.hasNext()) {
            object = (PGPSignature)iterator.next();
            ((PGPSignature)object).init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKeyRing.getPublicKey());
            if (((PGPSignature)object).verifyCertification((String)pGPPublicKeyRing.getPublicKey().getUserIDs().next(), pGPPublicKeyRing.getPublicKey())) continue;
            this.fail("self certification does not verify");
        }
        object = new PGPSecretKeyRing(this.testPrivKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        this.generateAndSign();
    }
}

