/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.gpg.SExprParser;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.jcajce.JcaPGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PGPECMessageTest
extends SimpleTest {
    byte[] testPubKey = Base64.decode((String)"mFIEU5SAxhMIKoZIzj0DAQcCAwRqnFLCB8EEZkAELNqznk8yQau/f1PACUTU/Qe9\njlybc22bO55BdvZdFoa3RmNQHhR980/KeVwCQ3cPpe6OQJFAtD9OSVNUIFAtMjU2\nIChHZW5lcmF0ZWQgYnkgR1BHIDIuMSBiZXRhKSA8bmlzdC1wLTI1NkBleGFtcGxl\nLmNvbT6IeQQTEwgAIQUCU5SAxgIbAwYLCQgHAwIGFQgCCQoLAxYCAQIeAQIXgAAK\nCRA2iYNe+deDntxvAP90U2BUL2YcxrJYnsK783VIPM5U5/2IhH7azbRfaHiLZgEA\n1/BVNxRG/Q07gPSdEGagRZcrzPxMQPLjBL4T7Nq5eSG4VgRTlIDqEggqhkjOPQMB\nBwIDBJlWEj5qR12xbmp5dkjEkV+PRSfk37NKnw8axSJkyDTsFNZLIugMLX/zTn3r\nrOamvHUdXNbLy1s8PeyrztMcOnwDAQgHiGEEGBMIAAkFAlOUgOoCGwwACgkQNomD\nXvnXg556SQD+MCXRkYgLPd0NWWbCKl5wYk4NwWRvOCDFGk7eYoRTKaYBAIkt3J86\nBn0zCzsphjrIUlGPXhLSX/2aJQDuuK3zzLmn");
    byte[] sExprKeySub = Base64.decode((String)"KDIxOnByb3RlY3RlZC1wcml2YXRlLWtleSgzOmVjYyg1OmN1cnZlMTA6TklTVCBQLTI1NikoMTpxNjU6BJlWEj5qR12xbmp5dkjEkV+PRSfk37NKnw8axSJkyDTsFNZLIugMLX/zTn3rrOamvHUdXNbLy1s8PeyrztMcOnwpKDk6cHJvdGVjdGVkMjU6b3BlbnBncC1zMmszLXNoYTEtYWVzLWNiYygoNDpzaGExODpu2e7wpW4L5jg6MTI5MDU0NzIpMTY6ohIkbi1P1O7QX1zgPd7Ejik5NjrCoM9qBxzyLVJJMVRGlsjltF9/CeLnRPN1sjeiQrP1vAlZMPiOpYTmGDVRcZhdkCRO06MYUTLDZK1wsxELVD0s9irpbskcOnXwqtXbIqhoK4B+9pnkR0h5gi0xPIGSTtYpKDEyOnByb3RlY3RlZC1hdDE1OjIwMTQwNjA4VDE1MjgxMCkpKQ==");
    byte[] sExprKeyMaster = Base64.decode((String)"KDIxOnByb3RlY3RlZC1wcml2YXRlLWtleSgzOmVjYyg1OmN1cnZlMTA6TklTVCBQLTI1NikoMTpxNjU6BGqcUsIHwQRmQAQs2rOeTzJBq79/U8AJRNT9B72OXJtzbZs7nkF29l0WhrdGY1AeFH3zT8p5XAJDdw+l7o5AkUApKDk6cHJvdGVjdGVkMjU6b3BlbnBncC1zMmszLXNoYTEtYWVzLWNiYygoNDpzaGExODr4PqHT9W4lpTg6MTI5MDU0NzIpMTY6VsooQy9aGsuMpiObZk4y1ik5NjoCArOSmSsJIYUzxkRwy/HyDYPqjAqrNrh3m8lQco6k64Pf4SDda/0gKjkum7zYDEzBEvXI+ZodAST6z3IDkPHL7LUy5qp2LdG73xLRFjfsqOsZgP+nwoOSUiC7N4AWJPApKDEyOnByb3RlY3RlZC1hdDE1OjIwMTQwNjA4VDE1MjcwOSkpKQ==");
    byte[] encMessage = Base64.decode((String)"hH4DrQCblwYU61MSAgMEVXjgPW2hvIhUMQ2qlAQlAliZKbyujaYfLnwZTeGvu+pt\ngJXt+JJ8zWoENxLAp+Nb3PxJW4CjvkXQ2dEmmvkhBzAhDer86XJBrQLBQUL+6EmE\nl+/3Yzt+cPEyEn32BSpkt31F2yGncoefCUDgj9tKiFXSRwGhjRno0qzB3CfRWzDu\neelwwtRcxnvXNc44TuHRf4PgZ3d4dDU69bWQswdQ5UTP/Bjjo92yMLtJ3HtBuym+\nNazbQUh4M+SP");
    byte[] signedEncMessage = Base64.decode((String)"hH4DrQCblwYU61MSAgMEC/jpqjgnqotzKWNWJ3bhOxmmChghrV2PLQbQqtHtVvbj\nzyLpaPgeqLslMAjsdy8rlANCjlweZhtP1DmvHiYgjDAA54eptpLMtbULaQOoRcsZ\nZnMqhx9s5phAohNFGC+DnVU/IwxDOnI+ya54LOoXUrrSsgEKDTlAmYr4/oDmLTXt\nTaLgk0T9nBxGe8WbLwhPRBIyq6NX151aQ+pOobajrRiLwg/CwUsbAZ50bBPn2JjX\nwgBhBjyAn7D6bZ4hMl3YSluSiFkJhxZcYSydtIAlX35q4D/pJjT4mPT/y7ypytCU\n0wWo53O6NCSeM/EpeFw8RRh8fe+m33qpA6T5sR3Alg4ZukiIxLa36k6Cv5KTHmB3\n6lKZcgQDHNIKStV1bW4Cva1aXXQ=");

    public String getName() {
        return "PGPECMessageTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPECMessageTest());
    }

    public void performTest() throws Exception {
        this.testMasterKey();
        this.testEncMessage();
        this.testSignedEncMessage();
        this.testBCEncMessage();
        this.testBCSignedEncMessage();
    }

    private void testBCEncMessage() throws Exception {
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(this.encMessage);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        PGPPublicKey pGPPublicKey = new JcaPGPPublicKeyRing(this.testPubKey).getPublicKey(pGPPublicKeyEncryptedData.getKeyID());
        SExprParser sExprParser = new SExprParser(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build());
        PGPSecretKey pGPSecretKey = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.sExprKeySub), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("test".toCharArray()), pGPPublicKey);
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(new BcPublicKeyDataDecryptorFactory(pGPSecretKey.extractPrivateKey(null)));
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory.nextObject();
        PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(pGPCompressedData.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory2.nextObject();
        if (!"test.txt".equals(pGPLiteralData.getFileName())) {
            this.fail("wrong file name detected");
        }
    }

    private void testBCSignedEncMessage() throws Exception {
        int n;
        SExprParser sExprParser = new SExprParser(null);
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(this.signedEncMessage);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        JcaPGPPublicKeyRing jcaPGPPublicKeyRing = new JcaPGPPublicKeyRing(this.testPubKey);
        PGPPublicKey pGPPublicKey = jcaPGPPublicKeyRing.getPublicKey(pGPPublicKeyEncryptedData.getKeyID());
        PGPSecretKey pGPSecretKey = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.sExprKeySub), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("test".toCharArray()), pGPPublicKey);
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPSecretKey.extractPrivateKey(null)));
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory.nextObject();
        PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(pGPCompressedData.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)pGPObjectFactory2.nextObject();
        PGPOnePassSignature pGPOnePassSignature = pGPOnePassSignatureList.get(0);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory2.nextObject();
        if (!"test.txt".equals(pGPLiteralData.getFileName())) {
            this.fail("wrong file name detected");
        }
        InputStream inputStream2 = pGPLiteralData.getInputStream();
        pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), jcaPGPPublicKeyRing.getPublicKey(pGPOnePassSignature.getKeyID()));
        while ((n = inputStream2.read()) >= 0) {
            pGPOnePassSignature.update((byte)n);
        }
        PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory2.nextObject();
        if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
            this.fail("Failed signature check");
        }
    }

    private void testEncMessage() throws Exception {
        SExprParser sExprParser = new SExprParser(null);
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(this.encMessage);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        PGPPublicKey pGPPublicKey = new JcaPGPPublicKeyRing(this.testPubKey).getPublicKey(pGPPublicKeyEncryptedData.getKeyID());
        PGPSecretKey pGPSecretKey = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.sExprKeySub), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("test".toCharArray()), pGPPublicKey);
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPSecretKey.extractPrivateKey(null)));
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory.nextObject();
        PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(pGPCompressedData.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory2.nextObject();
        if (!"test.txt".equals(pGPLiteralData.getFileName())) {
            this.fail("wrong file name detected");
        }
    }

    private void testMasterKey() throws Exception {
        SExprParser sExprParser = new SExprParser(null);
        PGPSecretKey pGPSecretKey = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.sExprKeyMaster), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("test".toCharArray()), new JcaKeyFingerprintCalculator());
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(19, 8).setProvider("BC"));
        pGPSignatureGenerator.init(0, pGPSecretKey.extractPrivateKey(null));
        pGPSignatureGenerator.update("hello world!".getBytes());
        PGPSignature pGPSignature = pGPSignatureGenerator.generate();
        PGPPublicKey pGPPublicKey = new JcaPGPPublicKeyRing(this.testPubKey).getPublicKey();
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
        pGPSignature.update("hello world!".getBytes());
        if (!pGPSignature.verify()) {
            this.fail("signature failed to verify!");
        }
    }

    private void testSignedEncMessage() throws Exception {
        int n;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(this.signedEncMessage);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        JcaPGPPublicKeyRing jcaPGPPublicKeyRing = new JcaPGPPublicKeyRing(this.testPubKey);
        PGPPublicKey pGPPublicKey = jcaPGPPublicKeyRing.getPublicKey(pGPPublicKeyEncryptedData.getKeyID());
        SExprParser sExprParser = new SExprParser(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build());
        PGPSecretKey pGPSecretKey = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.sExprKeySub), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("test".toCharArray()), pGPPublicKey);
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPSecretKey.extractPrivateKey(null)));
        PGPObjectFactory pGPObjectFactory = new PGPObjectFactory(inputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPCompressedData pGPCompressedData = (PGPCompressedData)pGPObjectFactory.nextObject();
        PGPObjectFactory pGPObjectFactory2 = new PGPObjectFactory(pGPCompressedData.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)pGPObjectFactory2.nextObject();
        PGPOnePassSignature pGPOnePassSignature = pGPOnePassSignatureList.get(0);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)pGPObjectFactory2.nextObject();
        if (!"test.txt".equals(pGPLiteralData.getFileName())) {
            this.fail("wrong file name detected");
        }
        InputStream inputStream2 = pGPLiteralData.getInputStream();
        pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), jcaPGPPublicKeyRing.getPublicKey(pGPOnePassSignature.getKeyID()));
        while ((n = inputStream2.read()) >= 0) {
            pGPOnePassSignature.update((byte)n);
        }
        PGPSignatureList pGPSignatureList = (PGPSignatureList)pGPObjectFactory2.nextObject();
        if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
            this.fail("Failed signature check");
        }
    }
}

