/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.UncloseableOutputStream;

public class PGPEdDSATest
extends SimpleTest {
    private static final String edDSASampleKey = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: Alice's OpenPGP certificate\nComment: https://www.ietf.org/id/draft-bre-openpgp-samples-01.html\n\nmDMEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u120JkFsaWNlIExvdmVsYWNlIDxhbGljZUBvcGVucGdwLmV4YW1wbGU+iJAE\nExYIADgCGwMFCwkIBwIGFQoJCAsCBBYCAwECHgECF4AWIQTrhbtfozp14V6UTmPy\nMVUMT0fjjgUCXaWfOgAKCRDyMVUMT0fjjukrAPoDnHBSogOmsHOsd9qGsiZpgRnO\ndypvbm+QtXZqth9rvwD9HcDC0tC+PHAsO7OTh1S1TC9RiJsvawAfCPaQZoed8gK4\nOARcRwTpEgorBgEEAZdVAQUBAQdAQv8GIa2rSTzgqbXCpDDYMiKRVitCsy203x3s\nE9+eviIDAQgHiHgEGBYIACAWIQTrhbtfozp14V6UTmPyMVUMT0fjjgUCXEcE6QIb\nDAAKCRDyMVUMT0fjjlnQAQDFHUs6TIcxrNTtEZFjUFm1M0PJ1Dng/cDW4xN80fsn\n0QEA22Kr7VkCjeAEC08VSTeV+QFsmz55/lntWkwYWhmvOgE=\n=iIGO\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String edDSASecretKey = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nComment: Alice's OpenPGP Transferable Secret Key\nComment: https://www.ietf.org/id/draft-bre-openpgp-samples-01.html\n\nlFgEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\nb7O1u10AAP9XBeW6lzGOLx7zHH9AsUDUTb2pggYGMzd0P3ulJ2AfvQ4RtCZBbGlj\nZSBMb3ZlbGFjZSA8YWxpY2VAb3BlbnBncC5leGFtcGxlPoiQBBMWCAA4AhsDBQsJ\nCAcCBhUKCQgLAgQWAgMBAh4BAheAFiEE64W7X6M6deFelE5j8jFVDE9H444FAl2l\nnzoACgkQ8jFVDE9H447pKwD6A5xwUqIDprBzrHfahrImaYEZzncqb25vkLV2arYf\na78A/R3AwtLQvjxwLDuzk4dUtUwvUYibL2sAHwj2kGaHnfICnF0EXEcE6RIKKwYB\nBAGXVQEFAQEHQEL/BiGtq0k84Km1wqQw2DIikVYrQrMttN8d7BPfnr4iAwEIBwAA\n/3/xFPG6U17rhTuq+07gmEvaFYKfxRB6sgAYiW6TMTpQEK6IeAQYFggAIBYhBOuF\nu1+jOnXhXpROY/IxVQxPR+OOBQJcRwTpAhsMAAoJEPIxVQxPR+OOWdABAMUdSzpM\nhzGs1O0RkWNQWbUzQ8nUOeD9wNbjE3zR+yfRAQDbYqvtWQKN4AQLTxVJN5X5AWyb\nPnn+We1aTBhaGa86AQ==\n=n8OM\n-----END PGP PRIVATE KEY BLOCK-----\n";
    private static final String revBlock = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nComment: Alice's revocation certificate\nComment: https://www.ietf.org/id/draft-bre-openpgp-samples-01.html\n\niHgEIBYIACAWIQTrhbtfozp14V6UTmPyMVUMT0fjjgUCXaWkOwIdAAAKCRDyMVUM\nT0fjjoBlAQDA9ukZFKRFGCooVcVoDVmxTaHLUXlIg9TPh2f7zzI9KgD/SLNXUOaH\nO6TozOS7C9lwIHwwdHdAxgf5BzuhLT9iuAM=\n=Tm8h\n-----END PGP PUBLIC KEY BLOCK-----\n";

    private void aliceBcKeyTest() throws Exception {
        int n;
        byte[] byArray = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 33, 10};
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)edDSASampleKey)));
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(armoredInputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)edDSASecretKey)));
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(armoredInputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey(5145070902336167606L);
        PGPPrivateKey pGPPrivateKey = pGPSecretKeyRing.getSecretKey(5145070902336167606L).extractPrivateKey(null);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)byteArrayOutputStream, 'u', "_CONSOLE", byArray.length, new Date());
        outputStream.write(byArray);
        outputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        BcPGPDataEncryptorBuilder bcPGPDataEncryptorBuilder = new BcPGPDataEncryptorBuilder(7);
        bcPGPDataEncryptorBuilder.setWithIntegrityPacket(true);
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(bcPGPDataEncryptorBuilder);
        BcPublicKeyKeyEncryptionMethodGenerator bcPublicKeyKeyEncryptionMethodGenerator = new BcPublicKeyKeyEncryptionMethodGenerator(pGPPublicKey);
        pGPEncryptedDataGenerator.addMethod(bcPublicKeyKeyEncryptionMethodGenerator);
        OutputStream outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), byArray2.length);
        outputStream2.write(byArray2);
        outputStream2.close();
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byteArrayOutputStream2.toByteArray());
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(new BcPublicKeyDataDecryptorFactory(pGPPrivateKey));
        jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        inputStream = pGPLiteralData.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream3.write(n);
        }
        byte[] byArray3 = byteArrayOutputStream3.toByteArray();
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("wrong plain text in generated packet");
        }
    }

    private void encryptDecryptBcTest(PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey) throws Exception {
        int n;
        byte[] byArray = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 33, 10};
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)byteArrayOutputStream, 'u', "_CONSOLE", byArray.length, new Date());
        outputStream.write(byArray);
        outputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new BcPGPDataEncryptorBuilder(3).setSecureRandom(new SecureRandom()));
        pGPEncryptedDataGenerator.addMethod(new BcPublicKeyKeyEncryptionMethodGenerator(pGPPublicKey));
        OutputStream outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), byArray2.length);
        outputStream2.write(byArray2);
        outputStream2.close();
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(byteArrayOutputStream2.toByteArray());
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)bcPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(new BcPublicKeyDataDecryptorFactory(pGPPrivateKey));
        bcPGPObjectFactory = new BcPGPObjectFactory(inputStream);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)bcPGPObjectFactory.nextObject();
        inputStream = pGPLiteralData.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream3.write(n);
        }
        byte[] byArray3 = byteArrayOutputStream3.toByteArray();
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("wrong plain text in generated packet");
        }
    }

    private void encryptDecryptTest(PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey) throws Exception {
        int n;
        byte[] byArray = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 33, 10};
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)byteArrayOutputStream, 'u', "_CONSOLE", byArray.length, new Date());
        outputStream.write(byArray);
        outputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setProvider("BC").setSecureRandom(new SecureRandom()));
        pGPEncryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey).setProvider("BC"));
        OutputStream outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), byArray2.length);
        outputStream2.write(byArray2);
        outputStream2.close();
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byteArrayOutputStream2.toByteArray());
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
        jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        inputStream = pGPLiteralData.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream3.write(n);
        }
        byte[] byArray3 = byteArrayOutputStream3.toByteArray();
        if (!this.areEqual(byArray3, byArray)) {
            this.fail("wrong plain text in generated packet");
        }
    }

    public String getName() {
        return "PGPEdDSATest";
    }

    private void keyringBcTest() throws Exception {
        Object object;
        String string = "eric@bouncycastle.org";
        char[] cArray = "Hello, world!".toCharArray();
        Ed25519KeyPairGenerator ed25519KeyPairGenerator = new Ed25519KeyPairGenerator();
        ed25519KeyPairGenerator.init((KeyGenerationParameters)new Ed25519KeyGenerationParameters(null));
        BcPGPKeyPair bcPGPKeyPair = new BcPGPKeyPair(22, ed25519KeyPairGenerator.generateKeyPair(), new Date());
        X25519KeyPairGenerator x25519KeyPairGenerator = new X25519KeyPairGenerator();
        x25519KeyPairGenerator.init((KeyGenerationParameters)new X25519KeyGenerationParameters(null));
        BcPGPKeyPair bcPGPKeyPair2 = new BcPGPKeyPair(18, x25519KeyPairGenerator.generateKeyPair(), new Date());
        this.encryptDecryptBcTest(bcPGPKeyPair2.getPublicKey(), bcPGPKeyPair2.getPrivateKey());
        this.encryptDecryptTest(bcPGPKeyPair2.getPublicKey(), bcPGPKeyPair2.getPrivateKey());
        PGPDigestCalculator pGPDigestCalculator = new BcPGPDigestCalculatorProvider().get(2);
        PGPKeyRingGenerator pGPKeyRingGenerator = new PGPKeyRingGenerator(19, bcPGPKeyPair, string, pGPDigestCalculator, null, null, new BcPGPContentSignerBuilder(bcPGPKeyPair.getPublicKey().getAlgorithm(), 8), new BcPBESecretKeyEncryptorBuilder(9, pGPDigestCalculator).build(cArray));
        pGPKeyRingGenerator.addSubKey(bcPGPKeyPair2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPSecretKeyRing pGPSecretKeyRing = pGPKeyRingGenerator.generateSecretKeyRing();
        PGPPublicKeyRing pGPPublicKeyRing = pGPKeyRingGenerator.generatePublicKeyRing();
        pGPSecretKeyRing.encode(byteArrayOutputStream);
        byteArrayOutputStream.close();
        pGPSecretKeyRing = new PGPSecretKeyRing(byteArrayOutputStream.toByteArray(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Iterator iterator = pGPSecretKeyRing.getPublicKeys();
        iterator.next();
        PGPPublicKey pGPPublicKey = (PGPPublicKey)iterator.next();
        PGPPublicKey pGPPublicKey2 = pGPSecretKeyRing.getPublicKey();
        Iterator iterator2 = pGPPublicKey.getSignatures();
        int n = 0;
        while (iterator2.hasNext()) {
            object = (PGPSignature)iterator2.next();
            if (((PGPSignature)object).getKeyID() != pGPPublicKey2.getKeyID() || ((PGPSignature)object).getSignatureType() != 24) continue;
            ++n;
            ((PGPSignature)object).init(new BcPGPContentVerifierBuilderProvider(), pGPPublicKey2);
            if (((PGPSignature)object).verifyCertification(pGPPublicKey2, pGPPublicKey)) continue;
            this.fail("failed to verify sub-key signature.");
        }
        this.isTrue(n == 1);
        pGPSecretKeyRing = new PGPSecretKeyRing(byteArrayOutputStream.toByteArray(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        object = null;
        PGPPrivateKey pGPPrivateKey = null;
        Iterator iterator3 = pGPSecretKeyRing.getPublicKeys();
        while (iterator3.hasNext()) {
            object = (PGPPublicKey)iterator3.next();
            if (!((PGPPublicKey)object).isEncryptionKey()) continue;
            pGPPrivateKey = pGPSecretKeyRing.getSecretKey(((PGPPublicKey)object).getKeyID()).extractPrivateKey(new BcPBESecretKeyDecryptorBuilder(new BcPGPDigestCalculatorProvider()).build(cArray));
            break;
        }
        this.encryptDecryptBcTest((PGPPublicKey)object, pGPPrivateKey);
        this.encryptDecryptTest((PGPPublicKey)object, pGPPrivateKey);
    }

    private void keyringTest() throws Exception {
        Object object;
        String string = "eric@bouncycastle.org";
        char[] cArray = "Hello, world!".toCharArray();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EdDSA", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("Ed25519"));
        JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(22, ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair(), new Date());
        KeyPairGenerator keyPairGenerator2 = KeyPairGenerator.getInstance("XDH", "BC");
        keyPairGenerator2.initialize((AlgorithmParameterSpec)new ECNamedCurveGenParameterSpec("X25519"));
        JcaPGPKeyPair jcaPGPKeyPair2 = new JcaPGPKeyPair(18, ((KeyPairGeneratorSpi)keyPairGenerator2).generateKeyPair(), new Date());
        this.encryptDecryptTest(jcaPGPKeyPair2.getPublicKey(), jcaPGPKeyPair2.getPrivateKey());
        this.encryptDecryptBcTest(jcaPGPKeyPair2.getPublicKey(), jcaPGPKeyPair2.getPrivateKey());
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        PGPKeyRingGenerator pGPKeyRingGenerator = new PGPKeyRingGenerator(19, jcaPGPKeyPair, string, pGPDigestCalculator, null, null, new JcaPGPContentSignerBuilder(jcaPGPKeyPair.getPublicKey().getAlgorithm(), 8), new JcePBESecretKeyEncryptorBuilder(9, pGPDigestCalculator).setProvider("BC").build(cArray));
        pGPKeyRingGenerator.addSubKey(jcaPGPKeyPair2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPSecretKeyRing pGPSecretKeyRing = pGPKeyRingGenerator.generateSecretKeyRing();
        PGPPublicKeyRing pGPPublicKeyRing = pGPKeyRingGenerator.generatePublicKeyRing();
        pGPSecretKeyRing.encode(byteArrayOutputStream);
        byteArrayOutputStream.close();
        pGPSecretKeyRing = new PGPSecretKeyRing(byteArrayOutputStream.toByteArray(), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator iterator = pGPSecretKeyRing.getPublicKeys();
        iterator.next();
        PGPPublicKey pGPPublicKey = (PGPPublicKey)iterator.next();
        PGPPublicKey pGPPublicKey2 = pGPSecretKeyRing.getPublicKey();
        Iterator iterator2 = pGPPublicKey.getSignatures();
        int n = 0;
        while (iterator2.hasNext()) {
            object = (PGPSignature)iterator2.next();
            if (((PGPSignature)object).getKeyID() != pGPPublicKey2.getKeyID() || ((PGPSignature)object).getSignatureType() != 24) continue;
            ++n;
            ((PGPSignature)object).init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey2);
            if (((PGPSignature)object).verifyCertification(pGPPublicKey2, pGPPublicKey)) continue;
            this.fail("failed to verify sub-key signature.");
        }
        this.isTrue(n == 1);
        pGPSecretKeyRing = new PGPSecretKeyRing(byteArrayOutputStream.toByteArray(), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        object = null;
        PGPPrivateKey pGPPrivateKey = null;
        Iterator iterator3 = pGPSecretKeyRing.getPublicKeys();
        while (iterator3.hasNext()) {
            object = (PGPPublicKey)iterator3.next();
            if (!((PGPPublicKey)object).isEncryptionKey()) continue;
            pGPPrivateKey = pGPSecretKeyRing.getSecretKey(((PGPPublicKey)object).getKeyID()).extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().build(cArray));
            break;
        }
        this.encryptDecryptTest((PGPPublicKey)object, pGPPrivateKey);
        this.encryptDecryptBcTest((PGPPublicKey)object, pGPPrivateKey);
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPEdDSATest());
    }

    public void performTest() throws Exception {
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)edDSASampleKey)));
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(armoredInputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        this.isTrue(this.areEqual(Hex.decode((String)"EB85 BB5F A33A 75E1 5E94 4E63 F231 550C 4F47 E38E"), pGPPublicKeyRing.getPublicKey().getFingerprint()));
        armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)edDSASecretKey)));
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(armoredInputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        this.isTrue(pGPSecretKeyRing.getSecretKey().isSigningKey());
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(22, 8));
        pGPSignatureGenerator.init(24, pGPSecretKeyRing.getSecretKey().extractPrivateKey(null));
        PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(pGPPublicKeyRing.getPublicKey(), pGPPublicKeyRing.getPublicKey(5145070902336167606L));
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKeyRing.getPublicKey());
        this.isTrue(pGPSignature.verifyCertification(pGPPublicKeyRing.getPublicKey(), pGPPublicKeyRing.getPublicKey(5145070902336167606L)));
        this.encryptDecryptTest(pGPPublicKeyRing.getPublicKey(5145070902336167606L), pGPSecretKeyRing.getSecretKey(5145070902336167606L).extractPrivateKey(null));
        this.encryptDecryptBcTest(pGPPublicKeyRing.getPublicKey(5145070902336167606L), pGPSecretKeyRing.getSecretKey(5145070902336167606L).extractPrivateKey(null));
        armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)revBlock)));
        PGPSignatureList pGPSignatureList = (PGPSignatureList)new PGPObjectFactory(armoredInputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator()).nextObject();
        pGPSignature = pGPSignatureList.get(0);
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKeyRing.getPublicKey());
        this.isTrue(pGPSignature.verifyCertification(pGPPublicKeyRing.getPublicKey()));
        this.keyringTest();
        this.keyringBcTest();
        this.sksKeyTest();
        this.aliceBcKeyTest();
    }

    private void sksKeyTest() throws Exception {
        byte[] byArray = Strings.toByteArray((String)"testing, 1, 2, 3, testing...");
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(((Object)((Object)this)).getClass().getResourceAsStream("eddsa-sks-pub-keyring.asc"));
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(armoredInputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        BcPGPDataEncryptorBuilder bcPGPDataEncryptorBuilder = new BcPGPDataEncryptorBuilder(7);
        bcPGPDataEncryptorBuilder.setWithIntegrityPacket(true);
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(bcPGPDataEncryptorBuilder);
        BcPublicKeyKeyEncryptionMethodGenerator bcPublicKeyKeyEncryptionMethodGenerator = new BcPublicKeyKeyEncryptionMethodGenerator(pGPPublicKeyRing.getPublicKey(6752245936421807937L));
        pGPEncryptedDataGenerator.addMethod(bcPublicKeyKeyEncryptionMethodGenerator);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream), byArray.length);
        outputStream.write(byArray);
        outputStream.close();
    }
}

