/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.UncloseableOutputStream;

public class PGPPBETest
extends SimpleTest {
    private static final Date TEST_DATE = new Date(1062200111000L);
    byte[] enc1 = Base64.decode((String)"jA0EAwMC5M5wWBP2HBZgySvUwWFAmMRLn7dWiZN6AkQMvpE3b6qwN3SSun7zInw2hxxdgFzVGfbjuB8w");
    byte[] enc1crc = Base64.decode((String)"H66L");
    char[] pass = new char[]{'h', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd'};
    byte[] testPBEAsym = Base64.decode((String)"hQIOA/ZlQEFWB5vuEAf/covEUaBve7NlWWdiO5NZubdtTHGElEXzG9hyBycp9At8nZGi27xOZtEGFQo7pfz4JySRc3O0s6w7PpjJSonFJyNSxuze2LuqRwFWBYYcbS8/7YcjB6PqutrT939OWsozfNqivI9/QyZCjBvFU89pp7dtUngiZ6MVv81ds2I+vcvkGlIFcxcE1XoCIB3EvbqWNaoOotgEPT60unnB2BeDV1KD3lDRouMIYHfZ3SzBwOOI6aK39sWnY5sAK7JjFvnDAMBdueOiI0Fy+gxbFD/zFDt4cWAVSAGTC4w371iqppmT25TM7zAtCgpiq5IsELPlUZZnXKmnYQ7OCeysF0eeVwf+OFB9fyvCEv/zVQocJCg8fWxfCBlIVFNeNQpeGygn/ZmRaILvB7IXDWP0oOw7/F2Ym66IdYYIp2HeEZv+jFwal41w5W4BH/gtbwGjFQ6CvF/m+lfUv6ZZdzsMIeEOwhP5g7rXBxrbcnGBaU+PXbhogjDqaYzAWGlrmAd6aPSj51AGeYXkb2T1T/yoJ++M3GvhH4C4hvitamDkksh/qRnMM/s8Nku6z1+RXO3M6p5QC1nlAVqieU8esT43945eSoC77K8WyujDNbysDyUCUTztp/aoQwe/HgkeOTJNelKR9y2W3xinZLFzep0SqpNI/e468yB/2/LGsykIyQa7JX6rBYwuBAIDAkOKfv5rK8v0YDfnN+eFqwhTcrfBj5rDH7hER6nW3lNWcMataUiHEaMgo6Q0OO1vptIGxW8jClTD4N1sCNwNu9vKny8dKYDDHbCjE06DNTv7XYVW3+JqTL5EBnidvGgOmA==");

    private byte[] decryptMessage(byte[] byArray, Date date) throws Exception {
        int n;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byArray);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream = pGPPBEEncryptedData.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass));
        JcaPGPObjectFactory jcaPGPObjectFactory2 = new JcaPGPObjectFactory(inputStream);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory2.nextObject();
        jcaPGPObjectFactory2 = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory2.nextObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!pGPLiteralData.getFileName().equals("test.txt") && !pGPLiteralData.getFileName().equals("_CONSOLE")) {
            this.fail("wrong filename in packet");
        }
        if (!pGPLiteralData.getModificationTime().equals(date)) {
            this.fail("wrong modification time in packet: " + pGPLiteralData.getModificationTime().getTime() + " " + date.getTime());
        }
        InputStream inputStream2 = pGPLiteralData.getInputStream();
        while ((n = inputStream2.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        if (pGPPBEEncryptedData.isIntegrityProtected() && !pGPPBEEncryptedData.verify()) {
            this.fail("integrity check failed");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] decryptMessageBuffered(byte[] byArray, Date date) throws Exception {
        int n;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byArray);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream = pGPPBEEncryptedData.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass));
        JcaPGPObjectFactory jcaPGPObjectFactory2 = new JcaPGPObjectFactory(inputStream);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory2.nextObject();
        jcaPGPObjectFactory2 = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory2.nextObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!pGPLiteralData.getFileName().equals("test.txt") && !pGPLiteralData.getFileName().equals("_CONSOLE")) {
            this.fail("wrong filename in packet");
        }
        if (!pGPLiteralData.getModificationTime().equals(date)) {
            this.fail("wrong modification time in packet: " + pGPLiteralData.getModificationTime().getTime() + " " + date.getTime());
        }
        InputStream inputStream2 = pGPLiteralData.getInputStream();
        byte[] byArray2 = new byte[1024];
        while ((n = inputStream2.read(byArray2)) >= 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        if (pGPPBEEncryptedData.isIntegrityProtected() && !pGPPBEEncryptedData.verify()) {
            this.fail("integrity check failed");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getName() {
        return "PGPPBETest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPPBETest());
    }

    public void performTest() throws Exception {
        int n;
        byte[] byArray = this.decryptMessage(this.enc1, TEST_DATE);
        if (byArray[0] != 104 || byArray[1] != 101 || byArray[2] != 108) {
            this.fail("wrong plain text in packet");
        }
        byte[] byArray2 = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 33, 10};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        Date date = new Date(System.currentTimeMillis() / 1000L * 1000L);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream = pGPCompressedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream));
        OutputStream outputStream2 = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream(outputStream), 'b', "_CONSOLE", byArray2.length, date);
        outputStream2.write(byArray2);
        outputStream2.close();
        outputStream.close();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setSecureRandom(new SecureRandom()).setProvider("BC"));
        pGPEncryptedDataGenerator.addMethod(new JcePBEKeyEncryptionMethodGenerator(this.pass).setProvider("BC"));
        OutputStream outputStream3 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), byteArrayOutputStream.toByteArray().length);
        outputStream3.write(byteArrayOutputStream.toByteArray());
        outputStream3.close();
        byArray = this.decryptMessage(byteArrayOutputStream2.toByteArray(), date);
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("wrong plain text in generated packet");
        }
        byteArrayOutputStream2 = new ByteArrayOutputStream();
        pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setSecureRandom(new SecureRandom()).setProvider("BC"));
        pGPEncryptedDataGenerator.addMethod(new JcePBEKeyEncryptionMethodGenerator(this.pass).setProvider("BC"));
        outputStream3 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), byteArrayOutputStream.toByteArray().length);
        outputStream3.write(byteArrayOutputStream.toByteArray());
        pGPEncryptedDataGenerator.close();
        byArray = this.decryptMessage(byteArrayOutputStream2.toByteArray(), date);
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("wrong plain text in generated packet");
        }
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray3 = new byte[1233];
        secureRandom.nextBytes(byArray3);
        byteArrayOutputStream = new ByteArrayOutputStream();
        pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        outputStream = pGPCompressedDataGenerator.open(byteArrayOutputStream);
        pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        outputStream2 = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream(outputStream), 'b', "_CONSOLE", TEST_DATE, new byte[16]);
        outputStream2.write(byArray3);
        outputStream2.close();
        outputStream.close();
        byteArrayOutputStream2 = new ByteArrayOutputStream();
        pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setSecureRandom(secureRandom).setProvider("BC"));
        pGPEncryptedDataGenerator.addMethod(new JcePBEKeyEncryptionMethodGenerator(this.pass).setProvider("BC"));
        outputStream3 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), new byte[16]);
        outputStream3.write(byteArrayOutputStream.toByteArray());
        outputStream3.close();
        byArray = this.decryptMessage(byteArrayOutputStream2.toByteArray(), TEST_DATE);
        if (!this.areEqual(byArray, byArray3)) {
            this.fail("wrong plain text in generated packet");
        }
        byteArrayOutputStream2 = new ByteArrayOutputStream();
        pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setWithIntegrityPacket(true).setSecureRandom(secureRandom).setProvider("BC"));
        pGPEncryptedDataGenerator.addMethod(new JcePBEKeyEncryptionMethodGenerator(this.pass).setProvider("BC"));
        outputStream3 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), new byte[16]);
        outputStream3.write(byteArrayOutputStream.toByteArray());
        outputStream3.close();
        byArray = this.decryptMessage(byteArrayOutputStream2.toByteArray(), TEST_DATE);
        if (!this.areEqual(byArray, byArray3)) {
            this.fail("wrong plain text in generated packet");
        }
        if (!this.areEqual(byArray = this.decryptMessageBuffered(byteArrayOutputStream2.toByteArray(), TEST_DATE), byArray3)) {
            this.fail("wrong plain text in buffer generated packet");
        }
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(this.testPBEAsym);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(1);
        InputStream inputStream = pGPPBEEncryptedData.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build("password".toCharArray()));
        jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream2 = pGPLiteralData.getInputStream();
        while ((n = inputStream2.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        if (!this.areEqual(byteArrayOutputStream.toByteArray(), Hex.decode((String)"5361742031302e30322e30370d0a"))) {
            this.fail("data mismatch on combined PBE");
        }
        byte[] byArray4 = new byte[1];
        byteArrayOutputStream = new ByteArrayOutputStream();
        pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        outputStream = pGPCompressedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream));
        outputStream2 = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream(outputStream), 'b', "_CONSOLE", byArray4.length, date);
        outputStream2.write(byArray4);
        outputStream2.close();
        outputStream.close();
        byteArrayOutputStream2 = new ByteArrayOutputStream();
        pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setWithIntegrityPacket(true).setSecureRandom(secureRandom).setProvider("BC"));
        pGPEncryptedDataGenerator.addMethod(new JcePBEKeyEncryptionMethodGenerator(this.pass).setProvider("BC"));
        outputStream3 = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), new byte[16]);
        outputStream3.write(byteArrayOutputStream.toByteArray());
        outputStream3.close();
        byArray = this.decryptMessage(byteArrayOutputStream2.toByteArray(), date);
        if (!this.areEqual(byArray, byArray4)) {
            this.fail("wrong plain text in generated packet");
        }
        if (!this.areEqual(byArray = this.decryptMessageBuffered(byteArrayOutputStream2.toByteArray(), date), byArray4)) {
            this.fail("wrong plain text in buffer generated packet");
        }
    }
}

