/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import java.util.Random;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.UncloseableOutputStream;

public class PGPPacketTest
extends SimpleTest {
    private static int MAX = 32000;

    private void bufferTest(PGPLiteralDataGenerator pGPLiteralDataGenerator, byte[] byArray, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream), 'b', "_CONSOLE", n, new Date());
        outputStream.write(byArray, 0, n);
        pGPLiteralDataGenerator.close();
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byteArrayOutputStream.toByteArray());
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        InputStream inputStream = pGPLiteralData.getInputStream();
        int n2 = 0;
        while (n2 != n) {
            if (inputStream.read() != (byArray[n2] & 0xFF)) {
                this.fail("failed readback test - length = " + n);
            }
            ++n2;
        }
    }

    public String getName() {
        return "PGPPacketTest";
    }

    private void iteratorTest() throws IOException {
        Object object;
        Object object2;
        int n = 5;
        int n2 = 0;
        int n3 = 50;
        int n4 = n * n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        while (n5 < n4) {
            byArray[n5] = (byte)(n5 - 1);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n) {
            object2 = new PGPLiteralDataGenerator();
            object = ((PGPLiteralDataGenerator)object2).open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream), 'b', "_CONSOLE", n3, new Date());
            ((OutputStream)object).write(byArray, n3 * n6, n3);
            ((PGPLiteralDataGenerator)object2).close();
            ++n6;
        }
        object2 = new JcaPGPObjectFactory(byteArrayOutputStream.toByteArray());
        object = ((PGPObjectFactory)object2).iterator();
        while (object.hasNext()) {
            int n7;
            PGPLiteralData pGPLiteralData = (PGPLiteralData)object.next();
            InputStream inputStream = pGPLiteralData.getInputStream();
            int n8 = inputStream.read(byArray2, n2 * n3, n3);
            if (n8 != n3) {
                this.fail("not enough bytes read in iterator test: " + n8);
            }
            if ((n7 = inputStream.read()) != -1) {
                this.fail("too many bytes read in iterator test");
            }
            ++n2;
        }
        if (n2 != n) {
            this.fail("wrong number of packets read in iterator test: " + n2);
        }
        int n9 = 0;
        while (n9 < n4) {
            if (byArray[n9] != byArray2[n9]) {
                this.fail("wrong content in iterator test");
            }
            ++n9;
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPPacketTest());
    }

    public void performTest() throws IOException {
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator(true);
        this.readBackTest(pGPLiteralDataGenerator);
        PGPLiteralDataGenerator pGPLiteralDataGenerator2 = new PGPLiteralDataGenerator(false);
        this.readBackTest(pGPLiteralDataGenerator2);
        this.iteratorTest();
    }

    private void readBackTest(PGPLiteralDataGenerator pGPLiteralDataGenerator) throws IOException {
        Random random = new Random();
        byte[] byArray = new byte[MAX];
        random.nextBytes(byArray);
        int n = 1;
        while (n <= 200) {
            this.bufferTest(pGPLiteralDataGenerator, byArray, n);
            ++n;
        }
        this.bufferTest(pGPLiteralDataGenerator, byArray, 8382);
        this.bufferTest(pGPLiteralDataGenerator, byArray, 8383);
        this.bufferTest(pGPLiteralDataGenerator, byArray, 8384);
        this.bufferTest(pGPLiteralDataGenerator, byArray, 8385);
        int n2 = 200;
        while (n2 < MAX) {
            this.bufferTest(pGPLiteralDataGenerator, byArray, n2);
            n2 += 100;
        }
    }
}

