/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PGPPublicKeyMergeTest
extends SimpleTest {
    private static final String CERT_1_BASE = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQENBFpR6SYBCADHOPHgWgYXScJT2UnxolWTPxf3WN20T9XWMIbK3aefLkTfoQE0\n4qEDhGe8u7FCpPMuLg1qN9Skvb77kHsHaCqiAips+ttNxl2LyzRAaXxRhCU9kEGi\nsY3e1CAex0BN7KtuIKJqTkXJ4Onw1i/u0jgIYaVG0PStPxaGgDgnxIGoTEYSRIKV\nSbkPqmL8r7chvQkon+0/Pua3Tm5xeEtQVzMEeCE76LP5e2WBH5YbesjLmBhCSiG2\nFaVVwzn1C+MITOsrV0VT/epeh6khdtFVdpJD4C8umXLjzMA2RwSEjg5W5aT726mT\niePDKYtNuijUW2dDz3tGNM2yzvrn1dhMsZq/ABEBAAG0IlN0ZXZlIEJhbm5vbiA8\nc3RldmVAYnJlaXRiYXJ0LmNvbT6JAVMEEwEIAD4WIQThqY8mUmGJJIKzkiLzRdbA\n3IPZsQUCWlHpJgIbAwUJA8JnAAULCQgHAgYVCAkKCwIEFgIDAQIeAQIXgAAKCRDz\nRdbA3IPZsexqB/dsaZFEOh+GdgcHETLJ/GYmRkSznioIB78y6Iqhj8dQNP2QK9mp\nIazLwzfoRak2hFPR5U8eT1H9pOIPilXN7IS3fEVm6qDGUmtP+uLa23M349GYiOHZ\nFiiNkfuhf+EcuqxnkAZ8Ck6dc/sdhw1VLZZtXNUbmzPCjoeZeV0Z0KH8ESWG6e/I\njTxBtNtllywymzt04wnbCZmBgepT4fX2ALyO8YoEoGXcMaxkhk58Iv4bJhICpBak\nfFFvlo7e74jGK+Qas6A5V9n7ldy5EhBrL++cj2wimszfjLCAY+4IFcDPEjyh3UBS\neUTJ+3ES5uR64yHX+N1rxTMQPptGLdIlSF65AQ0EWlHpJgEIAMVn35wITWO78ZQc\nKWIOxelWxt15r3v0cwcEL3Rw3F6zq7NNKV3xooeVD/cQZO0pB0tTkOTbSifAJ42h\n6tgOiwggpJN4O9+MMCu9ScPjJT4BEkU7FYFJEkCEwyIl1h/1DAPe0HpXmhpg76Ir\nTHKyx9Zgaz+snNteILUMdfGGY7q8m1ah6gGR5C2EOaMUmrPjHBuWacY8RXjhMg86\nHmAWOdRKe2otw3m6Eo/s201m723lcfTwHcxSs4BwSU1RNrLNdrZJf8kUEzb7HKcZ\nvUeHUzF92Nch9bGOvkQ3G4jvqiXgZAHenIRUJ/GNnSTNzBLramO9glApC56/n8RS\nxjwBXV8AEQEAAYkBNgQYAQgAIBYhBOGpjyZSYYkkgrOSIvNF1sDcg9mxBQJaUekm\nAhsMAAoJEPNF1sDcg9mxZ98H/0FZW9H/6I567zLtTh6qB7Mx8RMd28Lnl1BY1Zkg\nIxveGd9w9WrskHjEG3uHqqCyHTgX+cinW4gbxFFmWtFkoeBXe/VdXkSU5g4W4qET\ndzPU4hsPSJdksEjhtJD7FasywFRRjXraslhekYc/OXyPTisK5Z+yTygTfvwIBLot\nL1SINCtgalDHvD7QNrpBsGk5RuhG1gxezeC0AdQrJDzJSzu4wDNYFfU70ihiqdxx\niBo3vMiAgMOrmymSFMml4UVoiqo5MZ/LPZgrAGVfOtuDdCLPd3w5lQp6exaTWlCb\n+zmP3wxuI3sZw0in61T3miYRYy5zUyl4snO3q7CLcURhCBM=\n=2faY\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_1_ADD_UID_1 = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nDG4jexnDSKfrVPeaJhFjLnNTKXiyc7ersItxRGEIEw==\n=F4ya\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_1_ADD_UID_2 = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\np+tU95omEWMuc1MpeLJzt6uwi3FEYQgT\n=QO0q\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String CERT_1_ADD_UID_3 = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nDG4jexnDSKfrVPeaJhFjLnNTKXiyc7ersItxRGEIEw==\n=Q9fi\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String CERT_1_ALL_UIDS = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nGcNIp+tU95omEWMuc1MpeLJzt6uwi3FEYQgT\n=c2Kx\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String CERT_1_ADD_SUBKEY_1 = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nRKo/WjxUUnqjZytHjc9FSNjc\n=N/eW\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_1_ADD_SUBKEY_2 = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\ncSITs2pJySSXye9sARIsbpRV0rbmR37sEZTlUl2hdqfzZyJ99058/jQDDWo=\n=zbTd\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String CERT_1_ADD_SUBKEY_3 = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nmQENBFpR6SYBCADHOPHgWgYXScJT2UnxolWTPxf3WN20T9XWMIbK3aefLkTfoQE0\n4qEDhGe8u7FCpPMuLg1qN9Skvb77kHsHaCqiAips+ttNxl2LyzRAaXxRhCU9kEGi\nsY3e1CAex0BN7KtuIKJqTkXJ4Onw1i/u0jgIYaVG0PStPxaGgDgnxIGoTEYSRIKV\nSbkPqmL8r7chvQkon+0/Pua3Tm5xeEtQVzMEeCE76LP5e2WBH5YbesjLmBhCSiG2\nFaVVwzn1C+MITOsrV0VT/epeh6khdtFVdpJD4C8umXLjzMA2RwSEjg5W5aT726mT\niePDKYtNuijUW2dDz3tGNM2yzvrn1dhMsZq/ABEBAAG0IlN0ZXZlIEJhbm5vbiA8\nc3RldmVAYnJlaXRiYXJ0LmNvbT6JAVMEEwEIAD4WIQThqY8mUmGJJIKzkiLzRdbA\n3IPZsQUCWlHpJgIbAwUJA8JnAAULCQgHAgYVCAkKCwIEFgIDAQIeAQIXgAAKCRDz\nRdbA3IPZsexqB/dsaZFEOh+GdgcHETLJ/GYmRkSznioIB78y6Iqhj8dQNP2QK9mp\nIazLwzfoRak2hFPR5U8eT1H9pOIPilXN7IS3fEVm6qDGUmtP+uLa23M349GYiOHZ\nFiiNkfuhf+EcuqxnkAZ8Ck6dc/sdhw1VLZZtXNUbmzPCjoeZeV0Z0KH8ESWG6e/I\njTxBtNtllywymzt04wnbCZmBgepT4fX2ALyO8YoEoGXcMaxkhk58Iv4bJhICpBak\nfFFvlo7e74jGK+Qas6A5V9n7ldy5EhBrL++cj2wimszfjLCAY+4IFcDPEjyh3UBS\neUTJ+3ES5uR64yHX+N1rxTMQPptGLdIlSF65AQ0EWlHpJgEIAMVn35wITWO78ZQc\nKWIOxelWxt15r3v0cwcEL3Rw3F6zq7NNKV3xooeVD/cQZO0pB0tTkOTbSifAJ42h\n6tgOiwggpJN4O9+MMCu9ScPjJT4BEkU7FYFJEkCEwyIl1h/1DAPe0HpXmhpg76Ir\nTHKyx9Zgaz+snNteILUMdfGGY7q8m1ah6gGR5C2EOaMUmrPjHBuWacY8RXjhMg86\nHmAWOdRKe2otw3m6Eo/s201m723lcfTwHcxSs4BwSU1RNrLNdrZJf8kUEzb7HKcZ\nvUeHUzF92Nch9bGOvkQ3G4jvqiXgZAHenIRUJ/GNnSTNzBLramO9glApC56/n8RS\nxjwBXV8AEQEAAYkBNgQYAQgAIBYhBOGpjyZSYYkkgrOSIvNF1sDcg9mxBQJaUekm\nAhsMAAoJEPNF1sDcg9mxZ98H/0FZW9H/6I567zLtTh6qB7Mx8RMd28Lnl1BY1Zkg\nIxveGd9w9WrskHjEG3uHqqCyHTgX+cinW4gbxFFmWtFkoeBXe/VdXkSU5g4W4qET\ndzPU4hsPSJdksEjhtJD7FasywFRRjXraslhekYc/OXyPTisK5Z+yTygTfvwIBLot\nL1SINCtgalDHvD7QNrpBsGk5RuhG1gxezeC0AdQrJDzJSzu4wDNYFfU70ihiqdxx\niBo3vMiAgMOrmymSFMml4UVoiqo5MZ/LPZgrAGVfOtuDdCLPd3w5lQp6exaTWlCb\n+zmP3wxuI3sZw0in61T3miYRYy5zUyl4snO3q7CLcURhCBO5Ag0EWlHxLwEQAOjN\npvSomMuDPg3AyUgYjfD57nHzry7dR6rgnsJ5Dg6Ni59mvoMhldzI5kGa9aZtecs1\n96wVihNwart7icS1vFKFOxprvd5y/JZmEo+IbhL5W+Ps06Cee/h1RQs7stDt6LZK\nnKIjMVnwCsRtiScoJ2EMLezcn2XtE/O65tjFWh3p/bxvKkhIedsBUz6uR9LvZLAe\nK/TXBTQOTB3NpsH1CSS3Nuvvvwr0RquDfsRPKLH6zUlLNEhPWtmucAbDrmpTeQL2\nMB7aQPwRqQD9YtYsQLq0O3uaWMvtE7HKu2gk4T1ySE438+nFh4jsjOY8WMm5uK0m\nnzdDIQ4Hi7bFoh1Qzqy4HaG6yynVPFmOoQ+l6O3TW+WY5BjFegB0I2nVJaMReWWE\njCUOhXdeOCSF03MfgD5rB5BdKy29a0qXnlNfXkiIjS3bNmbGrgJKDbIdMCDmPS9l\nGyc3S+uWU78sZJeA7rZDFNrBda6TTFpJTCzItso96Vlh6ucetEtal/x9pyth4tqA\n9LAD35wJwYrsOM+jtGNSPdWAum92kfEL5pbBlN+yusEwJpZYSdUsZX9bJ96+R4EL\nmDn2rcI/kntnywQ/Pq2+3qlmZi14TeWhgCtV2UbSNZri76p9OKf8Dh7hJfeaR0Vn\n66v0Stc3ZM3F+vWBadeCOFCgZp3OumxguRYx2M0VABEBAAGJA2wEGAEIACAWIQTh\nqY8mUmGJJIKzkiLzRdbA3IPZsQUCWlHxLwIbAgJACRDzRdbA3IPZscF0IAQZAQgA\nHRYhBJ483Uu642ViiiR1fDjE4nch5fkmBQJaUfEvAAoJEDjE4nch5fkmVXcP/1Dk\nHafHmZC3qV3W1kZF3Z+JfjxyKqJjCwANJA3+ttvOVpgab4W+Vi6vfvY3t9cSvgmG\nlQxeBHuo3V2+kCh6XNbcTH7Kvhh9nFKC77LiSEhwdjyk/Q1zYkljaaps9IOuzfe0\nowJMivqiVLXa+eJ8Jc2LKOrn7gRNDQketCJlI9BpLQzWBGZO7yriwhEqTqP9hdqx\n83j63oLKvvutwPS07ktWArlzC30Gt1ARsgPPr7iN7j1yki3/EP3zGcfD67Q2vvf+\n9byFXfriD0ejV9H+VOIaDeBi9tvc+8H4wO/4/4LnUTn8E9q2jYtD/4hSKKpR90no\nIgp73kjMyjhxrrSVg/44EWa+XBfHSXpeo7isglh9UE4pX1k7zBMYbIHZcYBWkjg5\nKrulQW4Wqn9W/RlfGLKpEMElcMCmyVPKyQ/rUzP1EWr8zlIwveksRmoVInUzJ/Xi\nh4Fp9tCI/ZupYhofiSHzzDCOuwYMNENAmznimt905Rt4fhZixuZmmEEm6ob/gD+U\n44mC3PJiXbG3yZKSserkRbtWkNsVq79UbS0lO5VM+wwX2PnclL5UESba/HUKiAHB\nfe4NUlEbxs5KIG9IbE+IVz0o6bvrOZdP/vAczVr904sUOFrW31kasyx1EDsyfllb\n5Z3akOBf2ACdseNg+ZQcgmzkbLpp7XHrRPw/xTq5pGwIAL/R4uuZTagSsEfswtJt\nztAg+jbRXkyxMGl8RwYOxeguHDx9+9xvrj6xeif49Miqc3gFvgc6QfTewxh4CXlM\nIIHgwzpDoK9DUNHHHssJ9zDzl/KleF+o7kcbXt5qSioHx7+6MQ3LEkVR29+9w6At\n3jY1Yf6GGAIGudpI8f9b+vZv+jkgBZD0lquRsM4mSF4QCiqbmlAZqpxelJybhhAv\ny+17w6Bs8ojo3dbkTaLLX+GNMTEVYJfAN/tY69ISrI8c6JnvqkHqe47yrmEz1mCG\nfpV1ajyTtkdSpOmEbb9+b4FjphIoP05wEJCqOz0QbG0IPgj4aplDYJ3J6SG0qLrS\n4rY=\n=K315\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_1_ALL_SUBKEYS = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nUqTphG2/fm+BY6YSKD9OcBCQqjs9EGxtCD4I+GqZQ2CdyekhtKi60uK2\n=MtsI\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_1_ALL_SUBKEYS_AND_UIDS = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\ngWOmEig/TnAQkKo7PRBsbQg+CPhqmUNgncnpIbSoutLitg==\n=NRW6\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_2_BASE = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n\nxsBNBFpSJiIBCADZS41R8dMY0ca+CJanEJVoupuGk6Qy21tcagyqBYy+2sm9pCfn\nUjZOKLXDsRfq8PRyM9FJDkQJKG6bReHEFaeDNEfja54ghRmTgx11d3aHpqLBjJHL\nLtDsCozeLWlPNhgU3frnVIbdwggamAw1Piz34l753/CYpmPg8At94GneRIaxdy0I\nhRNghiLs5w4tsbRu9Sq3aVoWB99iGHQxL125fOCZ3J0RFzRj7k1ThTPZcgn4bcVS\njPxpaMegrmkPbU7WRXtoGkneul2c9KG//GLvOKA9+U6/zoK528kQaf5ThGnMFxrr\nl5FHqkgraQdu9yFD3V3b1cTs4x6HBosaF4rtABEBAAHNH0l2YW5rYSBUcnVtcCA8\naXZhbmthQHRydW1wLmNvbT7CwJQEEwEIAD4WIQShKH1Zs1OL97qyAqC+nQuWowp/\nrgUCWlImIgIbAwUJA8JnAAULCQgHAgYVCAkKCwIEFgIDAQIeAQIXgAAKCRC+nQuW\nowp/rqdsCACdlAR6OoxJAUVIXrQ0xrE74IAycC5CoZc/E/eIGbV8U4HqnyhwfYtm\nR0VnaFLphM0/gCKJb7pBnWbZ9LKomuEieFgA04ByXStDjaD09lY37eFwZ6bi/A/w\niByBvPUrJrVX6SFLLKM6lNMLfJSAjmnts7AzqgAjaEdYHrsPVXjto0UMOO7OgxvJ\nW7zVQVysH5X+x50sh7EjjzfpeIjdTxCNsoesCPnjxaakG1LwzslfEwGBkXw/uWpZ\nguDVxQ9v+Ek9YWUD4dfYMxTxTkO6dGhfvCy/HLyixUjgnT1fCCFDCw+L7kw3TMLO\nklI1WkdVbfTkDbmjZt0bvT6lQW6YGFdszsBNBFpSJiIBCADIsNCOFpLefi9waFo9\nXgXFdjU9kHV+Y+g+0No7R56+YcX4NGKY3FPnWuRtzFXuQX4yCh1DCJoQcnclS6LZ\nwCAoTT/7+Rrep4o9mFPxxT6SO4xK3Ago5IMISop7r6uq3InJ/sDmLgJUcpRqSmeq\nnfgCJJrhj/VgbrJyMSSyK+6jaKJHeVuVD6C30xrmTeZQjN8JKN/JoqgmHnsAvH63\nG9UqXVW3dtngoeZvxa6qZPolyzGbKwyOYEe36dFa2Einebu3iG4FuvwMUyNrxQ50\nYaeSripS0od4NMq8OQIKhvMUoYJFTnsseSdE1CSVbzNBguQd2n5stbGDXO/BPFJ8\nXQzVABEBAAHCwHYEGAEIACAWIQShKH1Zs1OL97qyAqC+nQuWowp/rgUCWlImIgIb\nDAAKCRC+nQuWowp/rhIbB/9/h4YWjpRR9l6orco7HkexiYuHO4orqEDXuVK5LXkE\nx/AuaGZi4IRIzCIcNFJD3NTUmqwgfLy29YNkrv4IZn+vt7o2K3vZIxA9bkQYscBR\nWnihkmrfcFp4pkvNoaBOIRPozvQy7ZFiwJ7mQEIdkvi9KJ5ksKNpWDwpXR97a7zH\nEEXVg+uB55t46CdnrAkJfm2rmbZiIenYzcoLL5sN22k500uO4sX7zEfVIZNuqzn2\ngr9IceWgvC58aIbxdKAJYvarVItd1TL6NZZ/fDsxOoKjGDlJ3vyZkG00DTWrqJ99\nXLmJusGySa8wZhjGqGze6EYiLQuLaMdJxao3B035CGMn\n=SEdr\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_2_SIGNS_CERT_1_BASE = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nt6uwi3FEYQgT\n=BVz1\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String CERT_2_SIGNS_CERT_1_ALL_USER_IDS = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\n=e/pf\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_3_SIGNS_CERT_1_BASE = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\nt6uwi3FEYQgT\n=KJlw\n-----END PGP PUBLIC KEY BLOCK-----\n";
    private static final String CERT_3_SIGNS_CERT_1_ALL_USER_IDS = "-----BEGIN PGP PUBLIC KEY BLOCK-----\n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\n=UeHX\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final int firstUserIdSelfSigs = 1;
    private static final int secondUserIdSelfSigs = 2;
    private static final int thirdUserIdSelfSigs = 1;

    public void cannotMergeDifferentCerts() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_2_BASE);
        try {
            PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        this.fail("Cannot merge two different certificates");
    }

    private int count(Iterator iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    public void duplicateUserIdIsMergedWhenReadingCert() throws IOException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_ALL_UIDS);
        this.isEquals(3, this.count(pGPPublicKeyRing.getPublicKey().getUserIDs()));
        Iterator iterator = pGPPublicKeyRing.getPublicKey().getUserIDs();
        this.isEquals("first user-id self-sig count; 1", 1L, this.count(pGPPublicKeyRing.getPublicKey().getSignaturesForID((String)iterator.next())));
        this.isEquals("second user-id self-sig count: 2", 2L, this.count(pGPPublicKeyRing.getPublicKey().getSignaturesForID((String)iterator.next())));
        this.isEquals("third user-id self-sig count: 1", 1L, this.count(pGPPublicKeyRing.getPublicKey().getSignaturesForID((String)iterator.next())));
    }

    public String getName() {
        return "PGPPublicKeyMergeTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPPublicKeyMergeTest());
    }

    public void mergeAddSubkey1WithBaseYieldsSubkey1() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_1_ADD_SUBKEY_1);
        PGPPublicKeyRing pGPPublicKeyRing3 = PGPPublicKeyRing.join(pGPPublicKeyRing2, pGPPublicKeyRing);
        this.areEqual(pGPPublicKeyRing2.getEncoded(), pGPPublicKeyRing3.getEncoded());
    }

    public void mergeAddUserId1WithBaseYieldsUserId1() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_1_ADD_UID_1);
        PGPPublicKeyRing pGPPublicKeyRing3 = PGPPublicKeyRing.join(pGPPublicKeyRing2, pGPPublicKeyRing);
        this.areEqual(pGPPublicKeyRing2.getEncoded(), pGPPublicKeyRing3.getEncoded());
    }

    public void mergeAllCert2AndCert3Certifications() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_2_SIGNS_CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_2_SIGNS_CERT_1_ALL_USER_IDS);
        PGPPublicKeyRing pGPPublicKeyRing3 = this.readCert(CERT_3_SIGNS_CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing4 = this.readCert(CERT_3_SIGNS_CERT_1_ALL_USER_IDS);
        PGPPublicKeyRing pGPPublicKeyRing5 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        PGPPublicKeyRing pGPPublicKeyRing6 = PGPPublicKeyRing.join(pGPPublicKeyRing5, pGPPublicKeyRing4);
        PGPPublicKeyRing pGPPublicKeyRing7 = PGPPublicKeyRing.join(pGPPublicKeyRing6, pGPPublicKeyRing3);
        Iterator iterator = pGPPublicKeyRing7.getPublicKey().getUserIDs();
        this.isEquals("there should be two certifications from each cert on the first UID", 4L, this.count(pGPPublicKeyRing7.getPublicKey().getSignaturesForID((String)iterator.next())) - 1);
        this.isEquals("there should be one certification from each cert on the second UID", 2L, this.count(pGPPublicKeyRing7.getPublicKey().getSignaturesForID((String)iterator.next())) - 2);
        this.isEquals("there should be one certification from each cert on the third UID", 2L, this.count(pGPPublicKeyRing7.getPublicKey().getSignaturesForID((String)iterator.next())) - 1);
    }

    public void mergeAllSubkeysAndUserIdsYieldsAllSubkeysUserIds() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_1_ADD_UID_1);
        PGPPublicKeyRing pGPPublicKeyRing3 = this.readCert(CERT_1_ADD_UID_2);
        PGPPublicKeyRing pGPPublicKeyRing4 = this.readCert(CERT_1_ADD_UID_3);
        PGPPublicKeyRing pGPPublicKeyRing5 = this.readCert(CERT_1_ADD_SUBKEY_1);
        PGPPublicKeyRing pGPPublicKeyRing6 = this.readCert(CERT_1_ADD_SUBKEY_2);
        PGPPublicKeyRing pGPPublicKeyRing7 = this.readCert(CERT_1_ADD_SUBKEY_3);
        PGPPublicKeyRing pGPPublicKeyRing8 = this.readCert(CERT_1_ALL_SUBKEYS_AND_UIDS);
        PGPPublicKeyRing pGPPublicKeyRing9 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing5);
        PGPPublicKeyRing pGPPublicKeyRing10 = PGPPublicKeyRing.join(pGPPublicKeyRing9, pGPPublicKeyRing2);
        PGPPublicKeyRing pGPPublicKeyRing11 = PGPPublicKeyRing.join(pGPPublicKeyRing10, pGPPublicKeyRing7);
        PGPPublicKeyRing pGPPublicKeyRing12 = PGPPublicKeyRing.join(pGPPublicKeyRing11, pGPPublicKeyRing6);
        PGPPublicKeyRing pGPPublicKeyRing13 = PGPPublicKeyRing.join(pGPPublicKeyRing12, pGPPublicKeyRing4);
        PGPPublicKeyRing pGPPublicKeyRing14 = PGPPublicKeyRing.join(pGPPublicKeyRing13, pGPPublicKeyRing3);
        this.areEqual(pGPPublicKeyRing8.getEncoded(), pGPPublicKeyRing14.getEncoded());
    }

    public void mergeAllSubkeysInOrderYieldsAllSubkeys() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_1_ADD_SUBKEY_1);
        PGPPublicKeyRing pGPPublicKeyRing3 = this.readCert(CERT_1_ADD_SUBKEY_2);
        PGPPublicKeyRing pGPPublicKeyRing4 = this.readCert(CERT_1_ADD_SUBKEY_3);
        PGPPublicKeyRing pGPPublicKeyRing5 = this.readCert(CERT_1_ALL_SUBKEYS);
        PGPPublicKeyRing pGPPublicKeyRing6 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        PGPPublicKeyRing pGPPublicKeyRing7 = PGPPublicKeyRing.join(pGPPublicKeyRing6, pGPPublicKeyRing3);
        PGPPublicKeyRing pGPPublicKeyRing8 = PGPPublicKeyRing.join(pGPPublicKeyRing7, pGPPublicKeyRing4);
        this.areEqual(pGPPublicKeyRing5.getEncoded(), pGPPublicKeyRing8.getEncoded());
    }

    public void mergeAllSubkeysInReverseYieldsAllSubkeys() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_1_ADD_SUBKEY_1);
        PGPPublicKeyRing pGPPublicKeyRing3 = this.readCert(CERT_1_ADD_SUBKEY_2);
        PGPPublicKeyRing pGPPublicKeyRing4 = this.readCert(CERT_1_ADD_SUBKEY_3);
        PGPPublicKeyRing pGPPublicKeyRing5 = this.readCert(CERT_1_ALL_SUBKEYS);
        PGPPublicKeyRing pGPPublicKeyRing6 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing4);
        PGPPublicKeyRing pGPPublicKeyRing7 = PGPPublicKeyRing.join(pGPPublicKeyRing6, pGPPublicKeyRing3);
        PGPPublicKeyRing pGPPublicKeyRing8 = PGPPublicKeyRing.join(pGPPublicKeyRing7, pGPPublicKeyRing2);
        this.areEqual(pGPPublicKeyRing5.getEncoded(), pGPPublicKeyRing8.getEncoded());
    }

    public void mergeAllSubkeysWithAllUserIdsYieldsAllSubkeysAndUserIds() throws PGPException, IOException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_ALL_SUBKEYS);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_1_ALL_UIDS);
        PGPPublicKeyRing pGPPublicKeyRing3 = this.readCert(CERT_1_ALL_SUBKEYS_AND_UIDS);
        PGPPublicKeyRing pGPPublicKeyRing4 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        this.areEqual(pGPPublicKeyRing3.getEncoded(), pGPPublicKeyRing4.getEncoded());
        pGPPublicKeyRing4 = PGPPublicKeyRing.join(pGPPublicKeyRing2, pGPPublicKeyRing);
        this.areEqual(pGPPublicKeyRing3.getEncoded(), pGPPublicKeyRing4.getEncoded());
    }

    public void mergeAllUserIdsInOrderYieldsAllUserIds() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_1_ADD_UID_1);
        PGPPublicKeyRing pGPPublicKeyRing3 = this.readCert(CERT_1_ADD_UID_2);
        PGPPublicKeyRing pGPPublicKeyRing4 = this.readCert(CERT_1_ADD_UID_3);
        PGPPublicKeyRing pGPPublicKeyRing5 = this.readCert(CERT_1_ALL_UIDS);
        PGPPublicKeyRing pGPPublicKeyRing6 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        PGPPublicKeyRing pGPPublicKeyRing7 = PGPPublicKeyRing.join(pGPPublicKeyRing6, pGPPublicKeyRing3);
        PGPPublicKeyRing pGPPublicKeyRing8 = PGPPublicKeyRing.join(pGPPublicKeyRing7, pGPPublicKeyRing4);
        this.areEqual(pGPPublicKeyRing5.getEncoded(), pGPPublicKeyRing8.getEncoded());
    }

    public void mergeAllUserIdsInReverseYieldsAllUserIds() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_1_ADD_UID_1);
        PGPPublicKeyRing pGPPublicKeyRing3 = this.readCert(CERT_1_ADD_UID_2);
        PGPPublicKeyRing pGPPublicKeyRing4 = this.readCert(CERT_1_ADD_UID_3);
        PGPPublicKeyRing pGPPublicKeyRing5 = this.readCert(CERT_1_ALL_UIDS);
        PGPPublicKeyRing pGPPublicKeyRing6 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing4);
        PGPPublicKeyRing pGPPublicKeyRing7 = PGPPublicKeyRing.join(pGPPublicKeyRing6, pGPPublicKeyRing3);
        PGPPublicKeyRing pGPPublicKeyRing8 = PGPPublicKeyRing.join(pGPPublicKeyRing7, pGPPublicKeyRing2);
        this.areEqual(pGPPublicKeyRing5.getEncoded(), pGPPublicKeyRing8.getEncoded());
    }

    public void mergeBaseWithItselfDoesNotChangeCert() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing3 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        this.areEqual(pGPPublicKeyRing.getEncoded(), pGPPublicKeyRing3.getEncoded());
    }

    public void mergeCert2SignsAllUserIdsWithBaseYieldsCert2SignsAllUserIds() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_2_SIGNS_CERT_1_ALL_USER_IDS);
        PGPPublicKeyRing pGPPublicKeyRing3 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        this.areEqual(pGPPublicKeyRing2.getEncoded(), pGPPublicKeyRing3.getEncoded());
    }

    public void mergeCert2SignsBaseWithBaseYieldsCert2SignsBase() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_2_SIGNS_CERT_1_BASE);
        this.isEquals("base has 1 user-id", 1L, this.count(pGPPublicKeyRing.getPublicKey().getUserIDs()));
        String string = (String)pGPPublicKeyRing.getPublicKey().getUserIDs().next();
        this.isEquals("base has 1 signature on user-id", 1L, this.count(pGPPublicKeyRing.getPublicKey().getSignaturesForID(string)));
        this.isEquals("signed cert has 1 user-id", 1L, this.count(pGPPublicKeyRing2.getPublicKey().getUserIDs()));
        this.isEquals("signed cert has 1 self-sig and 1 certification", 2L, this.count(pGPPublicKeyRing2.getPublicKey().getSignaturesForID(string)));
        PGPPublicKeyRing pGPPublicKeyRing3 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        this.areEqual(pGPPublicKeyRing2.getEncoded(), pGPPublicKeyRing3.getEncoded());
    }

    public void mergeCert2SignsBaseWithCert3SignsBase() throws PGPException, IOException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_2_SIGNS_CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_3_SIGNS_CERT_1_BASE);
        this.isEquals(1, this.count(pGPPublicKeyRing.getPublicKey().getUserIDs()));
        this.isEquals(1, this.count(pGPPublicKeyRing2.getPublicKey().getUserIDs()));
        String string = (String)pGPPublicKeyRing.getPublicKey().getUserIDs().next();
        this.isEquals(2, this.count(pGPPublicKeyRing.getPublicKey().getSignaturesForID(string)));
        this.isEquals(2, this.count(pGPPublicKeyRing2.getPublicKey().getSignaturesForID(string)));
        PGPPublicKeyRing pGPPublicKeyRing3 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        this.isEquals("There should now be one signature from each cert on the first user-id", 2L, this.count(pGPPublicKeyRing3.getPublicKey().getSignaturesForID(string)) - 1);
    }

    public void mergeCert3SignsAllUserIdsWithBaseYieldsCert3SignsAllUserIds() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_3_SIGNS_CERT_1_ALL_USER_IDS);
        PGPPublicKeyRing pGPPublicKeyRing3 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        this.areEqual(pGPPublicKeyRing2.getEncoded(), pGPPublicKeyRing3.getEncoded());
    }

    public void mergeCert3SignsBaseWithBaseYieldsCert3SignsBase() throws IOException, PGPException {
        PGPPublicKeyRing pGPPublicKeyRing = this.readCert(CERT_1_BASE);
        PGPPublicKeyRing pGPPublicKeyRing2 = this.readCert(CERT_3_SIGNS_CERT_1_BASE);
        this.isEquals("base has 1 user-id", 1L, this.count(pGPPublicKeyRing.getPublicKey().getUserIDs()));
        String string = (String)pGPPublicKeyRing.getPublicKey().getUserIDs().next();
        this.isEquals("base has 1 signature on user-id", 1L, this.count(pGPPublicKeyRing.getPublicKey().getSignaturesForID(string)));
        this.isEquals("signed cert has 1 user-id", 1L, this.count(pGPPublicKeyRing2.getPublicKey().getUserIDs()));
        this.isEquals("signed cert has 1 self-sig and 1 certifications", 2L, this.count(pGPPublicKeyRing2.getPublicKey().getSignaturesForID(string)));
        PGPPublicKeyRing pGPPublicKeyRing3 = PGPPublicKeyRing.join(pGPPublicKeyRing, pGPPublicKeyRing2);
        this.areEqual(pGPPublicKeyRing2.getEncoded(), pGPPublicKeyRing3.getEncoded());
    }

    public void performTest() throws Exception {
        this.cannotMergeDifferentCerts();
        this.duplicateUserIdIsMergedWhenReadingCert();
        this.mergeBaseWithItselfDoesNotChangeCert();
        this.mergeAllUserIdsInOrderYieldsAllUserIds();
        this.mergeAllUserIdsInReverseYieldsAllUserIds();
        this.mergeAddUserId1WithBaseYieldsUserId1();
        this.mergeAllSubkeysInOrderYieldsAllSubkeys();
        this.mergeAllSubkeysInReverseYieldsAllSubkeys();
        this.mergeAddSubkey1WithBaseYieldsSubkey1();
        this.mergeAllSubkeysAndUserIdsYieldsAllSubkeysUserIds();
        this.mergeAllSubkeysWithAllUserIdsYieldsAllSubkeysAndUserIds();
        this.mergeCert2SignsBaseWithBaseYieldsCert2SignsBase();
        this.mergeCert2SignsAllUserIdsWithBaseYieldsCert2SignsAllUserIds();
        this.mergeCert3SignsBaseWithBaseYieldsCert3SignsBase();
        this.mergeCert3SignsAllUserIdsWithBaseYieldsCert3SignsAllUserIds();
        this.mergeCert2SignsBaseWithCert3SignsBase();
        this.mergeAllCert2AndCert3Certifications();
    }

    private PGPPublicKeyRing readCert(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Strings.toByteArray((String)string));
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream);
        return new PGPPublicKeyRing(armoredInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }
}

