/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.Iterator;
import javax.crypto.Cipher;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVectorGenerator;
import org.bouncycastle.openpgp.PGPV3SignatureGenerator;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.jcajce.JcaPGPPublicKeyRing;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.UncloseableOutputStream;

public class PGPRSATest
extends SimpleTest {
    byte[] testPubKey = Base64.decode((String)"mIsEPz2nJAEEAOTVqWMvqYE693qTgzKv/TJpIj3hI8LlYPC6m1dk0z3bDLwVVk9FFAB+CWS8RdFOWt/FG3tEv2nzcoNdRvjv9WALyIGNawtae4Ml6oAT06/511yUzXHOk+9xK3wkXN5jdzUhf4cA2oGpLSV/pZlocsIDL+jCUQtumUPwFodmSHhzAAYptC9FcmljIEVjaGlkbmEgKHRlc3Qga2V5KSA8ZXJpY0Bib3VuY3ljYXN0bGUub3JnPoi4BBMBAgAiBQI/PackAhsDBQkAg9YABAsHAwIDFQIDAxYCAQIeAQIXgAAKCRA1WGFG/fPzc8WMA/9BbjuB8E48QAlxoiVf9U8SfNelrz/ONJA/bMvWr/JnOGA9PPmFD5Uc+kV/q+i94dEMjsC5CQ1moUHWSP2xlQhbOzBP2+oPXw3z2fBs9XJgnTH6QWMAAvLs3ug9po0loNHLobT/D/XdXvcrb3wvwvPT2FptZqrtonH/OdzT9JdfrA==");
    byte[] testPrivKey = Base64.decode((String)"lQH8BD89pyQBBADk1aljL6mBOvd6k4Myr/0yaSI94SPC5WDwuptXZNM92wy8FVZPRRQAfglkvEXRTlrfxRt7RL9p83KDXUb47/VgC8iBjWsLWnuDJeqAE9Ov+ddclM1xzpPvcSt8JFzeY3c1IX+HANqBqS0lf6WZaHLCAy/owlELbplD8BaHZkh4cwAGKf4DAwKbLeIOVYTEdWD5v/YgW8ERs0pDsSIfBTvsJp2qA798KeFuED6jGsHUzdi1M9906PRtplQgnoYmYQrzEc6DXAiAtBR4Kuxi4XHx0ZR2wpVlVxm2Ypgz7pbBNWcWqzvw33inl7tR4IDsRdJOY8cFlN+1tSCf16sDidtKXUVjRjZNYJytH18VfSPlGXMeYgtw3cSGNTERwKaq5E/SozT2MKTiORO0g0Mtyz+9MEB6XVXFavMun/mXURqbZN/k9BFbz+TadpkihrLD1xw3Hp+tpe4CwPQ2GdWKI9KNo5gEnbkJgLrSMGgWalPhknlNHRyYbSq6lbIMJEE3LoOwvYWwweR1+GrV9farJESdunl1mDr5/d6rKru+FFDwZM3na1IF4Ei4FpqhivZ4zG6pN5XqLy+AK85EiW4XH0yAKX1O4YlbmDU4BjxhiwTdwuVMCjLO5++jkz5BBQWdFX8CCMA4FJl36G70IbGzuFfOj07ly7QvRXJpYyBFY2hpZG5hICh0ZXN0IGtleSkgPGVyaWNAYm91bmN5Y2FzdGxlLm9yZz6IuAQTAQIAIgUCPz2nJAIbAwUJAIPWAAQLBwMCAxUCAwMWAgECHgECF4AACgkQNVhhRv3z83PFjAP/QW47gfBOPEAJcaIlX/VPEnzXpa8/zjSQP2zL1q/yZzhgPTz5hQ+VHPpFf6voveHRDI7AuQkNZqFB1kj9sZUIWzswT9vqD18N89nwbPVyYJ0x+kFjAALy7N7oPaaNJaDRy6G0/w/13V73K298L8Lz09habWaq7aJx/znc0/SXX6w=");
    byte[] testPubKeyV3 = Base64.decode((String)"mQCNAz+zvlEAAAEEAMS22jgXbOZ/D3xWgM2kauSdzrwlU7Ms5hDW05ObqQyOFfQoKKMhfupyoa7J3x04VVBKu6Eomvr1es+VImH0esoeWFFahNOYq/I+jRRBwoOhAGZ5UB2/hRd7rFmxqp6sCXi8wmLO2tAorlTzAiNNvl7xF4cQZpc0z56Fwdi2fBUJAAURtApGSVhDSVRZX1FBiQCVAwUQP7O+UZ6Fwdi2fBUJAQFMwwQAqRnFsdg4xQnB8Y5d4cOpXkIn9AZgYS3cxtuSJB84vG2CgC39nfv4c+nlLkWP4puG+mZuJNgVoE84cuAF4I//1anKjlU7q1M6rFQnt5S4uxPyG3dFXmgyU1b4PBOnA0tIxjPzlIhJAMsPCGGA5+5M2JP0ad6RnzqzE3EENMX+GqY=");
    byte[] testPrivKeyV3 = Base64.decode((String)"lQHfAz+zvlEAAAEEAMS22jgXbOZ/D3xWgM2kauSdzrwlU7Ms5hDW05ObqQyOFfQoKKMhfupyoa7J3x04VVBKu6Eomvr1es+VImH0esoeWFFahNOYq/I+jRRBwoOhAGZ5UB2/hRd7rFmxqp6sCXi8wmLO2tAorlTzAiNNvl7xF4cQZpc0z56Fwdi2fBUJAAURAXWwRBZQHNikA/f0ScLLjrXi4s0hgQecg+dkpDow94eu5+AR0DzZnfurpgfUJCNiDi5W/5c3Zj/xyrfMAgkbCgJ1m6FZqAQh7Mq73l7Kfu4/XIkyDF3tDgRuZNezB+JuElX10tV03xumHepp6M6CfhXqNJ15F33F99TA5hXYCPYD7SiSOpIhQkCOAgDAA63imxbpuKE2W7Y4I1BUHB7WQi8ZdkZd04njNTv+rFUuOPapQVfbWG0Vq8ld3YmJB4QWsa2mmqn+qToXbwufAgBpXkjvqK5yPiHFPx2QbFc1VqoCJB6PO5JRIqEiUZBFGdDlLxt3VSyqz7IZ/zEnxZq+tPCGGGSm/sAGiMvENcHVAfy0kTXU42TxEAYJyyNyqjXOobDJpEV1mKhFskRXt7tbMfOSYf91oX8f6xw6O2Nal+hU8dS0Bmfmk5/enHmvRLHQocO0CkZJWENJVFlfUUE=");
    byte[] sig1 = Base64.decode((String)"owGbwMvMwMRoGpHo9vfz52LGNTJJnBmpOTn5eiUVJfb23JvAHIXy/KKcFEWuToapzKwMIGG4Bqav0SwMy3yParsEKi2LMGI9xhh65sBxb05n5++ZLcWNJ/eLFKdWbm95tHbDV7GMwj/tUctUpFUXWPYFCLdNsDiVNuXbQvZtdXV/5xzY+9w1nCnijH9JoNiJ22n2jo0zo30/TZLo+jDl2vTzIvPeLEsPM3ZUE/1Ytqs4SG2TxIQbH7xf3uzcYXq25Fw9AA==");
    byte[] sig1crc = Base64.decode((String)"+3i0");
    byte[] subKey = Base64.decode((String)"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");
    byte[] enc1 = Base64.decode((String)"hIwDKwfQexPJboABA/4/7prhYYMORTiQ5avQKx0XYpCLujzGefYjnyuWZnx3Iev8Pmsguumm+OLLvtXhhkXQmkJRXbIg6Otj2ubPYWflRPgpJSgOrNOreOl5jeABOrtwbV6TJb9OTtZuB7cTQSCq2gmYiSZkluIiDjNs3R3mEanILbYzOQ3zKSggKpzlv9JQAZUqTyDyJ6/OUbJF5fI5uiv76DCsw1zyMWotUIu5/X01q+AVP5Ly3STzI7xkWg/JAPz4zUHism7kSYz2viAQaJx9/bNnH3AM6qm1Fuyikl4=");
    byte[] enc1crc = Base64.decode((String)"lv4o");
    byte[] enc2 = Base64.decode((String)"hIwDKwfQexPJboABBAC62jcJH8xKnKb1neDVmiovYON04+7VQ2v4BmeHwJrdag1gYa++6PeBlQ2Q9lSGBwLobVuJmQ7cOnPUJP727JeSGWlMyFtMbBSHekOaTenT5lj7Zk7oRHxMp/hByzlMacIDzOn8LPSh515RHM57eDLCOwqnAxGQwk67GRl8f5dFH9JQAa7xx8rjCqPbiIQW6t5LqCNvPZOiSCmftll6+se1XJhFEuq8WS4nXtPfTiJ3vib43soJdHzGB6AOs+BQ6aKmmNTVAxa5owhtSt1Z/6dfSSk=");
    byte[] subPubKey = Base64.decode((String)"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");
    byte[] subPubCrc = Base64.decode((String)"rikt");
    byte[] pgp8Key = Base64.decode((String)"lQIEBEBXUNMBBADScQczBibewnbCzCswc/9ut8R0fwlltBRxMW0NMdKJY2LF7k2COeLOCIU95loJGV6ulbpDCXEO2Jyq8/qGw1qD3SCZNXxKs3GS8Iyh9UwdVL07nMMYl5NiQRsFB7wOb86+94tYWgvikVA5BRP5y3+O3GItnXnpWSJyREUy6WI2QQAGKf4JAwIVmnRs4jtTX2DD05zy2mepEQ8bsqVAKIx7lEwvMVNcvg4Y8vFLh9Mf/uNciwL4Se/ehfKQ/AT0JmBZduYMqRU2zhiBmxj4cXUQ0s36ysj7fyDngGocDnM3cwPxaTF1ZRBQHSLewP7dqE7M73usFSz8vwD/0xNOHFRLKbsORqDlLA1Cg2Yd0wWPS0o7+qqk9ndqrjjSwMM8ftnzFGjShAdg4Ca7fFkcNePP/rrwIH472FuRb7RbWzwXA4+4ZBdl8D4An0dwtfvAO+jCZSrLjmSpxEOveJxYGduyR4IA4lemvAG51YHTHd4NXheuEqsIkn1yarwaaj47lFPnxNOElOREMdZbnkWQb1jfgqO24imEZgrLMkK9bJfoDnlF4k6r6hZOp5FSFvc5kJB4cVo1QJl4pwCSdoU6luwCggrlZhDnkGCSuQUUW45NE7Br22NGqn4/gHs0KCsWbAezApGjqYUCfX1bcpPzUMzUlBaD5rz2vPeO58CDtBJ0ZXN0ZXIgPHRlc3RAdGVzdD6IsgQTAQIAHAUCQFdQ0wIbAwQLBwMCAxUCAwMWAgECHgECF4AACgkQs8JyyQfH97I1QgP8Cd+35maM2cbWV9iVRO+c5456KDi3oIUSNdPf1NQrCAtJqEUhmMStQbdiaFEkPrORISI/2htXruYn0aIpkCfbUheHOu0sef7s6pHmI2kOQPzR+C/j8D9QvWsPOOso81KU2axUY8zIer64Uzqc4szMIlLw06c8vea27RfgjBpSCrywAgAA");
    char[] pgp8Pass = "2002 Buffalo Sabres".toCharArray();
    char[] pass = new char[]{'h', 'e', 'l', 'l', 'o', ' ', 'w', 'o', 'r', 'l', 'd'};
    byte[] fingerprintKey = Base64.decode((String)"mQEPA0CiJdUAAAEIAMI+znDlPd2kQoEcnxqxLcRz56Z7ttFKHpnYp0UkljZdquVcBy1jMfXGVV64xN1IvMcyenLXUE0IUeUBCQs6tHunFRAPSeCxJ3FdFe1B5MpqQG8ABnEpAds/hAUfRDZD5y/lolk1hjvFMrRh6WXckaA/QQ2t00NmTrJ1pYUpkw9tnVQbLUjWJhfZDBBcN0ADtATzgkugxMtcDxR6I5x8Ndn+IilqIm23kxGIcmMd/BHOec4cjRwJXXDb7u8tl+2knAf9cwhPHp3+Zy4uGSQPdzQnXOhBlA+4WDa0RROOevWgq8uq8/9Xp/OlTVL+OoIzjsI6mJP1Joa4qmqAnaHAmXcAEQEAAbQoQk9BM1JTS1kgPEJPQSBNb25pdG9yaW5nIEAgODg4LTI2OS01MjY2PokBFQMFEECiJdWqaoCdocCZdwEB0RsH/3HPxoUZ3G3K7T3jgOnJUckTSHWU3XspHzMVgqOxjTrcexi5IsAM5M+BulfWT2aO+Kqf5w8cKTKgW02DNpHUiPjHx0nzDE+Do95zbIErGeK+Twkc4O/aVsvU9GGO81VFI6WMvDQ4CUAUnAdk03MRrzI2nAuhn4NJ5LQS+uJrnqUJ4HmFAz6CQZQKd/kSXgq+A6i7aI1LG80YxWa9ooQgaCrb9dwY/kPQ+yC22zQ3FExtv+Fv3VtAKTilO3vnBA4Y9uTHuObHfI+1yxUS2PrlRUX0m48ZjpIX+cEN3QblGBJudI/A1QSd6P0LZeBr7F1Z1aF7ZDo0KzgiAIBvgXkeTpw=");
    byte[] fingerprintCheck = Base64.decode((String)"CTv2");
    byte[] expiry60and30daysSig13Key = Base64.decode((String)"mQGiBENZt/URBAC5JccXiwe4g6MuviEC8NI/x0NaVkGFAOY04d5E4jeIycBPSrpOPrjETuigqhrj8oqed2+2yUqfnK4nhTsTAjyeJ3PpWC1pGAKzJgYmJk+K9aTLq0BQWiXDdv5RG6fDmeq1umvOfcXBqGFAguLPZC+U872bSLnfe3lqGNA8jvmY7wCgjhzVQVm10NN5ST8nemPEcSjnBrED/R494gHL6+r5OgUgXnNCDejA4InoDImQCF+g7epp5E1MB6CMYSg2WSY2jHFuHpwnUb7AiOO0ZZ3UBqM9rYnKkDvxkFCxba7Ms+aFj9blRNmy3vG4FewDcTdxzCtjUk6dRfu6UoARpqlTE/q7Xo6EQP1ncwJ+UTlcHkTBvg/usI/yBACGjBqX8glb5VfNaZgNHMeS/UIiUiuVSVFojiSDOHcnCe/6y4M2gVm38zz1W9qhoLfLpiAOFeL0yj6wzXvsjjXQiKQ8nBE4Mf+oeH2qiQ/LfzQrGpI5eNcMXrzK9nigmz2htYO2GjQfupEnu1RHBTH8NjofD2AShL9IO73plRuExrQgVGVzdCBLZXkgPHRlc3RAYm91bmN5Y2FzdGxlLm9yZz6IZAQTEQIAJAIbAwYLCQgHAwIDFQIDAxYCAQIeAQIXgAUCQ1m4DgUJAE8aGQAKCRD8QP1QuU7Kqw+eAJ0dZ3ZAqr73X61VmCkbyPoszLQMAQCfdFs2YMDeUvX34Q/8Ba0KgO5f3RSwAgADuM0EQ1m39hADAIHpVGcLqS9UkmQaWBvHWP6TnN7Y1Ha0TJOuxpbFjBW+CmVh/FjcsnavFXDXpo2zc742WT+vrHBSa/0D1QEBsnCaX5SRRVp7Mqs8q+aDhjcHMIP8Sdxf7GozXDORkrRaJwADBQL9HLYm7Rr5iYWDcvs+Pi6O1zUyb1tjkxEGaV/rcozl2MMmr2mzJ6x/Bz8SuhZEJS0mbB2CvAA39aQi9jHlV7q0SV73NOkd2L/Vt2UZhzlUdvrJ37PgYDv+Wd9Ufz6gMzLSiE8EGBECAA8FAkNZt/YCGwwFCQAnjQAACgkQ/ED9ULlOyqsTqQCcDnAZ7YymCfhm1yJiuFQg3qiX6Z4An19OSEgeSKugVcH49g1sxUB0zNdIsAIAAw==");
    byte[] jpegImage = Base64.decode((String)"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");
    byte[] embeddedJPEGKey = Base64.decode((String)"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");
    private static byte[] shortSigKey = Base64.decode((String)"mQENBF2vCuYBCADGzvo6ngqBAI4TFMuE69jwhD/H0CvNOq7dSxyamq7blMJgztue\nGZaKReMW018JjQ1KPzU/7HzUv6BDhzmePhDW5p8BYR/6R6GjapWhGHM8+oadbjSo\ndTsuKpd9SEx+HDXgPrXDzykRpwJxla7obqYDEQNJkbk2waBm3//q/0OKNAUwf9QE\nFUt/TaqwsQ7Wg6cAbu5WpdcET5Hzo4/E8yxLOlqzU8ZJsekJIBnTHtHj2jdHKrrI\n67f/TXIQucWKGD4PxKUPkIiKdsPxaS7ow+iNfVC+tJjM1IC4uek8TAKF/P5ds4u8\nHl8cwHGnxbI4Rm5ASDZz6d1xrdmLTR0iUfGDABEBAAG0L0p1c3RpbiBMZWRlcmVy\nIDxqdXN0aW4ubGVkZXJlckBoZWxwc3lzdGVtcy5jb20+iQEqBBMBCgAUBQJdrwrm\nBAsHCAkEFQgJCgMWAQIACgkQbvSsdk7KXyD0vQf/V5+/fRCjRgoT26xxkaRmn5FP\nT4YYB1saIYE7YRRlffWE644dIsND7GShnQhTBI2sw/6dPIBbtNeWEKUU8giReuz3\nxq5yEl7LYUwK0xZEbocBhRMhS+kz6GJz6MHL8ZKbWFCk4vfacjyRtl7VN5UVvPw8\nunyVMhGJXoTB1a2ZglDyl5MjMrRDQJr0t6yDk0xxOW4GYwEb7nHbHs6YJ9TfMr46\n0Hu+Rk3omc0eGTKxWst29uC8y0QI6qWL8zms1tyZkfAIjEhnrAow+nQPMMnxWLkQ\nodorzkSHf7vcYxUc9YyLiGi1m0KVyv9RSKy2alCdingatc6psU06m8aIX5/mb7kB\nDQRdrwrmAQgApyyCBD5QyzzQXDB5hc6BcgKM1FfxOCUQjF1wDImC2j3dTnZrzcxx\nd7OdDyQe8I9rnI/EyA2PVcTwir8oWVMBihRjJX6I775IqoO8Gcq1FW3KSLlwpxMI\nDgORxsHQ28LR+BPDn2zP0d2JkhP1no8X4BSiRSNamYmdteYnB8Hchz1DME+u6y9H\nScy5hd+6AJBpNmlFwC30pRWZBAPpOMh+YxTunCgNsh79TftuSs3rPl15FjK91yDu\ns86jmBItf2CzS7TqWpi1gU1sx0dB/T1amlN9AMn5bx9zTCeJrPh4hNW/nt2WA2CB\nXmcMeCcG0kT/o0mVq43UQ3NVfO1tnyf2TwARAQABiQEqBBgBCgAUBQJdrwrmBAsH\nCAkEFQgJCgMWAQIACgkQbvSsdk7KXyBsGgf9GQKqobdIBlBTno2wVyS5FnlS34CK\nj/dXn4wsuUmZXdtVMYhSWl37MEE8vk3eRDJn4VWObKdmJj4627ZJRSFzZC687XGb\nwprC+3Yh/FUGiA3mg18gOZx4lZSMp+N0/0R4ojHzKu0AcDvmArEZ2QNBBW3riJvh\n9X7Rws+C1n2Ka267incRfMhpVeqHSkkUwnRbA2wstOy5uA1s+rN45psfPAQ3Jt4u\n+YYexDYMHrd/1ucToS7AmnzFFtMrCGGdC1ZtfQ3gJVryHa7y/jk3ASFMD9CLe8Jo\nScQCQ1aH6+oETs8lAQhAtIh5H9nuVYIQhe1WmptMUb+j9z660wWI9OckoQ==\n");
    private static byte[] shortSig = Base64.decode((String)"owGbwMvMwMSY92VNmd+peAXG08pJgiWpFSUKKfnJpbmpeSV6JRUlscutTmckImAnow8LAyMTgzkrU+xmZwEDGa/S4pLMPAWf1JTUotQiBZssMF8vB8J3yEjNKSiuLC5JzS3WS87PtWPg4hSA2bgknv3Hy8z804b8d4vvNiukHV13d/4e1QVvTN20N/NrnJO7+tJrd8/j3S7ntSvXcD+PuM5/q8+ZSe3hitJNDEsC0niDNSfdUvrWaf34DUfNPiGe29kW9Uc3ym69IapT97DjmPj13Xfnq5tZTGqS0Np7Usdk9tSs6smLTZp0ON27ta7kSQdt7nrom9ZtP/WvYmPlqsOfudR71lvuyN5yoCElYEPq7LqyOSk3Pu/YVBiY1HKwxbaTOyicvy+vNpu5xfzHwU+T+rhjbOSsl8ZO4jZ4tn7RmtO75hu4vhY/52010fVscGdJt/WXtxGccQW5Quwe3L3cl2Y77bYsXPAwb2un6IGrofz/FDilH7gcun4/GgA=");

    private void checkLiteralData(PGPLiteralData pGPLiteralData, byte[] byArray) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (!pGPLiteralData.getFileName().equals("_CONSOLE")) {
            throw new RuntimeException("wrong filename in packet");
        }
        InputStream inputStream = pGPLiteralData.getDataStream();
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        if (!this.areEqual(byteArrayOutputStream.toByteArray(), byArray)) {
            this.fail("wrong plain text in decrypted packet");
        }
    }

    private void embeddedJpegTest() throws Exception {
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(this.testPubKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(this.testPrivKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey();
        PGPUserAttributeSubpacketVectorGenerator pGPUserAttributeSubpacketVectorGenerator = new PGPUserAttributeSubpacketVectorGenerator();
        pGPUserAttributeSubpacketVectorGenerator.setImageAttribute(1, this.jpegImage);
        PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector = pGPUserAttributeSubpacketVectorGenerator.generate();
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(1, 2).setProvider("BC"));
        pGPSignatureGenerator.init(19, pGPSecretKeyRing.getSecretKey().extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass)));
        PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(pGPUserAttributeSubpacketVector, pGPPublicKey);
        PGPPublicKey pGPPublicKey2 = PGPPublicKey.addCertification(pGPPublicKey, pGPUserAttributeSubpacketVector, pGPSignature);
        Iterator iterator = pGPPublicKey2.getUserAttributes();
        int n = 0;
        while (iterator.hasNext()) {
            PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector2 = (PGPUserAttributeSubpacketVector)iterator.next();
            Iterator iterator2 = pGPPublicKey2.getSignaturesForUserAttribute(pGPUserAttributeSubpacketVector2);
            int n2 = 0;
            while (iterator2.hasNext()) {
                PGPSignature pGPSignature2 = (PGPSignature)iterator2.next();
                pGPSignature2.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
                if (!pGPSignature2.verifyCertification(pGPUserAttributeSubpacketVector2, pGPPublicKey)) {
                    this.fail("added signature failed verification");
                }
                ++n2;
            }
            if (n2 != 1) {
                this.fail("Failed added user attributes signature check");
            }
            ++n;
        }
        if (n != 1) {
            this.fail("didn't find added user attributes");
        }
        pGPPublicKey2 = PGPPublicKey.removeCertification(pGPPublicKey2, pGPUserAttributeSubpacketVector);
        n = 0;
        iterator = pGPPublicKey2.getUserAttributes();
        while (iterator.hasNext()) {
            ++n;
        }
        if (n != 0) {
            this.fail("found attributes where none expected");
        }
    }

    private void existingEmbeddedJpegTest() throws Exception {
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(this.embeddedJPEGKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey();
        Iterator iterator = pGPPublicKey.getUserAttributes();
        int n = 0;
        while (iterator.hasNext()) {
            PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector = (PGPUserAttributeSubpacketVector)iterator.next();
            Iterator iterator2 = pGPPublicKey.getSignaturesForUserAttribute(pGPUserAttributeSubpacketVector);
            int n2 = 0;
            while (iterator2.hasNext()) {
                PGPSignature pGPSignature = (PGPSignature)iterator2.next();
                pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
                if (!pGPSignature.verifyCertification(pGPUserAttributeSubpacketVector, pGPPublicKey)) {
                    this.fail("signature failed verification");
                }
                ++n2;
            }
            if (n2 != 1) {
                this.fail("Failed user attributes signature check");
            }
            ++n;
        }
        if (n != 1) {
            this.fail("didn't find user attributes");
        }
    }

    private void fingerPrintTest() throws Exception {
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(this.fingerprintKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey();
        if (!this.areEqual(pGPPublicKey.getFingerprint(), Hex.decode((String)"4FFB9F0884266C715D1CEAC804A3BBFA"))) {
            this.fail("version 3 fingerprint test failed");
        }
        if (!this.areEqual((pGPPublicKey = (pGPPublicKeyRing = new PGPPublicKeyRing(this.testPubKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator())).getPublicKey()).getFingerprint(), Hex.decode((String)"3062363c1046a01a751946bb35586146fdf3f373"))) {
            this.fail("version 4 fingerprint test failed");
        }
    }

    public String getName() {
        return "PGPRSATest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPRSATest());
    }

    private void mixedTest(PGPPrivateKey pGPPrivateKey, PGPPublicKey pGPPublicKey) throws Exception {
        byte[] byArray = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 33, 10};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)byteArrayOutputStream, 'b', "_CONSOLE", byArray.length, new Date());
        outputStream.write(byArray);
        pGPLiteralDataGenerator.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byArray2);
        this.checkLiteralData((PGPLiteralData)jcaPGPObjectFactory.nextObject(), byArray);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(7).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()).setProvider("BC"));
        pGPEncryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey).setProvider("BC"));
        pGPEncryptedDataGenerator.addMethod(new JcePBEKeyEncryptionMethodGenerator("password".toCharArray()).setProvider("BC"));
        OutputStream outputStream2 = pGPEncryptedDataGenerator.open((OutputStream)byteArrayOutputStream2, byArray2.length);
        outputStream2.write(byArray2);
        outputStream2.close();
        byte[] byArray3 = byteArrayOutputStream2.toByteArray();
        JcaPGPObjectFactory jcaPGPObjectFactory2 = new JcaPGPObjectFactory(byArray3);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory2.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
        JcaPGPObjectFactory jcaPGPObjectFactory3 = new JcaPGPObjectFactory(inputStream);
        this.checkLiteralData((PGPLiteralData)jcaPGPObjectFactory3.nextObject(), byArray);
        jcaPGPObjectFactory2 = new JcaPGPObjectFactory(byArray3);
        pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory2.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.get(1);
        inputStream = pGPPBEEncryptedData.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build("password".toCharArray()));
        jcaPGPObjectFactory2 = new JcaPGPObjectFactory(inputStream);
        this.checkLiteralData((PGPLiteralData)jcaPGPObjectFactory2.nextObject(), byArray);
    }

    private void multipleExpiryTest() throws Exception {
        char[] cArray = "test".toCharArray();
        String string = "TEST <test@test.org>";
        Date date = new Date();
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        KeyPair keyPair2 = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(3, keyPair, date);
        JcaPGPKeyPair jcaPGPKeyPair2 = new JcaPGPKeyPair(1, keyPair2, date);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = null;
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setKeyExpirationTime(true, 63244800L);
        pGPSignatureSubpacketGenerator.setPrimaryUserID(true, true);
        int[] nArray = new int[]{9, 8, 2};
        pGPSignatureSubpacketGenerator.setPreferredSymmetricAlgorithms(true, nArray);
        int[] nArray2 = new int[]{2, 10, 9, 8, 3};
        pGPSignatureSubpacketGenerator.setPreferredHashAlgorithms(true, nArray2);
        int[] nArray3 = new int[]{2, 3, 1};
        pGPSignatureSubpacketGenerator.setPreferredCompressionAlgorithms(true, nArray3);
        pGPSignatureSubpacketGenerator.setFeature(true, (byte)1);
        pGPSignatureSubpacketGenerator.setKeyFlags(true, 3);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector2 = pGPSignatureSubpacketGenerator.generate();
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        PGPKeyRingGenerator pGPKeyRingGenerator = new PGPKeyRingGenerator(19, jcaPGPKeyPair, string, pGPDigestCalculator, pGPSignatureSubpacketVector2, pGPSignatureSubpacketVector, new JcaPGPContentSignerBuilder(jcaPGPKeyPair.getPublicKey().getAlgorithm(), 2), new JcePBESecretKeyEncryptorBuilder(9).setProvider("BC").build(cArray));
        pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setKeyExpirationTime(true, 63244800L);
        pGPSignatureSubpacketGenerator.setKeyFlags(true, 12);
        pGPSignatureSubpacketGenerator.setPrimaryUserID(true, false);
        pGPSignatureSubpacketGenerator.setFeature(true, (byte)1);
        pGPSignatureSubpacketVector2 = pGPSignatureSubpacketGenerator.generate();
        pGPKeyRingGenerator.addSubKey(jcaPGPKeyPair2, pGPSignatureSubpacketVector2, pGPSignatureSubpacketVector);
        byte[] byArray = pGPKeyRingGenerator.generatePublicKeyRing().getEncoded();
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(byArray, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator iterator = pGPPublicKeyRing.getPublicKeys();
        while (iterator.hasNext()) {
            PGPPublicKey pGPPublicKey = (PGPPublicKey)iterator.next();
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(3, 2).setProvider("BC"));
            if (pGPPublicKey.isMasterKey()) {
                pGPSignatureGenerator.init(19, jcaPGPKeyPair.getPrivateKey());
            } else {
                pGPSignatureGenerator.init(24, jcaPGPKeyPair.getPrivateKey());
            }
            pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            pGPSignatureSubpacketGenerator.setKeyExpirationTime(true, 94867200L);
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
            pGPPublicKey = PGPPublicKey.addCertification(pGPPublicKey, pGPPublicKey.isMasterKey() ? pGPSignatureGenerator.generateCertification(pGPPublicKey) : pGPSignatureGenerator.generateCertification(jcaPGPKeyPair.getPublicKey(), pGPPublicKey));
            if (pGPPublicKey.isEncryptionKey()) {
                if (pGPPublicKey.getValidSeconds() == 94867200L) continue;
                this.fail("key expiration time wrong");
                continue;
            }
            if (pGPPublicKey.getValidSeconds() == 94867200L) continue;
            this.fail("key expiration time wrong");
        }
    }

    private boolean noIDEA() {
        try {
            Cipher.getInstance("IDEA", "BC");
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void performTest() throws Exception {
        Object object;
        int n;
        PGPPrivateKey pGPPrivateKey;
        PGPSecretKeyRing pGPSecretKeyRing;
        PublicKey publicKey = null;
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(this.testPubKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        publicKey = new JcaPGPKeyConverter().setProvider("BC").getPublicKey(pGPPublicKeyRing.getPublicKey());
        Iterator iterator = pGPPublicKeyRing.getPublicKey().getUserIDs();
        String string = (String)iterator.next();
        iterator = pGPPublicKeyRing.getPublicKey().getSignaturesForID(string);
        PGPSignature pGPSignature = (PGPSignature)iterator.next();
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKeyRing.getPublicKey());
        if (!pGPSignature.verifyCertification(string, pGPPublicKeyRing.getPublicKey())) {
            this.fail("failed to verify certification");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
        pGPPublicKeyRing.encode(bCPGOutputStream);
        if (!this.areEqual(byteArrayOutputStream.toByteArray(), this.testPubKey)) {
            this.fail("public key rewrite failed");
        }
        PGPPublicKeyRing pGPPublicKeyRing2 = new PGPPublicKeyRing(this.testPubKeyV3, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PublicKey publicKey2 = new JcaPGPKeyConverter().setProvider("BC").getPublicKey(pGPPublicKeyRing.getPublicKey());
        byteArrayOutputStream = new ByteArrayOutputStream();
        bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
        pGPPublicKeyRing2.encode(bCPGOutputStream);
        char[] cArray = "FIXCITY_QA".toCharArray();
        if (!this.noIDEA()) {
            pGPSecretKeyRing = new PGPSecretKeyRing(this.testPrivKeyV3, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            pGPPrivateKey = pGPSecretKeyRing.getSecretKey().extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(cArray));
            byteArrayOutputStream = new ByteArrayOutputStream();
            bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
            pGPSecretKeyRing.encode(bCPGOutputStream);
            if (!this.areEqual(byteArrayOutputStream.toByteArray(), this.testPrivKeyV3)) {
                this.fail("private key V3 rewrite failed");
            }
        }
        pGPSecretKeyRing = new PGPSecretKeyRing(this.testPrivKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        pGPPrivateKey = pGPSecretKeyRing.getSecretKey().extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass));
        byteArrayOutputStream = new ByteArrayOutputStream();
        bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
        pGPSecretKeyRing.encode(bCPGOutputStream);
        if (!this.areEqual(byteArrayOutputStream.toByteArray(), this.testPrivKey)) {
            this.fail("private key rewrite failed");
        }
        Cipher cipher = Cipher.getInstance("RSA", "BC");
        cipher.init(1, publicKey);
        byte[] byArray = "hello world".getBytes();
        byte[] byArray2 = cipher.doFinal(byArray);
        cipher.init(2, new JcaPGPKeyConverter().setProvider("BC").getPrivateKey(pGPPrivateKey));
        byArray2 = cipher.doFinal(byArray2);
        if (!this.areEqual(byArray, byArray2)) {
            this.fail("decryption failed.");
        }
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(this.sig1);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
        jcaPGPObjectFactory = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
        PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)jcaPGPObjectFactory.nextObject();
        PGPOnePassSignature pGPOnePassSignature = pGPOnePassSignatureList.get(0);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        InputStream inputStream = pGPLiteralData.getInputStream();
        pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKeyRing.getPublicKey(pGPOnePassSignature.getKeyID()));
        while ((n = inputStream.read()) >= 0) {
            pGPOnePassSignature.update((byte)n);
        }
        PGPSignatureList pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
        if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
            this.fail("Failed signature check");
        }
        pGPSecretKeyRing = new PGPSecretKeyRing(this.subKey, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        byte[] byArray3 = new byte[]{104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100, 33, 10};
        JcaPGPObjectFactory jcaPGPObjectFactory2 = new JcaPGPObjectFactory(this.enc1);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory2.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        pGPPrivateKey = pGPSecretKeyRing.getSecretKey(pGPPublicKeyEncryptedData.getKeyID()).extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass));
        InputStream inputStream2 = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
        jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream2);
        pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
        jcaPGPObjectFactory = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
        PGPLiteralData pGPLiteralData2 = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        byteArrayOutputStream = new ByteArrayOutputStream();
        if (!pGPLiteralData2.getFileName().equals("test.txt")) {
            throw new RuntimeException("wrong filename in packet");
        }
        InputStream inputStream3 = pGPLiteralData2.getDataStream();
        while ((n = inputStream3.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        if (!this.areEqual(byteArrayOutputStream.toByteArray(), byArray3)) {
            this.fail("wrong plain text in decrypted packet");
        }
        byte[] byArray4 = new byte[]{104, 101, 108, 108, 111};
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setSecureRandom(new SecureRandom()).setProvider("BC"));
        PGPPublicKey pGPPublicKey = pGPSecretKeyRing.getSecretKey(pGPPublicKeyEncryptedData.getKeyID()).getPublicKey();
        pGPEncryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey).setProvider("BC"));
        OutputStream outputStream = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), byArray4.length);
        outputStream.write(byArray4);
        outputStream.close();
        jcaPGPObjectFactory2 = new JcaPGPObjectFactory(byteArrayOutputStream2.toByteArray());
        pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory2.nextObject();
        pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        pGPPrivateKey = pGPSecretKeyRing.getSecretKey(pGPPublicKeyEncryptedData.getKeyID()).extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass));
        PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory = new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey);
        if (pGPPublicKeyEncryptedData.getSymmetricAlgorithm(publicKeyDataDecryptorFactory) != 3) {
            this.fail("symmetric algorithm mismatch");
        }
        inputStream2 = pGPPublicKeyEncryptedData.getDataStream(publicKeyDataDecryptorFactory);
        byteArrayOutputStream.reset();
        while ((n = inputStream2.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (!this.areEqual(byArray2, byArray4)) {
            this.fail("wrong plain text in generated short text packet");
        }
        byteArrayOutputStream2 = new ByteArrayOutputStream();
        pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setSecureRandom(new SecureRandom()).setProvider("BC"));
        pGPPublicKey = pGPSecretKeyRing.getSecretKey(pGPPublicKeyEncryptedData.getKeyID()).getPublicKey();
        pGPEncryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey).setProvider("BC"));
        outputStream = pGPEncryptedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream2), byArray3.length);
        outputStream.write(byArray3);
        outputStream.close();
        jcaPGPObjectFactory2 = new JcaPGPObjectFactory(byteArrayOutputStream2.toByteArray());
        pGPEncryptedDataList = (PGPEncryptedDataList)jcaPGPObjectFactory2.nextObject();
        pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.get(0);
        pGPPrivateKey = pGPSecretKeyRing.getSecretKey(pGPPublicKeyEncryptedData.getKeyID()).extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pass));
        inputStream2 = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
        byteArrayOutputStream.reset();
        while ((n = inputStream2.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (!this.areEqual(byArray2, byArray3)) {
            this.fail("wrong plain text in generated packet");
        }
        jcaPGPObjectFactory2 = new JcaPGPObjectFactory(this.subPubKey);
        while ((object = jcaPGPObjectFactory.nextObject()) != null) {
        }
        char[] cArray2 = "hello".toCharArray();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        PGPSecretKey pGPSecretKey = new PGPSecretKey(16, (PGPKeyPair)new JcaPGPKeyPair(1, keyPair, new Date()), "fred", null, null, (PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(3, 2).setProvider("BC"), new JcePBESecretKeyEncryptorBuilder(3).build(cArray2));
        PGPPublicKey pGPPublicKey2 = pGPSecretKey.getPublicKey();
        iterator = pGPPublicKey2.getUserIDs();
        string = (String)iterator.next();
        iterator = pGPPublicKey2.getSignaturesForID(string);
        pGPSignature = (PGPSignature)iterator.next();
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey2);
        if (!pGPSignature.verifyCertification(string, pGPPublicKey2)) {
            this.fail("failed to verify certification");
        }
        pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(cArray2));
        if ((pGPPublicKey2 = PGPPublicKey.removeCertification(pGPPublicKey2, string, pGPSignature)) == null) {
            this.fail("failed certification removal");
        }
        byte[] byArray5 = pGPPublicKey2.getEncoded();
        pGPPublicKey2 = PGPPublicKey.addCertification(pGPPublicKey2, string, pGPSignature);
        byArray5 = pGPPublicKey2.getEncoded();
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(1, 2).setProvider("BC"));
        pGPSignatureGenerator.init(32, pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(cArray2)));
        pGPSignature = pGPSignatureGenerator.generateCertification(pGPPublicKey2);
        pGPPublicKey2 = PGPPublicKey.addCertification(pGPPublicKey2, pGPSignature);
        byArray5 = pGPPublicKey2.getEncoded();
        PGPPublicKeyRing pGPPublicKeyRing3 = new PGPPublicKeyRing(byArray5, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        pGPPublicKey2 = pGPPublicKeyRing3.getPublicKey();
        Iterator iterator2 = pGPPublicKey2.getSignaturesOfType(32);
        pGPSignature = (PGPSignature)iterator2.next();
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey2);
        if (!pGPSignature.verifyCertification(pGPPublicKey2)) {
            this.fail("failed to verify revocation certification");
        }
        JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(1, keyPair, new Date());
        PGPPublicKey pGPPublicKey3 = jcaPGPKeyPair.getPublicKey();
        PGPPrivateKey pGPPrivateKey2 = jcaPGPKeyPair.getPrivateKey();
        pGPPublicKey3.getEncoded();
        this.mixedTest(pGPPrivateKey2, pGPPublicKey3);
        keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        pGPSecretKey = new PGPSecretKey(16, (PGPKeyPair)new JcaPGPKeyPair(3, keyPair, new Date()), "fred", null, null, (PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(3, 2).setProvider("BC"), new JcePBESecretKeyEncryptorBuilder(9).build(cArray2));
        pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(cArray2));
        pGPSecretKey.encode(new ByteArrayOutputStream());
        PBESecretKeyDecryptor pBESecretKeyDecryptor = new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(cArray2);
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build().get(2);
        JcePBESecretKeyEncryptorBuilder jcePBESecretKeyEncryptorBuilder = new JcePBESecretKeyEncryptorBuilder(9);
        JcaPGPContentSignerBuilder jcaPGPContentSignerBuilder = new JcaPGPContentSignerBuilder(3, 8).setProvider("BC");
        PGPSecretKey pGPSecretKey2 = new PGPSecretKey(pGPSecretKey.extractKeyPair(pBESecretKeyDecryptor), (PGPKeyPair)new JcaPGPKeyPair(2, ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair(), new Date()), pGPDigestCalculator, null, null, (PGPContentSignerBuilder)jcaPGPContentSignerBuilder, jcePBESecretKeyEncryptorBuilder.build(cArray2));
        JcaPGPKeyPair jcaPGPKeyPair2 = new JcaPGPKeyPair(3, ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair(), new Date());
        PGPSignatureGenerator pGPSignatureGenerator2 = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(3, 8).setProvider("BC"));
        pGPSignatureGenerator2.init(25, jcaPGPKeyPair2.getPrivateKey());
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setEmbeddedSignature(false, pGPSignatureGenerator2.generateCertification(pGPSecretKey.getPublicKey(), jcaPGPKeyPair2.getPublicKey()));
        PGPSecretKey pGPSecretKey3 = new PGPSecretKey(pGPSecretKey.extractKeyPair(pBESecretKeyDecryptor), (PGPKeyPair)jcaPGPKeyPair2, pGPDigestCalculator, pGPSignatureSubpacketGenerator.generate(), null, (PGPContentSignerBuilder)jcaPGPContentSignerBuilder, jcePBESecretKeyEncryptorBuilder.build(cArray2));
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        pGPSecretKey.encode(byteArrayOutputStream3);
        PGPSecretKeyRing pGPSecretKeyRing2 = new JcaPGPSecretKeyRing(byteArrayOutputStream3.toByteArray());
        byteArrayOutputStream3 = new ByteArrayOutputStream();
        pGPSecretKey.getPublicKey().encode(byteArrayOutputStream3);
        PGPPublicKeyRing pGPPublicKeyRing4 = new JcaPGPPublicKeyRing(byteArrayOutputStream3.toByteArray());
        pGPPublicKeyRing4 = PGPPublicKeyRing.insertPublicKey(pGPPublicKeyRing4, pGPSecretKey2.getPublicKey());
        pGPSecretKeyRing2 = PGPSecretKeyRing.insertSecretKey(pGPSecretKeyRing2, pGPSecretKey2);
        pGPPublicKeyRing4 = PGPPublicKeyRing.insertPublicKey(pGPPublicKeyRing4, pGPSecretKey3.getPublicKey());
        pGPSecretKeyRing2 = PGPSecretKeyRing.insertSecretKey(pGPSecretKeyRing2, pGPSecretKey3);
        this.isTrue(pGPPublicKeyRing4.getPublicKey(pGPSecretKey2.getKeyID()) != null);
        this.isTrue(pGPSecretKeyRing2.getSecretKey(pGPSecretKey2.getKeyID()) != null);
        this.isTrue(pGPPublicKeyRing4.getPublicKey(pGPSecretKey3.getKeyID()) != null);
        this.isTrue(pGPSecretKeyRing2.getSecretKey(pGPSecretKey3.getKeyID()) != null);
        pGPSecretKey3 = new PGPSecretKey(pGPSecretKey.extractKeyPair(pBESecretKeyDecryptor), jcaPGPKeyPair2, pGPDigestCalculator, new JcaPGPContentSignerBuilder(3, 8).setProvider("BC"), new JcePBESecretKeyEncryptorBuilder(9).build(cArray2));
        try {
            pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            pGPSecretKey3 = new PGPSecretKey(pGPSecretKey.extractKeyPair(pBESecretKeyDecryptor), (PGPKeyPair)jcaPGPKeyPair2, pGPDigestCalculator, pGPSignatureSubpacketGenerator.generate(), null, (PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(3, 8).setProvider("BC"), new JcePBESecretKeyEncryptorBuilder(9).build(cArray2));
            this.fail("no exception");
        }
        catch (PGPException pGPException) {
            this.isEquals("signing subkey requires embedded PRIMARYKEY_BINDING signature", pGPException.getMessage());
        }
        String string2 = "newPass";
        pGPSecretKey = PGPSecretKey.copyWithNewPassword(pGPSecretKey, new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(cArray2), new JcePBESecretKeyEncryptorBuilder(pGPSecretKey.getKeyEncryptionAlgorithm()).setProvider("BC").setSecureRandom(new SecureRandom()).build(string2.toCharArray()));
        pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(string2.toCharArray()));
        pGPSecretKey.encode(new ByteArrayOutputStream());
        pGPPublicKey2 = pGPSecretKey.getPublicKey();
        pGPPublicKey2.encode(new ByteArrayOutputStream());
        iterator = pGPPublicKey2.getUserIDs();
        string = (String)iterator.next();
        iterator = pGPPublicKey2.getSignaturesForID(string);
        pGPSignature = (PGPSignature)iterator.next();
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey2);
        if (!pGPSignature.verifyCertification(string, pGPPublicKey2)) {
            this.fail("failed to verify certification");
        }
        pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(string2.toCharArray()));
        String string3 = "hello world!";
        byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
        pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(1, 2).setProvider("BC"));
        pGPSignatureGenerator.init(0, pGPPrivateKey);
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        BCPGOutputStream bCPGOutputStream2 = new BCPGOutputStream(pGPCompressedDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream)));
        pGPSignatureGenerator.generateOnePassVersion(false).encode(bCPGOutputStream2);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        Date date = new Date(System.currentTimeMillis() / 1000L * 1000L);
        OutputStream outputStream2 = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)bCPGOutputStream2), 'b', "_CONSOLE", string3.getBytes().length, date);
        while ((n = byteArrayInputStream.read()) >= 0) {
            outputStream2.write(n);
            pGPSignatureGenerator.update((byte)n);
        }
        outputStream2.close();
        pGPSignatureGenerator.generate().encode(bCPGOutputStream2);
        bCPGOutputStream2.close();
        jcaPGPObjectFactory = new JcaPGPObjectFactory(byteArrayOutputStream.toByteArray());
        pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
        jcaPGPObjectFactory = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
        pGPOnePassSignatureList = (PGPOnePassSignatureList)jcaPGPObjectFactory.nextObject();
        pGPOnePassSignature = pGPOnePassSignatureList.get(0);
        pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        if (!pGPLiteralData.getModificationTime().equals(date)) {
            this.fail("Modification time not preserved: " + pGPLiteralData.getModificationTime() + " " + date);
        }
        inputStream = pGPLiteralData.getInputStream();
        pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPSecretKey.getPublicKey());
        while ((n = inputStream.read()) >= 0) {
            pGPOnePassSignature.update((byte)n);
        }
        pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
        if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
            this.fail("Failed generated signature check");
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
        PGPV3SignatureGenerator pGPV3SignatureGenerator = new PGPV3SignatureGenerator(new JcaPGPContentSignerBuilder(1, 2).setProvider("BC"));
        pGPV3SignatureGenerator.init(0, pGPPrivateKey);
        pGPCompressedDataGenerator = new PGPCompressedDataGenerator(1);
        bCPGOutputStream2 = new BCPGOutputStream(pGPCompressedDataGenerator.open(byteArrayOutputStream));
        pGPV3SignatureGenerator.generateOnePassVersion(false).encode(bCPGOutputStream2);
        pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        outputStream2 = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)bCPGOutputStream2), 'b', "_CONSOLE", string3.getBytes().length, date);
        while ((n = byteArrayInputStream.read()) >= 0) {
            outputStream2.write(n);
            pGPV3SignatureGenerator.update((byte)n);
        }
        outputStream2.close();
        pGPV3SignatureGenerator.generate().encode(bCPGOutputStream2);
        bCPGOutputStream2.close();
        jcaPGPObjectFactory = new JcaPGPObjectFactory(byteArrayOutputStream.toByteArray());
        pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
        jcaPGPObjectFactory = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
        pGPOnePassSignatureList = (PGPOnePassSignatureList)jcaPGPObjectFactory.nextObject();
        pGPOnePassSignature = pGPOnePassSignatureList.get(0);
        pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        if (!pGPLiteralData.getModificationTime().equals(date)) {
            this.fail("Modification time not preserved");
        }
        inputStream = pGPLiteralData.getInputStream();
        pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPSecretKey.getPublicKey());
        while ((n = inputStream.read()) >= 0) {
            pGPOnePassSignature.update((byte)n);
        }
        pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
        if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
            this.fail("Failed v3 generated signature check");
        }
        pGPSecretKeyRing = new PGPSecretKeyRing(this.pgp8Key, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        pGPSecretKey = pGPSecretKeyRing.getSecretKey();
        pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC").build(this.pgp8Pass));
        this.testExpiry(this.expiry60and30daysSig13Key, 60, 30);
        this.fingerPrintTest();
        this.existingEmbeddedJpegTest();
        this.embeddedJpegTest();
        this.sigsubpacketTest();
        this.multipleExpiryTest();
        this.shortSigTest();
    }

    private void shortSigTest() throws Exception {
        int n;
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(new ByteArrayInputStream(shortSigKey), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        BCPGInputStream bCPGInputStream = new BCPGInputStream(new ByteArrayInputStream(shortSig));
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(bCPGInputStream);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
        jcaPGPObjectFactory = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
        PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)jcaPGPObjectFactory.nextObject();
        PGPOnePassSignature pGPOnePassSignature = pGPOnePassSignatureList.get(0);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        InputStream inputStream = pGPLiteralData.getInputStream();
        pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKeyRing.getPublicKey());
        while ((n = inputStream.read()) >= 0) {
            pGPOnePassSignature.update((byte)n);
        }
        PGPSignatureList pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
        if (!pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
            this.fail("Failed v3 generated signature check");
        }
    }

    private void sigsubpacketTest() throws Exception {
        char[] cArray = "test".toCharArray();
        String string = "TEST <test@test.org>";
        Date date = new Date();
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        KeyPair keyPair2 = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        JcaPGPKeyPair jcaPGPKeyPair = new JcaPGPKeyPair(3, keyPair, date);
        JcaPGPKeyPair jcaPGPKeyPair2 = new JcaPGPKeyPair(1, keyPair2, date);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = null;
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setKeyExpirationTime(true, 63244800L);
        pGPSignatureSubpacketGenerator.setPrimaryUserID(true, true);
        int[] nArray = new int[]{9, 8, 2};
        pGPSignatureSubpacketGenerator.setPreferredSymmetricAlgorithms(true, nArray);
        int[] nArray2 = new int[]{2, 10, 9, 8, 3};
        pGPSignatureSubpacketGenerator.setPreferredHashAlgorithms(true, nArray2);
        int[] nArray3 = new int[]{2, 3, 1};
        pGPSignatureSubpacketGenerator.setPreferredCompressionAlgorithms(true, nArray3);
        pGPSignatureSubpacketGenerator.setFeature(true, (byte)1);
        pGPSignatureSubpacketGenerator.setKeyFlags(true, 3);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector2 = pGPSignatureSubpacketGenerator.generate();
        PGPDigestCalculator pGPDigestCalculator = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        PGPKeyRingGenerator pGPKeyRingGenerator = new PGPKeyRingGenerator(19, jcaPGPKeyPair, string, pGPDigestCalculator, pGPSignatureSubpacketVector2, pGPSignatureSubpacketVector, new JcaPGPContentSignerBuilder(3, 2), new JcePBESecretKeyEncryptorBuilder(9).setProvider("BC").build(cArray));
        pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setKeyExpirationTime(true, 63244800L);
        pGPSignatureSubpacketGenerator.setKeyFlags(true, 12);
        pGPSignatureSubpacketGenerator.setPrimaryUserID(true, false);
        pGPSignatureSubpacketGenerator.setFeature(true, (byte)1);
        pGPSignatureSubpacketVector2 = pGPSignatureSubpacketGenerator.generate();
        pGPKeyRingGenerator.addSubKey(jcaPGPKeyPair2, pGPSignatureSubpacketVector2, pGPSignatureSubpacketVector);
        byte[] byArray = pGPKeyRingGenerator.generatePublicKeyRing().getEncoded();
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(byArray, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator iterator = pGPPublicKeyRing.getPublicKeys();
        while (iterator.hasNext()) {
            PGPSignatureSubpacketVector pGPSignatureSubpacketVector3;
            PGPSignature pGPSignature;
            Iterator iterator2;
            PGPPublicKey pGPPublicKey = (PGPPublicKey)iterator.next();
            if (pGPPublicKey.isEncryptionKey()) {
                iterator2 = pGPPublicKey.getSignatures();
                while (iterator2.hasNext()) {
                    pGPSignature = (PGPSignature)iterator2.next();
                    pGPSignatureSubpacketVector3 = pGPSignature.getHashedSubPackets();
                    if (pGPSignatureSubpacketVector3.getKeyExpirationTime() != 63244800L) {
                        this.fail("key expiration time wrong");
                    }
                    if (!pGPSignatureSubpacketVector3.getFeatures().supportsFeature((byte)1)) {
                        this.fail("features wrong");
                    }
                    if (pGPSignatureSubpacketVector3.isPrimaryUserID()) {
                        this.fail("primary userID flag wrong");
                    }
                    if (pGPSignatureSubpacketVector3.getKeyFlags() == 12) continue;
                    this.fail("keyFlags wrong");
                }
                continue;
            }
            iterator2 = pGPPublicKey.getSignatures();
            while (iterator2.hasNext()) {
                pGPSignature = (PGPSignature)iterator2.next();
                pGPSignatureSubpacketVector3 = pGPSignature.getHashedSubPackets();
                if (!Arrays.areEqual((int[])pGPSignatureSubpacketVector3.getPreferredSymmetricAlgorithms(), (int[])nArray)) {
                    this.fail("preferred encryption algs don't match");
                }
                if (!Arrays.areEqual((int[])pGPSignatureSubpacketVector3.getPreferredHashAlgorithms(), (int[])nArray2)) {
                    this.fail("preferred hash algs don't match");
                }
                if (!Arrays.areEqual((int[])pGPSignatureSubpacketVector3.getPreferredCompressionAlgorithms(), (int[])nArray3)) {
                    this.fail("preferred compression algs don't match");
                }
                if (!pGPSignatureSubpacketVector3.getFeatures().supportsFeature((byte)1)) {
                    this.fail("features wrong");
                }
                if (pGPSignatureSubpacketVector3.getKeyFlags() == 3) continue;
                this.fail("keyFlags wrong");
            }
        }
    }

    private void testExpiry(byte[] byArray, int n, int n2) throws Exception {
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(byArray, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey();
        if (pGPPublicKey.getValidDays() != n) {
            this.fail("mismatch on master valid days.");
        }
        Iterator iterator = pGPPublicKeyRing.getPublicKeys();
        iterator.next();
        pGPPublicKey = (PGPPublicKey)iterator.next();
        if (pGPPublicKey.getValidDays() != n2) {
            this.fail("mismatch on subkey valid days.");
        }
    }
}

