/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcSessionKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JceSessionKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;
import org.bouncycastle.util.test.SimpleTest;

public class PGPSessionKeyTest
extends SimpleTest {
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\n   Comment: Alice's OpenPGP Transferable Secret Key\n\n   lFgEXEcE6RYJKwYBBAHaRw8BAQdArjWwk3FAqyiFbFBKT4TzXcVBqPTB3gmzlC/U\n   b7O1u10AAP9XBeW6lzGOLx7zHH9AsUDUTb2pggYGMzd0P3ulJ2AfvQ4RtCZBbGlj\n   ZSBMb3ZlbGFjZSA8YWxpY2VAb3BlbnBncC5leGFtcGxlPoiQBBMWCAA4AhsDBQsJ\n   CAcCBhUKCQgLAgQWAgMBAh4BAheAFiEE64W7X6M6deFelE5j8jFVDE9H444FAl2l\n   nzoACgkQ8jFVDE9H447pKwD6A5xwUqIDprBzrHfahrImaYEZzncqb25vkLV2arYf\n   a78A/R3AwtLQvjxwLDuzk4dUtUwvUYibL2sAHwj2kGaHnfICnF0EXEcE6RIKKwYB\n   BAGXVQEFAQEHQEL/BiGtq0k84Km1wqQw2DIikVYrQrMttN8d7BPfnr4iAwEIBwAA\n   /3/xFPG6U17rhTuq+07gmEvaFYKfxRB6sgAYiW6TMTpQEK6IeAQYFggAIBYhBOuF\n   u1+jOnXhXpROY/IxVQxPR+OOBQJcRwTpAhsMAAoJEPIxVQxPR+OOWdABAMUdSzpM\n   hzGs1O0RkWNQWbUzQ8nUOeD9wNbjE3zR+yfRAQDbYqvtWQKN4AQLTxVJN5X5AWyb\n   Pnn+We1aTBhaGa86AQ==\n   =n8OM\n   -----END PGP PRIVATE KEY BLOCK-----";
    private static final String PK_ENC_MESSAGE = "-----BEGIN PGP MESSAGE-----\n\nwV4DR2b2udXyHrYSAQdAO6LtuB8LenDp1EPVSSYn1QCmTSPjeXj9Qdel7t6Ozi8w\nkewS+0AdZcvcd2PQEuCboilRAN4TTi9SziuSDNZe//suYHL7SRnOvX6mWSZoiKBm\n0j8BlbKlRhBzcNDj6DSKfM/KBhRaw0U9fGs01gq+RNXIHOOnzVjLK18xTNEkx72F\nZ1/i3TYsmy8B0mMKkNYtpMk=\n=IICf\n-----END PGP MESSAGE-----\n";
    private static final String PK_ENC_SESSIONKEY = "C7CBDAF42537776F12509B5168793C26B93294E5ABDFA73224FB0177123E9137";
    private static final int PK_ENC_SESSIONKEY_ALG = 9;
    private static final String PBE_MESSAGE = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\njA0ECQMC8f/JlPUqzS9g0kABpxEJOYB22YqEopVRT1Qvg9ZdFIKeTLmrJZY74ph2\nm4JOOELpXbxxSmB3x9CPn+zdULechPnqCkpvstLqb9B5\n=AdMx\n-----END PGP MESSAGE-----\n";
    private static final String PBE_PASSPHRASE = "sw0rdf1sh";
    private static final String PBE_ENC_SESSIONKEY = "65B189C9EE6DE250647B952B83B23C88ABFD5767293ECDBF00DFF2DA943EC59D";
    private static final int PBE_ENC_SESSIONKEY_ALG = 9;

    public String getName() {
        return "PGPSessionKeyTest";
    }

    public static void main(String[] stringArray) throws Exception {
        PGPSessionKeyTest pGPSessionKeyTest = new PGPSessionKeyTest();
        Security.addProvider((Provider)new BouncyCastleProvider());
        pGPSessionKeyTest.performTest();
    }

    public void performTest() throws Exception {
        this.verifyPublicKeyDecryptionYieldsCorrectSessionData();
        this.verifyPasswordBasedDecryptionYieldsCorrectSessionData();
        this.verifyBcPublicKeyDecryptorFactoryFromSessionKeyCanDecryptDataSuccessfully();
        this.verifyJcePublicKeyDecryptorFactoryFromSessionKeyCanDecryptDataSuccessfully();
        this.verifyBcPBEDecryptorFactoryFromSessionKeyCanDecryptDataSuccessfully();
        this.verifyJcePBEDecryptorFactoryFromSessionKeyCanDecryptDataSuccessfully();
        this.testSessionKeyFromString();
    }

    private void testSessionKeyFromString() {
        String string = "9:FCA4BEAF687F48059CACC14FB019125CD57392BAB7037C707835925CBF9F7BCD";
        PGPSessionKey pGPSessionKey = PGPSessionKey.fromAsciiRepresentation(string);
        this.isEquals(9, pGPSessionKey.getAlgorithm());
        this.isEquals("FCA4BEAF687F48059CACC14FB019125CD57392BAB7037C707835925CBF9F7BCD", Hex.toHexString((byte[])pGPSessionKey.getKey()).toUpperCase());
    }

    private void verifyBcPBEDecryptorFactoryFromSessionKeyCanDecryptDataSuccessfully() throws IOException, PGPException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Strings.toByteArray((String)PBE_MESSAGE));
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream);
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(armoredInputStream);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)bcPGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.iterator().next();
        BcSessionKeyDataDecryptorFactory bcSessionKeyDataDecryptorFactory = new BcSessionKeyDataDecryptorFactory(new PGPSessionKey(9, Hex.decode((String)PBE_ENC_SESSIONKEY)));
        InputStream inputStream = pGPPBEEncryptedData.getDataStream(bcSessionKeyDataDecryptorFactory);
        bcPGPObjectFactory = new BcPGPObjectFactory(inputStream);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)bcPGPObjectFactory.nextObject();
        InputStream inputStream2 = pGPCompressedData.getDataStream();
        bcPGPObjectFactory = new BcPGPObjectFactory(inputStream2);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)bcPGPObjectFactory.nextObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)pGPLiteralData.getDataStream(), (OutputStream)byteArrayOutputStream);
        pGPLiteralData.getDataStream().close();
        this.isTrue(Arrays.equals(Strings.toByteArray((String)"Hello, World!\n"), byteArrayOutputStream.toByteArray()));
    }

    private void verifyBcPublicKeyDecryptorFactoryFromSessionKeyCanDecryptDataSuccessfully() throws IOException, PGPException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Strings.toByteArray((String)PK_ENC_MESSAGE));
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream);
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(armoredInputStream);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)bcPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.iterator().next();
        BcSessionKeyDataDecryptorFactory bcSessionKeyDataDecryptorFactory = new BcSessionKeyDataDecryptorFactory(new PGPSessionKey(9, Hex.decode((String)PK_ENC_SESSIONKEY)));
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(bcSessionKeyDataDecryptorFactory);
        bcPGPObjectFactory = new BcPGPObjectFactory(inputStream);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)bcPGPObjectFactory.nextObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)pGPLiteralData.getDataStream(), (OutputStream)byteArrayOutputStream);
        pGPLiteralData.getDataStream().close();
        this.isTrue(Arrays.equals(Strings.toByteArray((String)"Hello World :)"), byteArrayOutputStream.toByteArray()));
    }

    private void verifyJcePBEDecryptorFactoryFromSessionKeyCanDecryptDataSuccessfully() throws IOException, PGPException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Strings.toByteArray((String)PBE_MESSAGE));
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream);
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(armoredInputStream);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)bcPGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.iterator().next();
        SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory = new JceSessionKeyDataDecryptorFactoryBuilder().build(new PGPSessionKey(9, Hex.decode((String)PBE_ENC_SESSIONKEY)));
        InputStream inputStream = pGPPBEEncryptedData.getDataStream(sessionKeyDataDecryptorFactory);
        bcPGPObjectFactory = new BcPGPObjectFactory(inputStream);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)bcPGPObjectFactory.nextObject();
        InputStream inputStream2 = pGPCompressedData.getDataStream();
        bcPGPObjectFactory = new BcPGPObjectFactory(inputStream2);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)bcPGPObjectFactory.nextObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)pGPLiteralData.getDataStream(), (OutputStream)byteArrayOutputStream);
        pGPLiteralData.getDataStream().close();
        this.isTrue(Arrays.equals(Strings.toByteArray((String)"Hello, World!\n"), byteArrayOutputStream.toByteArray()));
    }

    private void verifyJcePublicKeyDecryptorFactoryFromSessionKeyCanDecryptDataSuccessfully() throws IOException, PGPException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Strings.toByteArray((String)PK_ENC_MESSAGE));
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream);
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(armoredInputStream);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)bcPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.iterator().next();
        SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory = new JceSessionKeyDataDecryptorFactoryBuilder().build(new PGPSessionKey(9, Hex.decode((String)PK_ENC_SESSIONKEY)));
        InputStream inputStream = pGPPublicKeyEncryptedData.getDataStream(sessionKeyDataDecryptorFactory);
        bcPGPObjectFactory = new BcPGPObjectFactory(inputStream);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)bcPGPObjectFactory.nextObject();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)pGPLiteralData.getDataStream(), (OutputStream)byteArrayOutputStream);
        pGPLiteralData.getDataStream().close();
        this.isTrue(Arrays.equals(Strings.toByteArray((String)"Hello World :)"), byteArrayOutputStream.toByteArray()));
    }

    private void verifyPasswordBasedDecryptionYieldsCorrectSessionData() throws IOException, PGPException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Strings.toByteArray((String)PBE_MESSAGE));
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream);
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(armoredInputStream);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)bcPGPObjectFactory.nextObject();
        PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedDataList.iterator().next();
        BcPGPDigestCalculatorProvider bcPGPDigestCalculatorProvider = new BcPGPDigestCalculatorProvider();
        BcPBEDataDecryptorFactory bcPBEDataDecryptorFactory = new BcPBEDataDecryptorFactory(PBE_PASSPHRASE.toCharArray(), bcPGPDigestCalculatorProvider);
        PGPSessionKey pGPSessionKey = pGPPBEEncryptedData.getSessionKey(bcPBEDataDecryptorFactory);
        this.isEquals(9, pGPSessionKey.getAlgorithm());
        this.isTrue(Arrays.equals(Hex.decode((String)PBE_ENC_SESSIONKEY), pGPSessionKey.getKey()));
    }

    private void verifyPublicKeyDecryptionYieldsCorrectSessionData() throws IOException, PGPException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Strings.toByteArray((String)KEY));
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream);
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(armoredInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        Iterator iterator = pGPSecretKeyRing.iterator();
        iterator.next();
        PGPSecretKey pGPSecretKey = (PGPSecretKey)iterator.next();
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(Strings.toByteArray((String)PK_ENC_MESSAGE));
        ArmoredInputStream armoredInputStream2 = new ArmoredInputStream(byteArrayInputStream2);
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(armoredInputStream2);
        PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)bcPGPObjectFactory.nextObject();
        PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)pGPEncryptedDataList.iterator().next();
        BcPGPDigestCalculatorProvider bcPGPDigestCalculatorProvider = new BcPGPDigestCalculatorProvider();
        PBESecretKeyDecryptor pBESecretKeyDecryptor = new BcPBESecretKeyDecryptorBuilder(bcPGPDigestCalculatorProvider).build(null);
        BcPublicKeyDataDecryptorFactory bcPublicKeyDataDecryptorFactory = new BcPublicKeyDataDecryptorFactory(pGPSecretKey.extractPrivateKey(pBESecretKeyDecryptor));
        PGPSessionKey pGPSessionKey = pGPPublicKeyEncryptedData.getSessionKey(bcPublicKeyDataDecryptorFactory);
        this.isEquals(9, pGPSessionKey.getAlgorithm());
        this.isTrue(Arrays.equals(Hex.decode((String)PK_ENC_SESSIONKEY), pGPSessionKey.getKey()));
    }
}

