/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PGPSignatureInvalidVersionIgnoredTest
extends SimpleTest {
    private static final long KEY_ID = new BigInteger("FBFCC82A015E7330", 16).longValue();
    private static final String SIG4SIG23 = "-----BEGIN PGP SIGNATURE-----\n\nwsE7BAABCgBvBYJgyf2fCRD7/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9u\ncy5zZXF1b2lhLXBncC5vcmdURSYEGurWv1IDN4trcpgfrHMZeGRdhG5jlQazr8tJ\nQRYhBNGmbhojsYLJmA94jPv8yCoBXnMwAADAYwv+NeSzVRrR/CGLMna43b0xCrOz\ntEYVp3hLzjCYWP1F5d7OdrpQWB3jzgMhjkH5ZnSm369A6D6eEoo05uP7lUNoex7s\nBcksq4QF2t9y0YHwjhciVyPUw0rgzOIDpJ6jb/HqEgWB+EYz5qU3RFAk4tz+ghpw\n93x+EAI7QBnw+PRjgmJiXQvcq78W+h8aysAQCv/dNJc9W8gfCpwDY2VKTc0BW9VI\nR4KbeI2Rgx378JYjzJNP9ORgDTacBdQh3LiqJ8B4x7OeVGouGbWEVG6x+htQ9YMH\nuOY1CmcNzoMSRyk50JOeM0Xcge/9PLuQM+b4OQ3ZRN/BhUEg4P/VclXzkWeDKCvP\ncGEUrdFnyU1Lk2mYh1HTKS3gurTP9bdAyS9sdjXj9kv2fRM5N46rBRAffjwfW/LT\nVedvgRZ3RMCLrwPo90ID/xVU8PC9VmBR+WrqOijdsgnh7n940NR5hSyeWVeMwNFl\nJs043gKSIc5yNLS16mE/YzgosnUpIUsDlSR6D8M/wsE7FwABCgBvBYJgyf2fCRD7\n/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9ucy5zZXF1b2lhLXBncC5vcmdU\nRSYEGurWv1IDN4trcpgfrHMZeGRdhG5jlQazr8tJQRYhBNGmbhojsYLJmA94jPv8\nyCoBXnMwAADAYwv+NeSzVRrR/CGLMna43b0xCrOztEYVp3hLzjCYWP1F5d7OdrpQ\nWB3jzgMhjkH5ZnSm369A6D6eEoo05uP7lUNoex7sBcksq4QF2t9y0YHwjhciVyPU\nw0rgzOIDpJ6jb/HqEgWB+EYz5qU3RFAk4tz+ghpw93x+EAI7QBnw+PRjgmJiXQvc\nq78W+h8aysAQCv/dNJc9W8gfCpwDY2VKTc0BW9VIR4KbeI2Rgx378JYjzJNP9ORg\nDTacBdQh3LiqJ8B4x7OeVGouGbWEVG6x+htQ9YMHuOY1CmcNzoMSRyk50JOeM0Xc\nge/9PLuQM+b4OQ3ZRN/BhUEg4P/VclXzkWeDKCvPcGEUrdFnyU1Lk2mYh1HTKS3g\nurTP9bdAyS9sdjXj9kv2fRM5N46rBRAffjwfW/LTVedvgRZ3RMCLrwPo90ID/xVU\n8PC9VmBR+WrqOijdsgnh7n940NR5hSyeWVeMwNFlJs043gKSIc5yNLS16mE/Yzgo\nsnUpIUsDlSR6D8M/\n=Ptch\n-----END PGP SIGNATURE-----";
    private static final String SIG23SIG4 = "-----BEGIN PGP SIGNATURE-----\n\nwsE7FwABCgBvBYJgyf2fCRD7/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9u\ncy5zZXF1b2lhLXBncC5vcmdURSYEGurWv1IDN4trcpgfrHMZeGRdhG5jlQazr8tJ\nQRYhBNGmbhojsYLJmA94jPv8yCoBXnMwAADAYwv+NeSzVRrR/CGLMna43b0xCrOz\ntEYVp3hLzjCYWP1F5d7OdrpQWB3jzgMhjkH5ZnSm369A6D6eEoo05uP7lUNoex7s\nBcksq4QF2t9y0YHwjhciVyPUw0rgzOIDpJ6jb/HqEgWB+EYz5qU3RFAk4tz+ghpw\n93x+EAI7QBnw+PRjgmJiXQvcq78W+h8aysAQCv/dNJc9W8gfCpwDY2VKTc0BW9VI\nR4KbeI2Rgx378JYjzJNP9ORgDTacBdQh3LiqJ8B4x7OeVGouGbWEVG6x+htQ9YMH\nuOY1CmcNzoMSRyk50JOeM0Xcge/9PLuQM+b4OQ3ZRN/BhUEg4P/VclXzkWeDKCvP\ncGEUrdFnyU1Lk2mYh1HTKS3gurTP9bdAyS9sdjXj9kv2fRM5N46rBRAffjwfW/LT\nVedvgRZ3RMCLrwPo90ID/xVU8PC9VmBR+WrqOijdsgnh7n940NR5hSyeWVeMwNFl\nJs043gKSIc5yNLS16mE/YzgosnUpIUsDlSR6D8M/wsE7BAABCgBvBYJgyf2fCRD7\n/MgqAV5zMEcUAAAAAAAeACBzYWx0QG5vdGF0aW9ucy5zZXF1b2lhLXBncC5vcmdU\nRSYEGurWv1IDN4trcpgfrHMZeGRdhG5jlQazr8tJQRYhBNGmbhojsYLJmA94jPv8\nyCoBXnMwAADAYwv+NeSzVRrR/CGLMna43b0xCrOztEYVp3hLzjCYWP1F5d7OdrpQ\nWB3jzgMhjkH5ZnSm369A6D6eEoo05uP7lUNoex7sBcksq4QF2t9y0YHwjhciVyPU\nw0rgzOIDpJ6jb/HqEgWB+EYz5qU3RFAk4tz+ghpw93x+EAI7QBnw+PRjgmJiXQvc\nq78W+h8aysAQCv/dNJc9W8gfCpwDY2VKTc0BW9VIR4KbeI2Rgx378JYjzJNP9ORg\nDTacBdQh3LiqJ8B4x7OeVGouGbWEVG6x+htQ9YMHuOY1CmcNzoMSRyk50JOeM0Xc\nge/9PLuQM+b4OQ3ZRN/BhUEg4P/VclXzkWeDKCvPcGEUrdFnyU1Lk2mYh1HTKS3g\nurTP9bdAyS9sdjXj9kv2fRM5N46rBRAffjwfW/LTVedvgRZ3RMCLrwPo90ID/xVU\n8PC9VmBR+WrqOijdsgnh7n940NR5hSyeWVeMwNFlJs043gKSIc5yNLS16mE/Yzgo\nsnUpIUsDlSR6D8M/\n=o4rJ\n-----END PGP SIGNATURE-----";

    private void assertInvalidSignatureVersionIsIgnored(String string) throws IOException {
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(new ByteArrayInputStream(Strings.toByteArray((String)string)));
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(armoredInputStream);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)bcPGPObjectFactory.nextObject();
        this.isEquals(1, pGPSignatureList.size());
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        this.isEquals(KEY_ID, pGPSignature.getKeyID());
    }

    public String getName() {
        return "PGPSignatureInvalidVersionIgnoredTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPSignatureInvalidVersionIgnoredTest());
    }

    public void performTest() throws Exception {
        this.assertInvalidSignatureVersionIsIgnored(SIG4SIG23);
        this.assertInvalidSignatureVersionIsIgnored(SIG23SIG4);
    }
}

