/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.SignatureSubpacketInputStream;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPV3SignatureGenerator;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.UncloseableOutputStream;

public class PGPSignatureTest
extends SimpleTest {
    private static final int[] NO_PREFERENCES = null;
    private static final int[] PREFERRED_SYMMETRIC_ALGORITHMS = new int[]{7, 2};
    private static final int[] PREFERRED_HASH_ALGORITHMS = new int[]{2, 8};
    private static final int[] PREFERRED_COMPRESSION_ALGORITHMS = new int[]{2};
    private static final int TEST_EXPIRATION_TIME = 10000;
    private static final String TEST_USER_ID = "test user id";
    private static final byte[] TEST_DATA = "hello world!\nhello world!\n".getBytes();
    private static final byte[] TEST_DATA_WITH_CRLF = "hello world!\r\nhello world!\r\n".getBytes();
    byte[] dsaKeyRing = Base64.decode((String)"lQHhBD9HBzURBACzkxRCVGJg5+Ld9DU4Xpnd4LCKgMq7YOY7Gi0EgK92gbaa6+zQoQFqz1tt3QUmpz3YVkm/zLESBBtC1ACIXGggUdFMUr5I87+1Cb6vzefAtGt8N5VV1F/MXv1gJz4Bu6HyxL/ncfe71jsNhav0i4yAjf2etWFj53zK6R+Ojg5H6wCgpL9/tXVfGP8SqFvyrN/437MlFSUEAIN3V6j/MUllyrZglrtr2+RWIwRrG/ACmrF6hTugOl4cQxaDYNcntXbhlTlJs9MxjTH3xxzylyirCyq7HzGJxZzSt6FTeh1DFYzhJ7QuYR1xrSdA6Y0mUv0ixD5A4nPHjupQ5QCqHGeRfFD/oHzD4zqBnJp/BJ3LvQ66bERJmKl5A/4uj3HoVxpb0vvyENfRqKMmGBISycY4MoH5uWfb23FffsT9r9KL6nJ4syLzaRR0gvcbcjkc9Z3epI7gr3jTrb4d8WPxsDbT/W1tv9bG/EHawomLcihtuUU68Uej6/wZot1XJqu2nQlku57+M/V2X1y26VKsipolPfja4uyBOOyvbP4DAwIDIBTxWjkCGGAWQO2jy9CTvLHJEoTO7moHrp1FxOVpQ8iJHyRqZzLllO26OzgohbiPYz8u9qCulZ9Xn7QzRXJpYyBFY2hpZG5hIChEU0EgVGVzdCBLZXkpIDxlcmljQGJvdW5jeWNhc3RsZS5vcmc+iFkEExECABkFAj9HBzUECwcDAgMVAgMDFgIBAh4BAheAAAoJEM0j9enEyjRDAlwAnjTjjt57NKIgyym7OTCwzIU3xgFpAJ0VO5m5PfQKmGJRhaewLSZD4nXkHg==");
    char[] dsaPass = "hello world".toCharArray();
    byte[] rsaKeyRing = Base64.decode((String)"lQIEBEBXUNMBBADScQczBibewnbCzCswc/9ut8R0fwlltBRxMW0NMdKJY2LF7k2COeLOCIU95loJGV6ulbpDCXEO2Jyq8/qGw1qD3SCZNXxKs3GS8Iyh9UwdVL07nMMYl5NiQRsFB7wOb86+94tYWgvikVA5BRP5y3+O3GItnXnpWSJyREUy6WI2QQAGKf4JAwIVmnRs4jtTX2DD05zy2mepEQ8bsqVAKIx7lEwvMVNcvg4Y8vFLh9Mf/uNciwL4Se/ehfKQ/AT0JmBZduYMqRU2zhiBmxj4cXUQ0s36ysj7fyDngGocDnM3cwPxaTF1ZRBQHSLewP7dqE7M73usFSz8vwD/0xNOHFRLKbsORqDlLA1Cg2Yd0wWPS0o7+qqk9ndqrjjSwMM8ftnzFGjShAdg4Ca7fFkcNePP/rrwIH472FuRb7RbWzwXA4+4ZBdl8D4An0dwtfvAO+jCZSrLjmSpxEOveJxYGduyR4IA4lemvAG51YHTHd4NXheuEqsIkn1yarwaaj47lFPnxNOElOREMdZbnkWQb1jfgqO24imEZgrLMkK9bJfoDnlF4k6r6hZOp5FSFvc5kJB4cVo1QJl4pwCSdoU6luwCggrlZhDnkGCSuQUUW45NE7Br22NGqn4/gHs0KCsWbAezApGjqYUCfX1bcpPzUMzUlBaD5rz2vPeO58CDtBJ0ZXN0ZXIgPHRlc3RAdGVzdD6IsgQTAQIAHAUCQFdQ0wIbAwQLBwMCAxUCAwMWAgECHgECF4AACgkQs8JyyQfH97I1QgP8Cd+35maM2cbWV9iVRO+c5456KDi3oIUSNdPf1NQrCAtJqEUhmMStQbdiaFEkPrORISI/2htXruYn0aIpkCfbUheHOu0sef7s6pHmI2kOQPzR+C/j8D9QvWsPOOso81KU2axUY8zIer64Uzqc4szMIlLw06c8vea27RfgjBpSCrywAgAA");
    char[] rsaPass = "2002 Buffalo Sabres".toCharArray();
    byte[] nullPacketsSubKeyBinding = Base64.decode((String)"iDYEGBECAAAAACp9AJ9PlJCrFpi+INwG7z61eku2Wg1HaQCgl33X5Egj+Kf7F9CXIWj2iFCvQDo=");
    byte[] okAttr = Base64.decode((String)"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");
    byte[] attrLongLength = Base64.decode((String)"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");

    private void checkUserAttribute(String string, PGPPublicKeyRing pGPPublicKeyRing, PGPPublicKey pGPPublicKey) throws PGPException {
        Iterator iterator = pGPPublicKeyRing.getPublicKey().getUserAttributes();
        while (iterator.hasNext()) {
            PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector = (PGPUserAttributeSubpacketVector)iterator.next();
            Iterator iterator2 = pGPPublicKey.getSignaturesForUserAttribute(pGPUserAttributeSubpacketVector);
            while (iterator2.hasNext()) {
                PGPSignature pGPSignature = (PGPSignature)iterator2.next();
                pGPSignature.init(new BcPGPContentVerifierBuilderProvider(), pGPPublicKey);
                if (pGPSignature.verifyCertification(pGPUserAttributeSubpacketVector, pGPPublicKey)) continue;
                this.fail("user attribute sig failed to verify on " + string);
            }
        }
    }

    private void checkValue(int n, int n2) {
        KeyFlags keyFlags = new KeyFlags(true, n);
        if (keyFlags.getFlags() != n2) {
            this.fail("flag value mismatch");
        }
    }

    private void checkValue(byte[] byArray, int n) {
        KeyFlags keyFlags = new KeyFlags(true, false, byArray);
        if (keyFlags.getFlags() != n) {
            this.fail("flag value mismatch");
        }
    }

    private String genString(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 != n) {
            cArray[n2] = (char)(97 + n2 % 26);
            ++n2;
        }
        return new String(cArray);
    }

    private byte[] generateV3BinarySig(PGPPrivateKey pGPPrivateKey, int n, int n2) throws Exception {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(TEST_DATA);
        PGPV3SignatureGenerator pGPV3SignatureGenerator = new PGPV3SignatureGenerator(new JcaPGPContentSignerBuilder(n, n2).setProvider("BC"));
        pGPV3SignatureGenerator.init(0, pGPPrivateKey);
        pGPV3SignatureGenerator.generateOnePassVersion(false).encode(byteArrayOutputStream);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream), 'b', "_CONSOLE", TEST_DATA.length * 2, new Date());
        while ((n3 = byteArrayInputStream.read()) >= 0) {
            outputStream.write(n3);
            pGPV3SignatureGenerator.update((byte)n3);
        }
        outputStream.write(TEST_DATA);
        pGPV3SignatureGenerator.update(TEST_DATA);
        pGPLiteralDataGenerator.close();
        pGPV3SignatureGenerator.generate().encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public String getName() {
        return "PGPSignatureTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new PGPSignatureTest());
    }

    public void performTest() throws Exception {
        SignatureSubpacket[] signatureSubpacketArray;
        this.testRemoveSignature();
        PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(this.rsaKeyRing, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPSecretKey pGPSecretKey = pGPSecretKeyRing.getSecretKey();
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(this.rsaPass));
        try {
            this.testSig(17, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey);
            this.fail("RSA wrong key test failed.");
        }
        catch (PGPException pGPException) {}
        try {
            this.testSigV3(17, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey);
            this.fail("RSA V3 wrong key test failed.");
        }
        catch (PGPException pGPException) {}
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(1, 2).setProvider("BC"));
        pGPSignatureGenerator.init(32, pGPPrivateKey);
        PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(pGPSecretKey.getPublicKey());
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPSecretKey.getPublicKey());
        if (!pGPSignature.verifyCertification(pGPSecretKey.getPublicKey())) {
            this.fail("revocation verification failed.");
        }
        PGPSecretKeyRing pGPSecretKeyRing2 = new PGPSecretKeyRing(this.dsaKeyRing, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPSecretKey pGPSecretKey2 = pGPSecretKeyRing2.getSecretKey();
        PGPPrivateKey pGPPrivateKey2 = pGPSecretKey2.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(this.dsaPass));
        pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(17, 2).setProvider("BC"));
        pGPSignatureGenerator.init(24, pGPPrivateKey2);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator2 = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator2.setSignatureExpirationTime(false, 10000L);
        pGPSignatureSubpacketGenerator2.setSignerUserID(true, TEST_USER_ID);
        pGPSignatureSubpacketGenerator2.setPreferredCompressionAlgorithms(false, PREFERRED_COMPRESSION_ALGORITHMS);
        pGPSignatureSubpacketGenerator2.setPreferredHashAlgorithms(false, PREFERRED_HASH_ALGORITHMS);
        pGPSignatureSubpacketGenerator2.setPreferredSymmetricAlgorithms(false, PREFERRED_SYMMETRIC_ALGORITHMS);
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator2.generate());
        pGPSignatureGenerator.setUnhashedSubpackets(pGPSignatureSubpacketGenerator.generate());
        pGPSignature = pGPSignatureGenerator.generateCertification(pGPSecretKey2.getPublicKey(), pGPSecretKey.getPublicKey());
        byte[] byArray = pGPSignature.getEncoded();
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byArray);
        pGPSignature = ((PGPSignatureList)jcaPGPObjectFactory.nextObject()).get(0);
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPSecretKey2.getPublicKey());
        if (!pGPSignature.verifyCertification(pGPSecretKey2.getPublicKey(), pGPSecretKey.getPublicKey())) {
            this.fail("subkey binding verification failed.");
        }
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets();
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector2 = pGPSignature.getUnhashedSubPackets();
        if (pGPSignatureSubpacketVector.size() != 6) {
            this.fail("wrong number of hashed packets found.");
        }
        this.isTrue((signatureSubpacketArray = pGPSignatureSubpacketVector.toArray()).length == pGPSignatureSubpacketVector.size());
        int n = 0;
        while (n != signatureSubpacketArray.length) {
            this.isEquals(signatureSubpacketArray[n], pGPSignatureSubpacketVector.getSubpacket(signatureSubpacketArray[n].getType()));
            ++n;
        }
        if (pGPSignatureSubpacketVector2.size() != 1) {
            this.fail("wrong number of unhashed packets found.");
        }
        if (!pGPSignatureSubpacketVector.getSignerUserID().equals(TEST_USER_ID)) {
            this.fail("test userid not matching");
        }
        if (pGPSignatureSubpacketVector.getSignatureExpirationTime() != 10000L) {
            this.fail("test signature expiration time not matching");
        }
        if (pGPSignatureSubpacketVector2.getIssuerKeyID() != pGPSecretKey2.getKeyID()) {
            this.fail("wrong issuer key ID found in certification");
        }
        int[] nArray = pGPSignatureSubpacketVector.getPreferredCompressionAlgorithms();
        this.preferredAlgorithmCheck("compression", PREFERRED_COMPRESSION_ALGORITHMS, nArray);
        nArray = pGPSignatureSubpacketVector.getPreferredHashAlgorithms();
        this.preferredAlgorithmCheck("hash", PREFERRED_HASH_ALGORITHMS, nArray);
        nArray = pGPSignatureSubpacketVector.getPreferredSymmetricAlgorithms();
        this.preferredAlgorithmCheck("symmetric", PREFERRED_SYMMETRIC_ALGORITHMS, nArray);
        int[] nArray2 = pGPSignatureSubpacketVector.getCriticalTags();
        if (nArray2.length != 1) {
            this.fail("wrong number of critical packets found.");
        }
        if (nArray2[0] != 28) {
            this.fail("wrong critical packet found in tag list.");
        }
        pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(17, 2).setProvider("BC"));
        pGPSignatureGenerator.init(24, pGPPrivateKey2);
        pGPSignatureGenerator.setHashedSubpackets(null);
        pGPSignatureGenerator.setUnhashedSubpackets(null);
        pGPSignature = pGPSignatureGenerator.generateCertification(TEST_USER_ID, pGPSecretKey.getPublicKey());
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPSecretKey2.getPublicKey());
        if (!pGPSignature.verifyCertification(TEST_USER_ID, pGPSecretKey.getPublicKey())) {
            this.fail("subkey binding verification failed.");
        }
        if ((pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets()).size() != 1) {
            this.fail("found wrong number of hashed packets");
        }
        if ((pGPSignatureSubpacketVector2 = pGPSignature.getUnhashedSubPackets()).size() != 1) {
            this.fail("found wrong number of unhashed packets");
        }
        try {
            pGPSignature.verifyCertification(pGPSecretKey.getPublicKey());
            this.fail("failed to detect non-key signature.");
        }
        catch (PGPException pGPException) {}
        pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(17, 2).setProvider("BC"));
        pGPSignatureGenerator.init(24, pGPPrivateKey2);
        pGPSignatureSubpacketGenerator2 = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator2.setSignatureCreationTime(false, new Date(0L));
        pGPSignatureSubpacketGenerator2.setIssuerFingerprint(false, pGPSecretKey2);
        pGPSignatureSubpacketGenerator2.setIntendedRecipientFingerprint(false, pGPSecretKey.getPublicKey());
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator2.generate());
        pGPSignatureGenerator.setUnhashedSubpackets(null);
        pGPSignature = pGPSignatureGenerator.generateCertification(TEST_USER_ID, pGPSecretKey.getPublicKey());
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPSecretKey2.getPublicKey());
        if (!pGPSignature.verifyCertification(TEST_USER_ID, pGPSecretKey.getPublicKey())) {
            this.fail("subkey binding verification failed.");
        }
        if ((pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets()).size() != 3) {
            this.fail("found wrong number of hashed packets in override test");
        }
        if (!pGPSignatureSubpacketVector.hasSubpacket(2)) {
            this.fail("hasSubpacket test for creation time failed");
        }
        if (!pGPSignatureSubpacketVector.getSignatureCreationTime().equals(new Date(0L))) {
            this.fail("creation of overriden date failed.");
        }
        if (!pGPSignatureSubpacketVector.hasSubpacket(33)) {
            this.fail("hasSubpacket test for issuer fingerprint");
        }
        if (!pGPSignatureSubpacketVector.hasSubpacket(35)) {
            this.fail("hasSubpacket test for intended fingerprint");
        }
        IssuerFingerprint issuerFingerprint = pGPSignatureSubpacketVector.getIssuerFingerprint();
        this.isTrue("mismatch on issuer fingerprint", Arrays.areEqual((byte[])pGPSecretKey2.getPublicKey().getFingerprint(), (byte[])issuerFingerprint.getFingerprint()));
        IntendedRecipientFingerprint intendedRecipientFingerprint = pGPSignatureSubpacketVector.getIntendedRecipientFingerprint();
        this.isTrue("mismatch on intended rec. fingerprint", Arrays.areEqual((byte[])pGPSecretKey.getPublicKey().getFingerprint(), (byte[])intendedRecipientFingerprint.getFingerprint()));
        nArray = pGPSignatureSubpacketVector.getPreferredCompressionAlgorithms();
        this.preferredAlgorithmCheck("compression", null, nArray);
        nArray = pGPSignatureSubpacketVector.getPreferredHashAlgorithms();
        this.preferredAlgorithmCheck("hash", null, nArray);
        nArray = pGPSignatureSubpacketVector.getPreferredSymmetricAlgorithms();
        this.preferredAlgorithmCheck("symmetric", null, nArray);
        if (pGPSignatureSubpacketVector.getKeyExpirationTime() != 0L) {
            this.fail("unexpected key expiration time found");
        }
        if (pGPSignatureSubpacketVector.getSignatureExpirationTime() != 0L) {
            this.fail("unexpected signature expiration time found");
        }
        if (pGPSignatureSubpacketVector.getSignerUserID() != null) {
            this.fail("unexpected signer user ID found");
        }
        if ((nArray2 = pGPSignatureSubpacketVector.getCriticalTags()).length != 0) {
            this.fail("critical packets found when none expected");
        }
        if ((pGPSignatureSubpacketVector2 = pGPSignature.getUnhashedSubPackets()).size() != 1) {
            this.fail("found wrong number of unhashed packets in override test");
        }
        this.testSig(1, 8, pGPSecretKey.getPublicKey(), pGPPrivateKey);
        this.testSig(1, 9, pGPSecretKey.getPublicKey(), pGPPrivateKey);
        this.testSig(1, 10, pGPSecretKey.getPublicKey(), pGPPrivateKey);
        this.testSigV3(1, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey);
        this.testTextSig(1, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey, TEST_DATA_WITH_CRLF, TEST_DATA_WITH_CRLF);
        this.testTextSig(1, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey, TEST_DATA, TEST_DATA_WITH_CRLF);
        this.testTextSigV3(1, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey, TEST_DATA_WITH_CRLF, TEST_DATA_WITH_CRLF);
        this.testTextSigV3(1, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey, TEST_DATA, TEST_DATA_WITH_CRLF);
        pGPSecretKeyRing = new PGPSecretKeyRing(this.dsaKeyRing, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        pGPSecretKey = pGPSecretKeyRing.getSecretKey();
        pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(this.dsaPass));
        try {
            this.testSig(1, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey);
            this.fail("DSA wrong key test failed.");
        }
        catch (PGPException pGPException) {}
        try {
            this.testSigV3(1, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey);
            this.fail("DSA V3 wrong key test failed.");
        }
        catch (PGPException pGPException) {}
        this.testSig(17, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey);
        this.testSigV3(17, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey);
        this.testTextSig(17, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey, TEST_DATA_WITH_CRLF, TEST_DATA_WITH_CRLF);
        this.testTextSig(17, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey, TEST_DATA, TEST_DATA_WITH_CRLF);
        this.testTextSigV3(17, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey, TEST_DATA_WITH_CRLF, TEST_DATA_WITH_CRLF);
        this.testTextSigV3(17, 2, pGPSecretKey.getPublicKey(), pGPPrivateKey, TEST_DATA, TEST_DATA_WITH_CRLF);
        this.testMissingSubpackets(this.nullPacketsSubKeyBinding);
        this.testMissingSubpackets(this.generateV3BinarySig(pGPPrivateKey, 17, 2));
        this.testKeyFlagsValues();
        this.testSubpacketGenerator();
        this.testSignatureTarget();
        this.testUserAttributeEncoding();
    }

    private void preferredAlgorithmCheck(String string, int[] nArray, int[] nArray2) {
        if (nArray == null) {
            if (nArray2 != null) {
                this.fail("preferences for " + string + " found when none expected");
            }
        } else {
            if (nArray2.length != nArray.length) {
                this.fail("wrong number of preferred " + string + " algorithms found");
            }
            int n = 0;
            while (n != nArray.length) {
                if (nArray[n] != nArray2[n]) {
                    this.fail("wrong algorithm found for " + string + ": expected " + nArray[n] + " got " + nArray2[n]);
                }
                ++n;
            }
        }
    }

    private void testKeyFlagsValues() {
        this.checkValue(1, 1);
        this.checkValue(2, 2);
        this.checkValue(4, 4);
        this.checkValue(8, 8);
        this.checkValue(16, 16);
        this.checkValue(32, 32);
        this.checkValue(128, 128);
        byte[] byArray = new byte[4];
        byArray[0] = 4;
        this.checkValue(byArray, 4);
        byte[] byArray2 = new byte[3];
        byArray2[0] = 4;
        this.checkValue(byArray2, 4);
        byte[] byArray3 = new byte[2];
        byArray3[0] = 4;
        this.checkValue(byArray3, 4);
        this.checkValue(new byte[]{4}, 4);
    }

    private void testMissingSubpackets(byte[] byArray) throws IOException {
        Object object;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byArray);
        Object object2 = jcaPGPObjectFactory.nextObject();
        while (!(object2 instanceof PGPSignatureList)) {
            object2 = jcaPGPObjectFactory.nextObject();
            if (!(object2 instanceof PGPLiteralData)) continue;
            object = ((PGPLiteralData)object2).getDataStream();
            Streams.drain((InputStream)object);
        }
        object = ((PGPSignatureList)object2).get(0);
        if (((PGPSignature)object).getVersion() > 3) {
            PGPSignatureSubpacketVector pGPSignatureSubpacketVector = ((PGPSignature)object).getHashedSubPackets();
            if (pGPSignatureSubpacketVector.getKeyExpirationTime() != 0L) {
                this.fail("key expiration time not zero for missing subpackets");
            }
            if (!((PGPSignature)object).hasSubpackets()) {
                this.fail("hasSubpackets() returns false with packets");
            }
        } else {
            if (((PGPSignature)object).getHashedSubPackets() != null) {
                this.fail("hashed sub packets found when none expected");
            }
            if (((PGPSignature)object).getUnhashedSubPackets() != null) {
                this.fail("unhashed sub packets found when none expected");
            }
            if (((PGPSignature)object).hasSubpackets()) {
                this.fail("hasSubpackets() returns true with no packets");
            }
        }
    }

    private void testRemoveSignature() throws IOException {
        byte[] byArray = Base64.decode((String)"mQGiBEAR8jYRBADNifuSopd20JOQ5x30ljIaY0M6927+vo09NeNxS3KqItbanz9o5e2aqdT0W1xgdHYZmdElOHTTsugZxdXTEhghyxoo3KhVcNnTABQyrrvXqouvmP2fEDEw0Vpyk+90BpyY9YlgeX/dEA8OfooRLCJde/iDTl7r9FT+mts8g3azjwCgx+pOLD9LPBF5E4FhUOdXISJ0f4EEAKXSOi9nZzajpdhe8W2ZL9gcBpzZi6AcrRZBHOEMqd69gtUxA4eD8xycUQ42yH89imEcwLz8XdJ98uHUxGJiqp6hq4oakmw8GQfiL7yQIFgaM0dOAI9Afe3m84cEYZsoAFYpB4/s9pVMpPRHNsVspU0qd3NHnSZ0QXs8L8DXGO1uBACjDUj+8GsfDCIP2QF3JC+nPUNa0Y5twKPKl+T8hX/0FBD7fnNeC6c9j5Ir/Fp/QtdaDAOoBKiyNLh1JaB1NY6US5zcqFks2seZPjXEiE6OIDXYra494mjNKGUobA4hqT2peKWXt/uBcuL1mjKOy8QfJxgEd0MOcGJO+1PFFZWGzLQ3RXJpYyBILiBFY2hpZG5hICh0ZXN0IGtleSBvbmx5KSA8ZXJpY0Bib3VuY3ljYXN0bGUub3JnPohZBBMRAgAZBQJAEfI2BAsHAwIDFQIDAxYCAQIeAQIXgAAKCRAOtk6iUOgnkDdnAKC/CfLWikSBdbngY6OK5UN3+o7q1ACcDRqjT3yjBU3WmRUNlxBg3tSuljmwAgAAuQENBEAR8jgQBAC2kr57iuOaV7Ga1xcU14MNbKcA0PVembRCjcVjei/3yVfT/fuCVtGHOmYLEBqHbn5aaJ0P/6vMbLCHKuN61NZlts+LEctfwoya43RtcubqMc7eKw4k0JnnoYgBocLXOtloCb7jfubOsnfORvrUkK0+Ne6anRhFBYfaBmGU75cQgwADBQP/XxR2qGHiwn+0YiMioRDRiIAxp6UiC/JQIri2AKSqAi0zeAMdrRsBN7kyzYVVpWwN5u13gPdQ2HnJ7d4wLWAuizUdKIQxBG8VoCxkbipnwh2RR4xCXFDhJrJFQUm+4nKx9JvAmZTBIlI5Wsi5qxst/9p5MgP3flXsNi1tRbTmRhqIRgQYEQIABgUCQBHyOAAKCRAOtk6iUOgnkBStAJoCZBVM61B1LG2xip294MZecMtCwQCbBbskJVCXP0/Szm05GB+WN+MOCT2wAgAA");
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byArray);
        PGPPublicKeyRing pGPPublicKeyRing = (PGPPublicKeyRing)jcaPGPObjectFactory.nextObject();
        Iterator iterator = pGPPublicKeyRing.getPublicKey().getSignatures();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = (PGPSignature)iterator.next();
            if (pGPSignature.getSignatureType() != 19) continue;
            PGPPublicKey.removeCertification(pGPPublicKeyRing.getPublicKey(), pGPSignature);
        }
    }

    private void testSig(int n, int n2, PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey) throws Exception {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(TEST_DATA);
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(n, n2).setProvider("BC"));
        pGPSignatureGenerator.init(0, pGPPrivateKey);
        pGPSignatureGenerator.generateOnePassVersion(false).encode(byteArrayOutputStream);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream), 'b', "_CONSOLE", TEST_DATA.length * 2, new Date());
        while ((n3 = byteArrayInputStream.read()) >= 0) {
            outputStream.write(n3);
            pGPSignatureGenerator.update((byte)n3);
        }
        outputStream.write(TEST_DATA);
        pGPSignatureGenerator.update(TEST_DATA);
        pGPLiteralDataGenerator.close();
        pGPSignatureGenerator.generate().encode(byteArrayOutputStream);
        this.verifySignature(byteArrayOutputStream.toByteArray(), n2, pGPPublicKey, TEST_DATA);
    }

    private void testSigV3(int n, int n2, PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey) throws Exception {
        byte[] byArray = this.generateV3BinarySig(pGPPrivateKey, n, n2);
        this.verifySignature(byArray, n2, pGPPublicKey, TEST_DATA);
    }

    private void testSignatureTarget() {
        byte[] byArray = Hex.decode((String)"0001020304050607080910111213141516171819");
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setSignatureTarget(true, 19, 2, byArray);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignatureSubpacketGenerator.generate();
        this.isTrue("no sig target", pGPSignatureSubpacketVector.hasSubpacket(31));
        SignatureTarget signatureTarget = pGPSignatureSubpacketVector.getSignatureTarget();
        this.isTrue("wrong critical", signatureTarget.isCritical());
        this.isTrue("wrong key alg", signatureTarget.getPublicKeyAlgorithm() == 19);
        this.isTrue("wrong hash alg", signatureTarget.getHashAlgorithm() == 2);
        this.isTrue("wrong hash data", Arrays.areEqual((byte[])byArray, (byte[])signatureTarget.getHashData()));
        pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        pGPSignatureSubpacketGenerator.setSignatureTarget(false, 3, 8, byArray);
        pGPSignatureSubpacketVector = pGPSignatureSubpacketGenerator.generate();
        signatureTarget = pGPSignatureSubpacketVector.getSignatureTarget();
        this.isTrue("wrong critical", signatureTarget.isCritical() ^ true);
        this.isTrue("wrong key alg", signatureTarget.getPublicKeyAlgorithm() == 3);
        this.isTrue("wrong hash alg", signatureTarget.getHashAlgorithm() == 8);
        this.isTrue("wrong hash data", Arrays.areEqual((byte[])byArray, (byte[])signatureTarget.getHashData()));
    }

    private void testSubpacketGenerator() throws IOException {
        block14: {
            String string;
            String string2;
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator;
            block13: {
                pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
                String string3 = this.genString(64);
                String string4 = this.genString(72);
                pGPSignatureSubpacketGenerator.addNotationData(true, true, string3, string4);
                PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignatureSubpacketGenerator.generate();
                NotationData[] notationDataArray = pGPSignatureSubpacketVector.getNotationDataOccurrences();
                if (notationDataArray.length != 1 || !notationDataArray[0].isHumanReadable()) {
                    this.fail("length and readability test 1 failed");
                }
                if (!notationDataArray[0].getNotationName().equals(string3) || !notationDataArray[0].getNotationValue().equals(string4)) {
                    this.fail("name/value test 1 failed");
                }
                String string5 = this.genString(256);
                String string6 = this.genString(264);
                pGPSignatureSubpacketGenerator.addNotationData(true, false, string5, string6);
                pGPSignatureSubpacketVector = pGPSignatureSubpacketGenerator.generate();
                notationDataArray = pGPSignatureSubpacketVector.getNotationDataOccurrences();
                if (notationDataArray.length != 2 || !notationDataArray[0].isHumanReadable() || notationDataArray[1].isHumanReadable()) {
                    this.fail("length and readability test 2 failed");
                }
                if (!notationDataArray[0].getNotationName().equals(string3) || !notationDataArray[0].getNotationValue().equals(string4)) {
                    this.fail("name/value test 2.1 failed");
                }
                if (!notationDataArray[1].getNotationName().equals(string5) || !notationDataArray[1].getNotationValue().equals(string6)) {
                    this.fail("name/value test 2.2 failed");
                }
                this.isTrue(pGPSignatureSubpacketGenerator.hasSubpacket(20));
                PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator2 = new PGPSignatureSubpacketGenerator(pGPSignatureSubpacketVector);
                SignatureSubpacket[] signatureSubpacketArray = pGPSignatureSubpacketGenerator2.getSubpackets(20);
                this.isTrue(notationDataArray[0].equals(signatureSubpacketArray[0]));
                this.isTrue(notationDataArray[1].equals(signatureSubpacketArray[1]));
                pGPSignatureSubpacketGenerator2.removePacket(notationDataArray[0]);
                signatureSubpacketArray = pGPSignatureSubpacketGenerator2.getSubpackets(20);
                this.isTrue(signatureSubpacketArray.length == 1);
                this.isTrue(notationDataArray[1].equals(signatureSubpacketArray[0]));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                notationDataArray[1].encode(byteArrayOutputStream);
                SignatureSubpacketInputStream signatureSubpacketInputStream = new SignatureSubpacketInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                this.isTrue(signatureSubpacketInputStream.readPacket().equals(signatureSubpacketArray[0]));
                PGPSignatureSubpacketVector pGPSignatureSubpacketVector2 = pGPSignatureSubpacketGenerator2.generate();
                this.isTrue(pGPSignatureSubpacketVector2.size() == 1);
                this.isTrue(pGPSignatureSubpacketVector2.getSubpackets(20)[0].equals(notationDataArray[1]));
                string2 = this.genString(65535);
                String string7 = this.genString(65535);
                pGPSignatureSubpacketGenerator.addNotationData(true, false, string2, string7);
                pGPSignatureSubpacketVector = pGPSignatureSubpacketGenerator.generate();
                notationDataArray = pGPSignatureSubpacketVector.getNotationDataOccurrences();
                if (notationDataArray.length != 3 || !notationDataArray[0].isHumanReadable() || notationDataArray[1].isHumanReadable() || notationDataArray[2].isHumanReadable()) {
                    this.fail("length and readability test 3 failed");
                }
                if (!notationDataArray[0].getNotationName().equals(string3) || !notationDataArray[0].getNotationValue().equals(string4)) {
                    this.fail("name/value test 3.1 failed");
                }
                if (!notationDataArray[1].getNotationName().equals(string5) || !notationDataArray[1].getNotationValue().equals(string6)) {
                    this.fail("name/value test 3.2 failed");
                }
                if (!notationDataArray[2].getNotationName().equals(string2) || !notationDataArray[2].getNotationValue().equals(string7)) {
                    this.fail("name/value test 3.3 failed");
                }
                String string8 = this.genString(1048561);
                string = this.genString(1048575);
                try {
                    pGPSignatureSubpacketGenerator.setNotationData(true, false, string8, string);
                    this.fail("truncation occurs silently");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("notationName exceeds maximum length.".equals(illegalArgumentException.getMessage())) break block13;
                    this.fail("wrong message");
                }
            }
            try {
                pGPSignatureSubpacketGenerator.setNotationData(true, false, string2, string);
                this.fail("truncation occurs silently");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("notationValue exceeds maximum length.".equals(illegalArgumentException.getMessage())) break block14;
                this.fail("wrong message");
            }
        }
    }

    private void testTextSig(int n, int n2, PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey, byte[] byArray, byte[] byArray2) throws Exception {
        int n3;
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(n, 2).setProvider("BC"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Date date = new Date();
        pGPSignatureGenerator.init(1, pGPPrivateKey);
        pGPSignatureGenerator.generateOnePassVersion(false).encode(byteArrayOutputStream);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream), 't', "_CONSOLE", byArray.length * 2, date);
        while ((n3 = byteArrayInputStream.read()) >= 0) {
            outputStream.write(n3);
            pGPSignatureGenerator.update((byte)n3);
        }
        outputStream.write(byArray);
        pGPSignatureGenerator.update(byArray);
        pGPLiteralDataGenerator.close();
        PGPSignature pGPSignature = pGPSignatureGenerator.generate();
        if (pGPSignature.getCreationTime().getTime() == 0L) {
            this.fail("creation time not set in v4 signature");
        }
        pGPSignature.encode(byteArrayOutputStream);
        this.verifySignature(byteArrayOutputStream.toByteArray(), n2, pGPPublicKey, byArray2);
    }

    private void testTextSigV3(int n, int n2, PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey, byte[] byArray, byte[] byArray2) throws Exception {
        int n3;
        PGPV3SignatureGenerator pGPV3SignatureGenerator = new PGPV3SignatureGenerator(new JcaPGPContentSignerBuilder(n, 2).setProvider("BC"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        pGPV3SignatureGenerator.init(1, pGPPrivateKey);
        pGPV3SignatureGenerator.generateOnePassVersion(false).encode(byteArrayOutputStream);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream = pGPLiteralDataGenerator.open((OutputStream)new UncloseableOutputStream((OutputStream)byteArrayOutputStream), 't', "_CONSOLE", byArray.length * 2, new Date());
        while ((n3 = byteArrayInputStream.read()) >= 0) {
            outputStream.write(n3);
            pGPV3SignatureGenerator.update((byte)n3);
        }
        outputStream.write(byArray);
        pGPV3SignatureGenerator.update(byArray);
        pGPLiteralDataGenerator.close();
        PGPSignature pGPSignature = pGPV3SignatureGenerator.generate();
        if (pGPSignature.getCreationTime().getTime() == 0L) {
            this.fail("creation time not set in v3 signature");
        }
        pGPSignature.encode(byteArrayOutputStream);
        this.verifySignature(byteArrayOutputStream.toByteArray(), n2, pGPPublicKey, byArray2);
    }

    private void testUserAttributeEncoding() throws Exception {
        PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(this.okAttr, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        this.checkUserAttribute("normal", pGPPublicKeyRing, pGPPublicKeyRing.getPublicKey());
        pGPPublicKeyRing = new PGPPublicKeyRing(this.attrLongLength, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        this.checkUserAttribute("long", pGPPublicKeyRing, pGPPublicKeyRing.getPublicKey());
    }

    private void verifySignature(byte[] byArray, int n, PGPPublicKey pGPPublicKey, byte[] byArray2) throws IOException, PGPException, NoSuchProviderException, SignatureException {
        Date date;
        int n2;
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(byArray);
        PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)jcaPGPObjectFactory.nextObject();
        PGPOnePassSignature pGPOnePassSignature = pGPOnePassSignatureList.get(0);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        InputStream inputStream = pGPLiteralData.getInputStream();
        pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
        while ((n2 = inputStream.read()) >= 0) {
            pGPOnePassSignature.update((byte)n2);
        }
        PGPSignatureList pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        Date date2 = pGPSignature.getCreationTime();
        if (date2.after(date = new Date()) || date2.before(new Date(date.getTime() - 600000L))) {
            this.fail("bad creation time in signature: " + date2);
        }
        if (pGPSignature.getKeyID() != pGPPublicKey.getKeyID()) {
            this.fail("key id mismatch in signature");
        }
        if (!pGPOnePassSignature.verify(pGPSignature)) {
            this.fail("Failed generated signature check - " + n);
        }
        pGPSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
        int n3 = 0;
        while (n3 != byArray2.length) {
            pGPSignature.update(byArray2[n3]);
            ++n3;
        }
        pGPSignature.update(byArray2);
        if (!pGPSignature.verify()) {
            this.fail("Failed generated signature check against original data");
        }
    }
}

