/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PGPUtilTest
extends SimpleTest {
    public String getName() {
        return "PGPUtilTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest((Test)new PGPUtilTest());
    }

    public void performTest() throws Exception {
        this.testCurveNames();
        byte[] byArray = Strings.toByteArray((String)"Hello, world!\r\nhello, World!\r\n");
        File file = File.createTempFile("bcpg", ".txt");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPUtil.writeFileToLiteralData(byteArrayOutputStream, 't', file);
        this.testLiteralData("no buf", byteArrayOutputStream.toByteArray(), file.getName(), 't', byArray);
        byteArrayOutputStream = new ByteArrayOutputStream();
        PGPUtil.writeFileToLiteralData(byteArrayOutputStream, 't', file, new byte[65536]);
        this.testLiteralData("buf", byteArrayOutputStream.toByteArray(), file.getName(), 't', byArray);
        file.delete();
    }

    private void testCurveNames() {
        this.isEquals("Curve25519", PGPUtil.getCurveName(CryptlibObjectIdentifiers.curvey25519));
        this.isEquals("Curve25519", PGPUtil.getCurveName(EdECObjectIdentifiers.id_X25519));
        this.isEquals("Ed25519", PGPUtil.getCurveName(EdECObjectIdentifiers.id_Ed25519));
        this.isEquals("NIST P-256", PGPUtil.getCurveName(SECObjectIdentifiers.secp256r1));
        this.isEquals("NIST P-384", PGPUtil.getCurveName(SECObjectIdentifiers.secp384r1));
        this.isEquals("NIST P-521", PGPUtil.getCurveName(SECObjectIdentifiers.secp521r1));
        this.isEquals("brainpoolP256r1", PGPUtil.getCurveName(TeleTrusTObjectIdentifiers.brainpoolP256r1));
        this.isEquals("brainpoolP512r1", PGPUtil.getCurveName(TeleTrusTObjectIdentifiers.brainpoolP512r1));
    }

    private void testLiteralData(String string, byte[] byArray, String string2, char c, byte[] byArray2) throws IOException {
        PGPLiteralData pGPLiteralData = new PGPLiteralData(new BCPGInputStream(new ByteArrayInputStream(byArray)));
        this.isEquals(string2, pGPLiteralData.getFileName());
        this.isTrue(c == pGPLiteralData.getFormat());
        byte[] byArray3 = Streams.readAll((InputStream)pGPLiteralData.getDataStream());
        this.isTrue(String.valueOf(string) + " contents mismatch", Arrays.areEqual((byte[])byArray3, (byte[])byArray2));
    }
}

