/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.sig.PolicyURI;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class PolicyURITest
extends SimpleTest {
    public String getName() {
        return "PolicyURITest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest((Test)new PolicyURITest());
    }

    public void performTest() throws Exception {
        this.testGetURI();
        this.testParsingFromSignature();
    }

    public void testGetURI() {
        PolicyURI policyURI = new PolicyURI(true, "https://bouncycastle.org/policy/alice.txt");
        this.isTrue(policyURI.isCritical());
        this.isEquals("https://bouncycastle.org/policy/alice.txt", policyURI.getURI());
        policyURI = new PolicyURI(false, "https://bouncycastle.org/policy/bob.txt");
        this.isTrue(policyURI.isCritical() ^ true);
        this.isEquals("https://bouncycastle.org/policy/bob.txt", policyURI.getURI());
    }

    public void testParsingFromSignature() throws IOException {
        String string = "-----BEGIN PGP SIGNATURE-----\n\niKQEHxYKAFYFAmIRIAgJEDXXpSQjWzWvFiEEVSc3S9X9kRTsyfjqNdelJCNbNa8u\nGmh0dHBzOi8vZXhhbXBsZS5vcmcvfmFsaWNlL3NpZ25pbmctcG9saWN5LnR4dAAA\nNnwBAImA2KdiS/7kLWoQpwc+A6N2PtAvLxG0gkZmGzYgRWvGAP9g4GLAA/GQ0plr\nXn7uLnOG49S1fFA9P+R1Dd8Qoa4+Dg==\n=OPUu\n-----END PGP SIGNATURE-----\n";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Strings.toByteArray((String)string));
        ArmoredInputStream armoredInputStream = new ArmoredInputStream(byteArrayInputStream);
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(armoredInputStream);
        PGPSignatureList pGPSignatureList = (PGPSignatureList)bcPGPObjectFactory.nextObject();
        PGPSignature pGPSignature = pGPSignatureList.get(0);
        PolicyURI policyURI = pGPSignature.getHashedSubPackets().getPolicyURI();
        this.isEquals("https://example.org/~alice/signing-policy.txt", policyURI.getURI());
        PolicyURI policyURI2 = new PolicyURI(false, "https://example.org/~alice/signing-policy.txt");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        policyURI.encode(byteArrayOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        policyURI2.encode(byteArrayOutputStream2);
        this.areEqual(byteArrayOutputStream.toByteArray(), byteArrayOutputStream2.toByteArray());
    }
}

