/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.util.Arrays;
import org.bouncycastle.bcpg.sig.RegularExpression;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class RegexTest
extends SimpleTest {
    public String getName() {
        return "RegexTest";
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleTest.runTest((Test)new RegexTest());
    }

    public void performTest() throws Exception {
        this.testRegexGetRegex();
        this.testRegexBytesAreNullTerminated();
        this.testCopy();
        this.testDoNotTolerateNonNullTerminatedStrings();
    }

    public void testCopy() {
        String string = "openpgp.rocks";
        RegularExpression regularExpression = new RegularExpression(false, string);
        RegularExpression regularExpression2 = new RegularExpression(regularExpression.isCritical(), regularExpression.isLongLength(), regularExpression.getData());
        this.isEquals(regularExpression.isCritical(), regularExpression2.isCritical());
        this.isEquals(regularExpression.isLongLength(), regularExpression2.isLongLength());
        this.isEquals(regularExpression.getRegex(), regularExpression2.getRegex());
        this.isTrue(Arrays.equals(regularExpression.getRawRegex(), regularExpression2.getRawRegex()));
    }

    public void testDoNotTolerateNonNullTerminatedStrings() {
        String string = "rfc.4880";
        byte[] byArray = Strings.toUTF8ByteArray((String)string);
        try {
            RegularExpression regularExpression = new RegularExpression(false, false, byArray);
            this.fail("no exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("data in regex missing null termination", illegalArgumentException.getMessage());
        }
    }

    public void testRegexBytesAreNullTerminated() {
        String string = "example.org";
        RegularExpression regularExpression = new RegularExpression(false, string);
        byte[] byArray = regularExpression.getRawRegex();
        this.isTrue(byArray[byArray.length - 1] == 0);
    }

    public void testRegexGetRegex() {
        String string = "example.org";
        RegularExpression regularExpression = new RegularExpression(false, string);
        this.isEquals(string, regularExpression.getRegex());
    }
}

