/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.operator.bc.BcPBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class RewindStreamWhenDecryptingMultiSKESKMessageTest
extends SimpleTest {
    private static final byte[] message = Strings.toByteArray((String)"Hello World!\n");

    public static byte[] decrypt(byte[] byArray, String string) throws IOException, PGPException {
        InputStream inputStream = PGPUtil.getDecoderStream(new ByteArrayInputStream(byArray));
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(inputStream);
        Object object = bcPGPObjectFactory.nextObject();
        if (object instanceof PGPEncryptedDataList) {
            PGPEncryptedDataList pGPEncryptedDataList = (PGPEncryptedDataList)object;
            Iterator iterator = pGPEncryptedDataList.iterator();
            while (iterator.hasNext()) {
                PGPEncryptedData pGPEncryptedData = (PGPEncryptedData)iterator.next();
                if (!(pGPEncryptedData instanceof PGPPBEEncryptedData)) continue;
                PGPPBEEncryptedData pGPPBEEncryptedData = (PGPPBEEncryptedData)pGPEncryptedData;
                try {
                    BcPBEDataDecryptorFactory bcPBEDataDecryptorFactory = new BcPBEDataDecryptorFactory(string.toCharArray(), new BcPGPDigestCalculatorProvider());
                    InputStream inputStream2 = pGPPBEEncryptedData.getDataStream(bcPBEDataDecryptorFactory);
                    byte[] byArray2 = RewindStreamWhenDecryptingMultiSKESKMessageTest.decryptIntern(inputStream2);
                    return byArray2;
                }
                catch (PGPException pGPException) {}
            }
        }
        throw new PGPException("Decryption failed.");
    }

    private static byte[] decryptIntern(InputStream inputStream) throws IOException {
        BcPGPObjectFactory bcPGPObjectFactory = new BcPGPObjectFactory(inputStream);
        Object object = bcPGPObjectFactory.nextObject();
        if (object instanceof PGPCompressedData) {
            PGPCompressedData pGPCompressedData = (PGPCompressedData)object;
            return RewindStreamWhenDecryptingMultiSKESKMessageTest.decryptIntern(pGPCompressedData.getInputStream());
        }
        if (object instanceof PGPLiteralData) {
            PGPLiteralData pGPLiteralData = (PGPLiteralData)object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Streams.pipeAll((InputStream)pGPLiteralData.getInputStream(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public String getName() {
        return "RewindTest";
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleTest.runTest((Test)new RewindStreamWhenDecryptingMultiSKESKMessageTest());
    }

    public void performTest() throws Exception {
        String string = "-----BEGIN PGP MESSAGE-----\nVersion: BCPG v1.68\n\njC4ECQMCtL4bq5btiMJgL6wPT4kDozGheHZa1fmAUpp3CIBeLXw4B3IUZ05QSPRF\njC4ECQMC5nZ8aoh9uYpgtDeGdkTLP+obVSiMvs99ibpcFm60vJY7feYNTiSk2StJ\n0kgB9vDAT0vUdXz1sPTEv2YIK2zeNyoA7pD9BDd68VgFVj61vSQ6Ovf6Uidv2v0M\n5cfawfKpjRn0Ku3JEzDv3TuYioRWzuzxptc=\n=9QAC\n-----END PGP MESSAGE-----\n";
        byte[] byArray = RewindStreamWhenDecryptingMultiSKESKMessageTest.decrypt(Strings.toByteArray((String)string), "password2");
        if (!Arrays.equals(message, byArray)) {
            throw new Exception("Decryption unsuccessful.");
        }
    }
}

