/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.gpg.SExprParser;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEProtectionRemoverFactory;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.Test;

public class SExprTest
extends SimpleTest {
    byte[] key1 = Base64.decode((String)"KDIxOnByb3RlY3RlZC1wcml2YXRlLWtleSgzOnJzYSgxOm4yNTc6AOpclatEWCIXSUA2y44L/jPGE1lU3d75nMN5+iJK/vXFGmQdvZWhewX2LSJ5vwpcLcQ1u3QXRbOcY0o+jRAER2vHZMEfyHfHir6QDibVTO5IOjLettW054hew/HoFbA2v3t0BB2HERWMFO6WLrC7wBVpgL85m85VhE/OmZGIOY7bapQtULoTQQ5Fwr0n+zG3gujxDcmpcTouz0DPtVLvMERnHMtJ4GEccWfiFrGUnLbBnYCnnsNoV/0mf/GseRltCnxPS2Fl+rhdkPmxC0Dkv6naV+NMiaZVk5FYdtY66xATvETv+xTaX8xHIhJc4CrR/e4T0VPBh/94o5nHL1cT6HcpKDE6ZTM6AQABKSg5OnByb3RlY3RlZDI1Om9wZW5wZ3AtczJrMy1zaGExLWFlcy1jYmMoKDQ6c2hhMTg6vqXuvvqQtUw4OjI3OTYxMzQ0KTE2OlYbNG/073BvJLzSjbvoxQYpNzM2OkcNABDegU7iUAJwVxNszEG+ackC6qk7Y+dQ6NN4Avy9pkGo+Rufs0G4yjHhVQMkH0QFWrzf5GOvsvrJQyJGVLn2amz5KxU+onNv66UVi4D3LlCOghDcGoe/V7hY+zshGN7elPhnBYbk7X1Jb5D03YrCOOCTnGLTLMc7E5qy4YSyRWMzAGGj/jkcY/B+ZEeLkTlHsnnukIMb24+1/sZrsV57AaVPRZwgzInxDGC9Tkg4j6fsHvvVw6ZDcm+ET/YGOf1dhMKEq/7GXcd5qeEpMBFi+6p2PrPJUwUHu/PIOs1SCIYlrhGRiifAHtOIdFGefo+E1v6kKZMO+FgLTeiGYN6T6vjkG7FMiWwnmamF6qNd1D5iTS2E4uiS5Z3QuwyXJfGkYYDjEmV5rVSol95Kd4wpebC7mFNbOk+zA4TB5Ytb5KN/w2lSW4btuB/pD/akfg6xJQ9BREv1vpO4CtK+d8VLCPHI7et1tKjwJNxdobw9P4HOBIPYdzbHARpAfZRLQlLRNcYp8DbHfzmDhIEPymO6+3CCtdfRE7xYc0SMpFFYGX17WGlmjdOYWtbqYrhDQ3ylzD3vrIQr12ZZXw00xSJkNk4aJ8LxSihOXTuLiHhueckfCCbkWPfdJQg1ukjRiNgHdEF+7rk/2aMDsSYULJqtjSedCDi9tLqawmCz405E+W+Htbrp2yv7ktST2IaV56JQB4Yay8WAlnngoBtdlSyAwFVFm5VrCeZ5ckdUfK1qSezd32uQlb27XCZYGiaco5AWkhBOrdPoiw4Z14Pfz6xhhV+vA+X6lm9k70iG7RO9vf3V+EAbKktFos72rGJGhWOZgv5xr8DRjbIf/dOQsgceYg4xrTzn/SjOSNmTQu++Q1Uo5jjtMozgXawJNFPKcZ28DLTxdHQla7jZK/FiiXXBL8J/VbN9DWZq7IOUMEhRym8KcAoyC7wQgpua2qhp8EXX7Qqd7dU4EcdWzzz/lF8pKDEyOnByb3RlY3RlZC1hdDE1OjIwMTgwNTI4VDAyMjIwMikpKQ==");
    byte[] key2 = Base64.decode((String)"KDIxOnByb3RlY3RlZC1wcml2YXRlLWtleSgzOnJzYSgxOm4yNTc6AOsNQU9osprkIIpmBTBTGHHDeXEZEL8UF4feaFUa9hsqdTIzX9aEaBAu3SJ3Zgzi8dMhixPsTQuAoDoUa7DxTdOD8wLgk18+X5gep3Gqs6wl5xwhr2gQ9tOJMJrHd2ylr8VBehPXKC1lc5kNClGtufjfQ+0WI56lHSh9DW1jyLGSkq8pRBZPZnaXC51qkS1wfrg5II9qqhmaxWTHAe7VIss/vQac2E6s/ITUSXxy7MtAJ0I3fGdqtAS0QXPRgyJt0ooGeGjAosyiiR8PmPf2Q0lNNfffyqu0ebTXXTakLHiVomt+VAR20tgsiJ3t8wg6j38R/NLOWOGVGPQfpDI3p08pKDE6ZTM6AQABKSg5OnByb3RlY3RlZDI1Om9wZW5wZ3AtczJrMy1zaGExLWFlcy1jYmMoKDQ6c2hhMTg6cmsVl8pPyBQ4OjI3OTYxMzQ0KTE2OnEddL6BwQQT+ZoWsHy9GFwpNzIwOpMFSLTw29ytDZsiyzVWHj/3gI7bhRtORyko6NEOQKdG8n1wHXfYxre1uiCjYW8jdYUOlcZEBKWDM4lVQeHzoF6cVbQNYy9UGY+El2d0WT92c8cmucmPKDizv9TqVY89QZTa7A/m0UmPd57b3XhkwkJvt5mOnmpyFXabtiNV1YrRUdpyeiyDwyqkHvZZ8lNixSvE2tTSuN5/xU76oFmN3JKCxw9q0WOc/gvtG31gkR7/HfvgmyZWyFjKO0vCIA0XANwFjt14umPFVGSDxNXBy3hyHHeiQJOCsBWmB1TyWSmYY7Fc2zYLoiPcBwmYvcfywAL7zFwYie9IteEx10eEHl76/iVI2qX5mUmJlzkzRlcdW2B6bjeUxP2/oPQ3XyJafW3NZ4eEvJNdJ5486Gq9uBQ4Du1yhrWzFkV9fYoI42l0Vr8oDzX66l0GJj8mZOjI7iX0IdGL5dOQyOldwv/19x3w38RnTqG/y4/hU1s3bSuXxZz6+8AgKfxIOkNFm9KLkP1Y7pfxujy6StzYhdsPLwNsBXDEMogCt9dWGNERw6urHjKuU7FyzDbq6eUjnaVjyoNwpfdodb4xGnyLgEPBqFNzQko/kvfQJncxVXz/d008qzAvb3nYqRcJJoi4wCMg+f4LA9cIqtE9UWn5NMcMIQnT+IHIzYZmZx3J9TKksFGzyK+MpIWbyTGRBEMJVW1NadI7hX6hz0jIjRkXCwCJUi8pE1aCHgsAeE7O7KPsLVPyaKL1fZHgMYPkNvP5bh8qTWRxjn0AjKbfm0q3exT/R5fBChM2FWB2fY2euUfD7f1zRbiazDpPN3REDhbzF9fE8Yn8OGrmJ3OFooESuzIhUG83CtlE1N41lSw/TFoWQmePw57XkdIGiiSAKbuQB7rMlDJ6eHFCCBFtaUy2CI2eyCdx2IIENDwe3fd+lNNgkDKXFBtWYP9OQ4MESZuL7HC4ZikoMTI6cHJvdGVjdGVkLWF0MTU6MjAxODA1MjhUMDIyMjAyKSkp");
    byte[] key3 = Base64.decode((String)"KDIxOnByb3RlY3RlZC1wcml2YXRlLWtleSgzOmVjYyg1OmN1cnZlMTU6YnJhaW5wb29sUDM4NHIxKSgxOnE5NzoEi29XCqkugtlRvONnpAVMQgfecL+Gk86Ot8LnUizfHG2TqRrtqlMg1DdU8Z8dJWmhJG84IUOURCyjt8nE4BeeCfRIbTU57CB13OqveBdNIRfK45UQnxHLO2MPVXf4GMdtKSg5OnByb3RlY3RlZDI1Om9wZW5wZ3AtczJrMy1zaGExLWFlcy1jYmMoKDQ6c2hhMTg6itLEzGV4Cfg4OjEyOTA1NDcyKTE2OgxmufENKFTZUB72+X7AwkgpMTEyOvMWNLZgaGdlTN8XCxa68ia0Xqqb9RvHgTh+iBf0RgY5Tx5hqO9fHOi76LTBMfxs9VC4f1rTketjEUKRf5amKb8lrJ67kKEsny4oRtP9ejkNzcvHFqRdxmHyL10ui8M8rJN9OU8ArqWfg22dTcKu02cpKDEyOnByb3RlY3RlZC1hdDE1OjIwMTQwNjA4VDE2MDg1MCkpKQ==");
    byte[] key4 = Base64.decode((String)"KDIxOnByb3RlY3RlZC1wcml2YXRlLWtleSgzOmRzYSgxOnAyNTc6AMHFMd60YUInMjCRGdYoRr28qY3n9g4h5IifzZLSBObcbw6ZwGf7YAkoW9WsfmIXz4OanfaDtKg+nn2ZZK5xn6Gy0XoakpZzx8NHELDzigPpQINWkPeqrZu+6fpSfPVKmMlpdwcMPrpOIwzd+DKk6neVN53g20olop4ZF2mRvOETb/9gtiyPxYplKf7PKhcyOkuzoWyD5sOoz9IFt2Si7YHzua51tHH1OdNyvzARDpwGcYZR8VUz6ByIedz4bTYFTJZ28iJKkI18lIBujmOGdwGBkLEukraatT5T9xltEbU5CS6XJ4cfvBOSLm/vWGIhLRz/o508nKxlMuDcxeeCw+cpKDE6cTMzOgDMQ4GqwbRNx1CVqtq7DL+1oJBbQrP9jMIc3nz7+RwZ8SkoMTpnMjU2Oi2foWK1Y4SQKVaK0xte8Hko17VoVNsSZl8G6KDoLG3FJwE+/yVWsIkLhIwUSpUfVqZJnKDKaHbGSmxx3PnI6Xjoc+fpF7E+Elb9/yv14aY1uGVyrOyXwU7yNX6Q1GPpxdLNwBx/SLB3/V11ZsCwfv+NBVVXZbSzNootGD6IOX4zbhQkQbFq8IGaRseajJw4iqf1Cupl3hltx+FGZeWZDXj90s0vwozo340HVkLHk7Aetiw77BOixGnAVXDklUlJ9iRQV6lsFsJXgVsWAntzDDfVOGaTw+VdM77FczWcyFif58BNHuyU+Aympx11KNRUmOYSfqAxP+IQWVDx8XvMU6spKDE6eTI1Njp4VTTwZGheAVhn7awdTdcI4F3de1TIltw4qPglMByAofC49TxadCUDWd8HeG/1MRAgGsZegOxGtmqiKS58cG6GH9KxzdC+uckOzRy4qY4KautM3diw8nzi8n2+Y+YTU+Igm+RZiPMRh/jxGLrmR74GQKAS6djk+A+IhMUhmCQFJ/Zf5s9D+BfHJ7Xjf8FkD4zpPGAosBaRIA+4ShOK6w+lTE/KC3N7ECz7KE9w0Yjxv98Vufgo+HR1sq7DywpelUOqVAQoOOXLalbefAICx70trulvpIfQ/KV55oWmLMxxVJD5MOMshEs21sto0HfowR2WFflKYKTRHv+6z9GNfiCoKSg5OnByb3RlY3RlZDI1Om9wZW5wZ3AtczJrMy1zaGExLWFlcy1jYmMoKDQ6c2hhMTg6+Uk/PB0KkKk4OjI3OTYxMzQ0KTE2OkMBz/vJA+EPamZWvQo8/7ApOTY6MdZ/lchdZNf6cUtELu7k6LarhLeAyZVs0FB4Ubz4oixL+vegLulZaQzszza/7UCFbJps9s8WbdAbIXjjUvvc3i+B/BvfnLmsa/PwVRB6xidUoejtb3Brk9fmkdA0AkUDKSgxMjpwcm90ZWN0ZWQtYXQxNToyMDE4MDYwMVQwODE2MzkpKSk=");
    byte[] key5 = Base64.decode((String)"KDIxOnByb3RlY3RlZC1wcml2YXRlLWtleSgzOmVsZygxOnAyNTc6AOoshx4Lr3OMs3bBA5fs2g+OiPWuHdLsL454IJ/MBHjUEn3IFD2HHfArsT4pBgfJHlIz9Ps0TNqWLl5oSi4I6AT3BBLgwq6+5hiQ9ag6RDoavOLHEKvDeldjYzye4fpq3FP+oTJ8aO6gyp6HQ+TujZIziZjJDvPqTBFK4es7ZaaQb+WNEr8/suh3cNkzLIpDBGlsv+1VwQHfqRax/FhAdRpRQOHPAe1dAQAr2iRLhMj2EzguWAFMXaUyV8LIbaMz0aQW0qVlarr9lYzRJUySsbVPAECKBy/AzKHOSQuBOsRWwtQY07MCAI1TX2EiKYh2yJcEwfclXrYxieOWwdVvRhMpKDE6ZzE6BSkoMTp5MjU3OgDdzHOLWfCKAiN66m374sqMEYhmC0H+4Bgt2xZ1Z5f9vADhGDtI/ngETqEUdIKPgyMsMmSS+KlgQ78AlCwvMi9NJJM3/DFQzXwr00ewGt0g0cLEXWtKJS5r8dlCB8fUFl9QKGqUgXe2+kH7Ldbbjae4D9A9AT131y25XYPjpvIiD3rh0iJSdIdsWIpxl91p4kaehMQ/Dhx+LNmt/oiy7X+Z65u8rlGtdIHgmCBeAWG12LqOjC90x4hBBrhEmOWhTOfNzhZ2FfJo/14Wup4UuHJ8Fp5q170SRurnpX4nIGkoJOoMQ1cM4/ahKvv7k4F+tK26fr2JJU7ULyrTe5Ksq9xaKSg5OnByb3RlY3RlZDI1Om9wZW5wZ3AtczJrMy1zaGExLWFlcy1jYmMoKDQ6c2hhMTg6F2rxIl6yf204OjI3OTYxMzQ0KTE2Oj7HodA1Q71ZwKGnZRpRbLIpOTY6aI8AIcRIyzUcM9KQ9XPYt3PuXK96y18qc7xaN17BHmU6t9etfiO/wu7fzn3hkkCxKcXKIhSDj4PNMCQbDVASwzdgVIDC0V/yhkRwN8CKhnCoiZ4O3NWaLwq0QGrcRtGDKSgxMjpwcm90ZWN0ZWQtYXQxNToyMDE4MDYwMVQwODE2NDApKSk=");

    public String getName() {
        return "SExprTest";
    }

    public static void main(String[] stringArray) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SimpleTest.runTest((Test)new SExprTest());
    }

    public void performTest() throws Exception {
        SExprParser sExprParser = new SExprParser(new JcaPGPDigestCalculatorProviderBuilder().build());
        PGPSecretKey pGPSecretKey = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key1), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("fred".toCharArray()), new JcaKeyFingerprintCalculator());
        PGPSecretKey pGPSecretKey2 = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key2), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("fred".toCharArray()), new JcaKeyFingerprintCalculator());
        PGPSecretKey pGPSecretKey3 = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key3), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("test".toCharArray()), new JcaKeyFingerprintCalculator());
        PGPSecretKey pGPSecretKey4 = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key4), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("fredfred".toCharArray()), new JcaKeyFingerprintCalculator());
        PGPSecretKey pGPSecretKey5 = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key5), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("fredfred".toCharArray()), new JcaKeyFingerprintCalculator());
        pGPSecretKey = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key1), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("fred".toCharArray()), pGPSecretKey.getPublicKey());
        pGPSecretKey2 = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key2), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("fred".toCharArray()), pGPSecretKey2.getPublicKey());
        pGPSecretKey3 = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key3), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("test".toCharArray()), pGPSecretKey3.getPublicKey());
        pGPSecretKey4 = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key4), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("fredfred".toCharArray()), pGPSecretKey4.getPublicKey());
        pGPSecretKey5 = sExprParser.parseSecretKey((InputStream)new ByteArrayInputStream(this.key5), (PBEProtectionRemoverFactory)new JcePBEProtectionRemoverFactory("fredfred".toCharArray()), pGPSecretKey5.getPublicKey());
        String[] stringArray = new String[]{"up1", "up2"};
        int n = 0;
        while (n != stringArray.length) {
            PGPPrivateKey pGPPrivateKey = sExprParser.parseSecretKey(((Object)((Object)this)).getClass().getResourceAsStream("/pgpdata/" + stringArray[n] + "/private-keys-v1.d/priv.key"), null, new JcaKeyFingerprintCalculator()).extractPrivateKey(null);
            ++n;
        }
    }
}

