/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DLBitString;

public class BERBitString
extends ASN1BitString {
    private static final int DEFAULT_SEGMENT_LIMIT = 1000;
    private final int segmentLimit;
    private final ASN1BitString[] elements;

    static byte[] flattenBitStrings(ASN1BitString[] aSN1BitStringArray) {
        byte[] byArray;
        int n = aSN1BitStringArray.length;
        switch (n) {
            case 0: {
                return new byte[]{0};
            }
            case 1: {
                return aSN1BitStringArray[0].contents;
            }
        }
        int n2 = n - 1;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            byArray = aSN1BitStringArray[n4].contents;
            if (byArray[0] != 0) {
                throw new IllegalArgumentException("only the last nested bitstring can have padding");
            }
            n3 += byArray.length - 1;
            ++n4;
        }
        byArray = aSN1BitStringArray[n2].contents;
        byte by = byArray[0];
        byte[] byArray2 = new byte[n3 += byArray.length];
        byArray2[0] = by;
        int n5 = 1;
        int n6 = 0;
        while (n6 < n) {
            byte[] byArray3 = aSN1BitStringArray[n6].contents;
            int n7 = byArray3.length - 1;
            System.arraycopy(byArray3, 1, byArray2, n5, n7);
            n5 += n7;
            ++n6;
        }
        return byArray2;
    }

    public BERBitString(byte[] byArray) {
        this(byArray, 0);
    }

    public BERBitString(byte by, int n) {
        super(by, n);
        this.elements = null;
        this.segmentLimit = 1000;
    }

    public BERBitString(byte[] byArray, int n) {
        this(byArray, n, 1000);
    }

    public BERBitString(byte[] byArray, int n, int n2) {
        super(byArray, n);
        this.elements = null;
        this.segmentLimit = n2;
    }

    public BERBitString(ASN1Encodable aSN1Encodable) throws IOException {
        this(aSN1Encodable.toASN1Primitive().getEncoded("DER"), 0);
    }

    public BERBitString(ASN1BitString[] aSN1BitStringArray) {
        this(aSN1BitStringArray, 1000);
    }

    public BERBitString(ASN1BitString[] aSN1BitStringArray, int n) {
        super(BERBitString.flattenBitStrings(aSN1BitStringArray), false);
        this.elements = aSN1BitStringArray;
        this.segmentLimit = n;
    }

    BERBitString(byte[] byArray, boolean bl) {
        super(byArray, bl);
        this.elements = null;
        this.segmentLimit = 1000;
    }

    boolean encodeConstructed() {
        return null != this.elements || this.contents.length > this.segmentLimit;
    }

    int encodedLength(boolean bl) throws IOException {
        int n;
        if (!this.encodeConstructed()) {
            return DLBitString.encodedLength(bl, this.contents.length);
        }
        int n2 = n = bl ? 4 : 3;
        if (null != this.elements) {
            int n3 = 0;
            while (n3 < this.elements.length) {
                n += this.elements[n3].encodedLength(true);
                ++n3;
            }
        } else if (this.contents.length >= 2) {
            int n4 = (this.contents.length - 2) / (this.segmentLimit - 1);
            n += n4 * DLBitString.encodedLength(true, this.segmentLimit);
            int n5 = this.contents.length - n4 * (this.segmentLimit - 1);
            n += DLBitString.encodedLength(true, n5);
        }
        return n;
    }

    void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        if (!this.encodeConstructed()) {
            DLBitString.encode(aSN1OutputStream, bl, this.contents, 0, this.contents.length);
            return;
        }
        aSN1OutputStream.writeIdentifier(bl, 35);
        aSN1OutputStream.write(128);
        if (null != this.elements) {
            aSN1OutputStream.writePrimitives(this.elements);
        } else if (this.contents.length >= 2) {
            byte by = this.contents[0];
            int n = this.contents.length;
            int n2 = n - 1;
            int n3 = this.segmentLimit - 1;
            while (n2 > n3) {
                DLBitString.encode(aSN1OutputStream, true, (byte)0, this.contents, n - n2, n3);
                n2 -= n3;
            }
            DLBitString.encode(aSN1OutputStream, true, by, this.contents, n - n2, n2);
        }
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }
}

