/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.util.Properties;

public class TBSCertificate
extends ASN1Object {
    ASN1Sequence seq;
    ASN1Integer version;
    ASN1Integer serialNumber;
    AlgorithmIdentifier signature;
    X500Name issuer;
    Time startDate;
    Time endDate;
    X500Name subject;
    SubjectPublicKeyInfo subjectPublicKeyInfo;
    ASN1BitString issuerUniqueId;
    ASN1BitString subjectUniqueId;
    Extensions extensions;

    public static TBSCertificate getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return TBSCertificate.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static TBSCertificate getInstance(Object object) {
        if (object instanceof TBSCertificate) {
            return (TBSCertificate)object;
        }
        if (object != null) {
            return new TBSCertificate(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private TBSCertificate(ASN1Sequence var1_1) {
        super();
        var2_2 = 0;
        this.seq = var1_1;
        if (var1_1.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.version = ASN1Integer.getInstance((ASN1TaggedObject)var1_1.getObjectAt(0), true);
        } else {
            var2_2 = -1;
            this.version = new ASN1Integer(0L);
        }
        var3_3 = false;
        var4_4 = false;
        if (this.version.hasValue(0)) {
            var3_3 = true;
        } else if (this.version.hasValue(1)) {
            var4_4 = true;
        } else if (!this.version.hasValue(2)) {
            throw new IllegalArgumentException("version number not recognised");
        }
        this.serialNumber = ASN1Integer.getInstance(var1_1.getObjectAt(var2_2 + 1));
        this.signature = AlgorithmIdentifier.getInstance(var1_1.getObjectAt(var2_2 + 2));
        this.issuer = X500Name.getInstance(var1_1.getObjectAt(var2_2 + 3));
        var5_5 = (ASN1Sequence)var1_1.getObjectAt(var2_2 + 4);
        this.startDate = Time.getInstance(var5_5.getObjectAt(0));
        this.endDate = Time.getInstance(var5_5.getObjectAt(1));
        this.subject = X500Name.getInstance(var1_1.getObjectAt(var2_2 + 5));
        this.subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(var1_1.getObjectAt(var2_2 + 6));
        var6_6 = var1_1.size() - (var2_2 + 6) - 1;
        if (var6_6 == 0 || !var3_3) ** GOTO lbl46
        throw new IllegalArgumentException("version 1 certificate contains extra data");
lbl-1000:
        // 1 sources

        {
            var7_7 = (ASN1TaggedObject)var1_1.getObjectAt(var2_2 + 6 + var6_6);
            switch (var7_7.getTagNo()) {
                case 1: {
                    this.issuerUniqueId = ASN1BitString.getInstance(var7_7, false);
                    break;
                }
                case 2: {
                    this.subjectUniqueId = ASN1BitString.getInstance(var7_7, false);
                    break;
                }
                case 3: {
                    if (var4_4) {
                        throw new IllegalArgumentException("version 2 certificate cannot contain extensions");
                    }
                    this.extensions = Extensions.getInstance(ASN1Sequence.getInstance(var7_7, true));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag encountered in structure: " + var7_7.getTagNo());
                }
            }
            --var6_6;
lbl46:
            // 2 sources

            ** while (var6_6 > 0)
        }
lbl47:
        // 1 sources

    }

    public int getVersionNumber() {
        return this.version.intValueExact() + 1;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Time getStartDate() {
        return this.startDate;
    }

    public Time getEndDate() {
        return this.endDate;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public ASN1BitString getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public ASN1BitString getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public ASN1Primitive toASN1Primitive() {
        if (Properties.getPropertyValue("org.bouncycastle.x509.allow_non-der_tbscert") != null) {
            if (Properties.isOverrideSet("org.bouncycastle.x509.allow_non-der_tbscert")) {
                return this.seq;
            }
        } else {
            return this.seq;
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (!this.version.hasValue(0)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)this.version));
        }
        aSN1EncodableVector.add(this.serialNumber);
        aSN1EncodableVector.add(this.signature);
        aSN1EncodableVector.add(this.issuer);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector(2);
        aSN1EncodableVector2.add(this.startDate);
        aSN1EncodableVector2.add(this.endDate);
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        if (this.subject != null) {
            aSN1EncodableVector.add(this.subject);
        } else {
            aSN1EncodableVector.add(new DERSequence());
        }
        aSN1EncodableVector.add(this.subjectPublicKeyInfo);
        if (this.issuerUniqueId != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.issuerUniqueId));
        }
        if (this.subjectUniqueId != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, (ASN1Encodable)this.subjectUniqueId));
        }
        if (this.extensions != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 3, (ASN1Encodable)this.extensions));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

