/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AlphabetMapper;
import org.bouncycastle.util.Integers;

public class BasicAlphabetMapper
implements AlphabetMapper {
    private Map indexMap = new HashMap();
    private Map charMap = new HashMap();

    public BasicAlphabetMapper(String string) {
        this(string.toCharArray());
    }

    public BasicAlphabetMapper(char[] cArray) {
        int n = 0;
        while (n != cArray.length) {
            if (this.indexMap.containsKey(new Character(cArray[n]))) {
                throw new IllegalArgumentException("duplicate key detected in alphabet: " + cArray[n]);
            }
            this.indexMap.put(new Character(cArray[n]), Integers.valueOf(n));
            this.charMap.put(Integers.valueOf(n), new Character(cArray[n]));
            ++n;
        }
    }

    public int getRadix() {
        return this.indexMap.size();
    }

    public byte[] convertToIndexes(char[] cArray) {
        byte[] byArray;
        if (this.indexMap.size() <= 256) {
            byArray = new byte[cArray.length];
            int n = 0;
            while (n != cArray.length) {
                byArray[n] = ((Integer)this.indexMap.get(new Character(cArray[n]))).byteValue();
                ++n;
            }
        } else {
            byArray = new byte[cArray.length * 2];
            int n = 0;
            while (n != cArray.length) {
                int n2 = (Integer)this.indexMap.get(new Character(cArray[n]));
                byArray[n * 2] = (byte)(n2 >> 8 & 0xFF);
                byArray[n * 2 + 1] = (byte)(n2 & 0xFF);
                ++n;
            }
        }
        return byArray;
    }

    public char[] convertToChars(byte[] byArray) {
        char[] cArray;
        if (this.charMap.size() <= 256) {
            cArray = new char[byArray.length];
            int n = 0;
            while (n != byArray.length) {
                cArray[n] = ((Character)this.charMap.get(Integers.valueOf(byArray[n] & 0xFF))).charValue();
                ++n;
            }
        } else {
            if ((byArray.length & 1) != 0) {
                throw new IllegalArgumentException("two byte radix and input string odd length");
            }
            cArray = new char[byArray.length / 2];
            int n = 0;
            while (n != byArray.length) {
                cArray[n / 2] = ((Character)this.charMap.get(Integers.valueOf(byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF))).charValue();
                n += 2;
            }
        }
        return cArray;
    }
}

