/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.PreCompCallback;
import org.bouncycastle.math.ec.PreCompInfo;

public class FixedPointUtil {
    public static final String PRECOMP_NAME = "bc_fixed_point";

    public static int getCombSize(ECCurve eCCurve) {
        BigInteger bigInteger = eCCurve.getOrder();
        return bigInteger == null ? eCCurve.getFieldSize() + 1 : bigInteger.bitLength();
    }

    public static FixedPointPreCompInfo getFixedPointPreCompInfo(PreCompInfo preCompInfo) {
        return preCompInfo instanceof FixedPointPreCompInfo ? (FixedPointPreCompInfo)preCompInfo : null;
    }

    public static FixedPointPreCompInfo precompute(final ECPoint eCPoint) {
        final ECCurve eCCurve = eCPoint.getCurve();
        return (FixedPointPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, new PreCompCallback(){

            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                Object object;
                int n;
                int n2;
                int n3;
                FixedPointPreCompInfo fixedPointPreCompInfo = preCompInfo instanceof FixedPointPreCompInfo ? (FixedPointPreCompInfo)preCompInfo : null;
                if (this.checkExisting(fixedPointPreCompInfo, n3 = 1 << (n2 = (n = FixedPointUtil.getCombSize(eCCurve)) > 250 ? 6 : 5))) {
                    return fixedPointPreCompInfo;
                }
                int n4 = (n + n2 - 1) / n2;
                ECPoint[] eCPointArray = new ECPoint[n2 + 1];
                eCPointArray[0] = eCPoint;
                int n5 = 1;
                while (n5 < n2) {
                    eCPointArray[n5] = eCPointArray[n5 - 1].timesPow2(n4);
                    ++n5;
                }
                eCPointArray[n2] = eCPointArray[0].subtract(eCPointArray[1]);
                eCCurve.normalizeAll(eCPointArray);
                ECPoint[] eCPointArray2 = new ECPoint[n3];
                eCPointArray2[0] = eCPointArray[0];
                int n6 = n2 - 1;
                while (n6 >= 0) {
                    int n7;
                    object = eCPointArray[n6];
                    int n8 = n7 = 1 << n6;
                    while (n8 < n3) {
                        eCPointArray2[n8] = eCPointArray2[n8 - n7].add((ECPoint)object);
                        n8 += n7 << 1;
                    }
                    --n6;
                }
                eCCurve.normalizeAll(eCPointArray2);
                object = new FixedPointPreCompInfo();
                ((FixedPointPreCompInfo)object).setLookupTable(eCCurve.createCacheSafeLookupTable(eCPointArray2, 0, eCPointArray2.length));
                ((FixedPointPreCompInfo)object).setOffset(eCPointArray[n2]);
                ((FixedPointPreCompInfo)object).setWidth(n2);
                return object;
            }

            private boolean checkExisting(FixedPointPreCompInfo fixedPointPreCompInfo, int n) {
                return fixedPointPreCompInfo != null && this.checkTable(fixedPointPreCompInfo.getLookupTable(), n);
            }

            private boolean checkTable(ECLookupTable eCLookupTable, int n) {
                return eCLookupTable != null && eCLookupTable.getSize() >= n;
            }
        });
    }
}

