/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.AbstractECLookupTable;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecT283FieldElement;
import org.bouncycastle.math.ec.custom.sec.SecT283R1Point;
import org.bouncycastle.math.raw.Nat320;
import org.bouncycastle.util.encoders.Hex;

public class SecT283R1Curve
extends ECCurve.AbstractF2m {
    private static final int SECT283R1_DEFAULT_COORDS = 6;
    private static final ECFieldElement[] SECT283R1_AFFINE_ZS = new ECFieldElement[]{new SecT283FieldElement(ECConstants.ONE)};
    protected SecT283R1Point infinity = new SecT283R1Point(this, null, null);

    public SecT283R1Curve() {
        super(283, 5, 7, 12);
        this.a = this.fromBigInteger(BigInteger.valueOf(1L));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decodeStrict("027B680AC8B8596DA5A4AF8A19A0303FCA97FD7645309FA2A581485AF6263E313B79A2F5")));
        this.order = new BigInteger(1, Hex.decodeStrict("03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF90399660FC938A90165B042A7CEFADB307"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT283R1Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 283;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT283FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecT283R1Point(this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecT283R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }

    public int getM() {
        return 283;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 5;
    }

    public int getK2() {
        return 7;
    }

    public int getK3() {
        return 12;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final long[] lArray = new long[n2 * 5 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            ECPoint eCPoint = eCPointArray[n + n4];
            Nat320.copy64(((SecT283FieldElement)eCPoint.getRawXCoord()).x, 0, lArray, n3);
            Nat320.copy64(((SecT283FieldElement)eCPoint.getRawYCoord()).x, 0, lArray, n3 += 5);
            n3 += 5;
            ++n4;
        }
        return new AbstractECLookupTable(){

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                long[] lArray3 = Nat320.create64();
                long[] lArray2 = Nat320.create64();
                int n22 = 0;
                int n3 = 0;
                while (n3 < n2) {
                    long l = (n3 ^ n) - 1 >> 31;
                    int n4 = 0;
                    while (n4 < 5) {
                        int n5 = n4;
                        lArray3[n5] = lArray3[n5] ^ lArray[n22 + n4] & l;
                        int n6 = n4;
                        lArray2[n6] = lArray2[n6] ^ lArray[n22 + 5 + n4] & l;
                        ++n4;
                    }
                    n22 += 10;
                    ++n3;
                }
                return this.createPoint(lArray3, lArray2);
            }

            public ECPoint lookupVar(int n) {
                long[] lArray3 = Nat320.create64();
                long[] lArray2 = Nat320.create64();
                int n22 = n * 5 * 2;
                int n3 = 0;
                while (n3 < 5) {
                    lArray3[n3] = lArray[n22 + n3];
                    lArray2[n3] = lArray[n22 + 5 + n3];
                    ++n3;
                }
                return this.createPoint(lArray3, lArray2);
            }

            private ECPoint createPoint(long[] lArray3, long[] lArray2) {
                return SecT283R1Curve.this.createRawPoint(new SecT283FieldElement(lArray3), new SecT283FieldElement(lArray2), SECT283R1_AFFINE_ZS);
            }
        };
    }
}

