/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.tools;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.util.Integers;

public class TraceOptimizer {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final SecureRandom R = new SecureRandom();

    public static void main(String[] stringArray) {
        TreeSet treeSet = new TreeSet(TraceOptimizer.enumToList(ECNamedCurveTable.getNames()));
        treeSet.addAll(TraceOptimizer.enumToList(CustomNamedCurves.getNames()));
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ECCurve eCCurve;
            String string = (String)iterator.next();
            X9ECParametersHolder x9ECParametersHolder = CustomNamedCurves.getByNameLazy(string);
            if (x9ECParametersHolder == null) {
                x9ECParametersHolder = ECNamedCurveTable.getByNameLazy(string);
            }
            if (x9ECParametersHolder == null || !ECAlgorithms.isF2mCurve(eCCurve = x9ECParametersHolder.getCurve())) continue;
            System.out.print(string + ":");
            TraceOptimizer.implPrintNonZeroTraceBits(eCCurve);
        }
    }

    public static void printNonZeroTraceBits(ECCurve eCCurve) {
        if (!ECAlgorithms.isF2mCurve(eCCurve)) {
            throw new IllegalArgumentException("Trace only defined over characteristic-2 fields");
        }
        TraceOptimizer.implPrintNonZeroTraceBits(eCCurve);
    }

    public static void implPrintNonZeroTraceBits(ECCurve eCCurve) {
        int n;
        ECFieldElement eCFieldElement;
        BigInteger bigInteger;
        int n2 = eCCurve.getFieldSize();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 0;
        while (n3 < n2) {
            if (0 == (n3 & 1) && 0 != n3) {
                if (arrayList.contains(Integers.valueOf(n3 >>> 1))) {
                    arrayList.add(Integers.valueOf(n3));
                    System.out.print(" " + n3);
                }
            } else {
                bigInteger = ONE.shiftLeft(n3);
                eCFieldElement = eCCurve.fromBigInteger(bigInteger);
                n = TraceOptimizer.calculateTrace(eCFieldElement);
                if (n != 0) {
                    arrayList.add(Integers.valueOf(n3));
                    System.out.print(" " + n3);
                }
            }
            ++n3;
        }
        System.out.println();
        n3 = 0;
        while (n3 < 1000) {
            bigInteger = new BigInteger(n2, R);
            eCFieldElement = eCCurve.fromBigInteger(bigInteger);
            n = TraceOptimizer.calculateTrace(eCFieldElement);
            int n4 = 0;
            int n5 = 0;
            while (n5 < arrayList.size()) {
                int n6 = (Integer)arrayList.get(n5);
                if (bigInteger.testBit(n6)) {
                    n4 ^= 1;
                }
                ++n5;
            }
            if (n != n4) {
                throw new IllegalStateException("Optimized-trace sanity check failed");
            }
            ++n3;
        }
    }

    private static int calculateTrace(ECFieldElement eCFieldElement) {
        int n = eCFieldElement.getFieldSize();
        int n2 = 31 - Integers.numberOfLeadingZeros(n);
        int n3 = 1;
        ECFieldElement eCFieldElement2 = eCFieldElement;
        while (n2 > 0) {
            eCFieldElement2 = eCFieldElement2.squarePow(n3).add(eCFieldElement2);
            if (0 == ((n3 = n >>> --n2) & 1)) continue;
            eCFieldElement2 = eCFieldElement2.square().add(eCFieldElement);
        }
        if (eCFieldElement2.isZero()) {
            return 0;
        }
        if (eCFieldElement2.isOne()) {
            return 1;
        }
        throw new IllegalStateException("Internal error in trace calculation");
    }

    private static ArrayList enumToList(Enumeration enumeration) {
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }
}

