/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import javax.security.auth.Destroyable;
import org.bouncycastle.util.Arrays;

public class HybridValueParameterSpec
implements AlgorithmParameterSpec,
Destroyable {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private volatile byte[] t;
    private volatile AlgorithmParameterSpec baseSpec;

    public HybridValueParameterSpec(byte[] t, AlgorithmParameterSpec baseSpec) {
        this.t = t;
        this.baseSpec = baseSpec;
    }

    public byte[] getT() {
        this.checkDestroyed();
        return this.t;
    }

    public AlgorithmParameterSpec getBaseParameterSpec() {
        this.checkDestroyed();
        return this.baseSpec;
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            Arrays.clear(this.t);
            this.t = null;
            this.baseSpec = null;
        }
    }

    private void checkDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("spec has been destroyed");
        }
    }

    private static class AtomicBoolean {
        private volatile boolean value;

        AtomicBoolean(boolean value) {
            this.value = value;
        }

        public synchronized void set(boolean value) {
            this.value = value;
        }

        public synchronized boolean getAndSet(boolean value) {
            boolean tmp = this.value;
            this.value = value;
            return tmp;
        }

        public synchronized boolean get() {
            return this.value;
        }
    }
}

