/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.engines.SerpentEngineBase;
import org.bouncycastle.util.Pack;

public final class TnepresEngine
extends SerpentEngineBase {
    @Override
    public String getAlgorithmName() {
        return "Tnepres";
    }

    @Override
    protected int[] makeWorkingKey(byte[] key) throws IllegalArgumentException {
        int i;
        int[] kPad = new int[16];
        int off = 0;
        int length = 0;
        for (off = key.length - 4; off > 0; off -= 4) {
            kPad[length++] = Pack.bigEndianToInt(key, off);
        }
        if (off == 0) {
            kPad[length++] = Pack.bigEndianToInt(key, 0);
            if (length < 8) {
                kPad[length] = 1;
            }
        } else {
            throw new IllegalArgumentException("key must be a multiple of 4 bytes");
        }
        int amount = 132;
        int[] w = new int[amount];
        for (i = 8; i < 16; ++i) {
            kPad[i] = TnepresEngine.rotateLeft(kPad[i - 8] ^ kPad[i - 5] ^ kPad[i - 3] ^ kPad[i - 1] ^ 0x9E3779B9 ^ i - 8, 11);
        }
        System.arraycopy(kPad, 8, w, 0, 8);
        for (i = 8; i < amount; ++i) {
            w[i] = TnepresEngine.rotateLeft(w[i - 8] ^ w[i - 5] ^ w[i - 3] ^ w[i - 1] ^ 0x9E3779B9 ^ i, 11);
        }
        int[] X = new int[4];
        this.sb3(X, w[0], w[1], w[2], w[3]);
        w[0] = X[0];
        w[1] = X[1];
        w[2] = X[2];
        w[3] = X[3];
        this.sb2(X, w[4], w[5], w[6], w[7]);
        w[4] = X[0];
        w[5] = X[1];
        w[6] = X[2];
        w[7] = X[3];
        this.sb1(X, w[8], w[9], w[10], w[11]);
        w[8] = X[0];
        w[9] = X[1];
        w[10] = X[2];
        w[11] = X[3];
        this.sb0(X, w[12], w[13], w[14], w[15]);
        w[12] = X[0];
        w[13] = X[1];
        w[14] = X[2];
        w[15] = X[3];
        this.sb7(X, w[16], w[17], w[18], w[19]);
        w[16] = X[0];
        w[17] = X[1];
        w[18] = X[2];
        w[19] = X[3];
        this.sb6(X, w[20], w[21], w[22], w[23]);
        w[20] = X[0];
        w[21] = X[1];
        w[22] = X[2];
        w[23] = X[3];
        this.sb5(X, w[24], w[25], w[26], w[27]);
        w[24] = X[0];
        w[25] = X[1];
        w[26] = X[2];
        w[27] = X[3];
        this.sb4(X, w[28], w[29], w[30], w[31]);
        w[28] = X[0];
        w[29] = X[1];
        w[30] = X[2];
        w[31] = X[3];
        this.sb3(X, w[32], w[33], w[34], w[35]);
        w[32] = X[0];
        w[33] = X[1];
        w[34] = X[2];
        w[35] = X[3];
        this.sb2(X, w[36], w[37], w[38], w[39]);
        w[36] = X[0];
        w[37] = X[1];
        w[38] = X[2];
        w[39] = X[3];
        this.sb1(X, w[40], w[41], w[42], w[43]);
        w[40] = X[0];
        w[41] = X[1];
        w[42] = X[2];
        w[43] = X[3];
        this.sb0(X, w[44], w[45], w[46], w[47]);
        w[44] = X[0];
        w[45] = X[1];
        w[46] = X[2];
        w[47] = X[3];
        this.sb7(X, w[48], w[49], w[50], w[51]);
        w[48] = X[0];
        w[49] = X[1];
        w[50] = X[2];
        w[51] = X[3];
        this.sb6(X, w[52], w[53], w[54], w[55]);
        w[52] = X[0];
        w[53] = X[1];
        w[54] = X[2];
        w[55] = X[3];
        this.sb5(X, w[56], w[57], w[58], w[59]);
        w[56] = X[0];
        w[57] = X[1];
        w[58] = X[2];
        w[59] = X[3];
        this.sb4(X, w[60], w[61], w[62], w[63]);
        w[60] = X[0];
        w[61] = X[1];
        w[62] = X[2];
        w[63] = X[3];
        this.sb3(X, w[64], w[65], w[66], w[67]);
        w[64] = X[0];
        w[65] = X[1];
        w[66] = X[2];
        w[67] = X[3];
        this.sb2(X, w[68], w[69], w[70], w[71]);
        w[68] = X[0];
        w[69] = X[1];
        w[70] = X[2];
        w[71] = X[3];
        this.sb1(X, w[72], w[73], w[74], w[75]);
        w[72] = X[0];
        w[73] = X[1];
        w[74] = X[2];
        w[75] = X[3];
        this.sb0(X, w[76], w[77], w[78], w[79]);
        w[76] = X[0];
        w[77] = X[1];
        w[78] = X[2];
        w[79] = X[3];
        this.sb7(X, w[80], w[81], w[82], w[83]);
        w[80] = X[0];
        w[81] = X[1];
        w[82] = X[2];
        w[83] = X[3];
        this.sb6(X, w[84], w[85], w[86], w[87]);
        w[84] = X[0];
        w[85] = X[1];
        w[86] = X[2];
        w[87] = X[3];
        this.sb5(X, w[88], w[89], w[90], w[91]);
        w[88] = X[0];
        w[89] = X[1];
        w[90] = X[2];
        w[91] = X[3];
        this.sb4(X, w[92], w[93], w[94], w[95]);
        w[92] = X[0];
        w[93] = X[1];
        w[94] = X[2];
        w[95] = X[3];
        this.sb3(X, w[96], w[97], w[98], w[99]);
        w[96] = X[0];
        w[97] = X[1];
        w[98] = X[2];
        w[99] = X[3];
        this.sb2(X, w[100], w[101], w[102], w[103]);
        w[100] = X[0];
        w[101] = X[1];
        w[102] = X[2];
        w[103] = X[3];
        this.sb1(X, w[104], w[105], w[106], w[107]);
        w[104] = X[0];
        w[105] = X[1];
        w[106] = X[2];
        w[107] = X[3];
        this.sb0(X, w[108], w[109], w[110], w[111]);
        w[108] = X[0];
        w[109] = X[1];
        w[110] = X[2];
        w[111] = X[3];
        this.sb7(X, w[112], w[113], w[114], w[115]);
        w[112] = X[0];
        w[113] = X[1];
        w[114] = X[2];
        w[115] = X[3];
        this.sb6(X, w[116], w[117], w[118], w[119]);
        w[116] = X[0];
        w[117] = X[1];
        w[118] = X[2];
        w[119] = X[3];
        this.sb5(X, w[120], w[121], w[122], w[123]);
        w[120] = X[0];
        w[121] = X[1];
        w[122] = X[2];
        w[123] = X[3];
        this.sb4(X, w[124], w[125], w[126], w[127]);
        w[124] = X[0];
        w[125] = X[1];
        w[126] = X[2];
        w[127] = X[3];
        this.sb3(X, w[128], w[129], w[130], w[131]);
        w[128] = X[0];
        w[129] = X[1];
        w[130] = X[2];
        w[131] = X[3];
        return w;
    }

    @Override
    protected void encryptBlock(byte[] input, int inOff, byte[] output, int outOff) {
        int[] X = new int[4];
        X[3] = Pack.bigEndianToInt(input, inOff);
        X[2] = Pack.bigEndianToInt(input, inOff + 4);
        X[1] = Pack.bigEndianToInt(input, inOff + 8);
        X[0] = Pack.bigEndianToInt(input, inOff + 12);
        this.sb0(X, this.wKey[0] ^ X[0], this.wKey[1] ^ X[1], this.wKey[2] ^ X[2], this.wKey[3] ^ X[3]);
        this.LT(X);
        this.sb1(X, this.wKey[4] ^ X[0], this.wKey[5] ^ X[1], this.wKey[6] ^ X[2], this.wKey[7] ^ X[3]);
        this.LT(X);
        this.sb2(X, this.wKey[8] ^ X[0], this.wKey[9] ^ X[1], this.wKey[10] ^ X[2], this.wKey[11] ^ X[3]);
        this.LT(X);
        this.sb3(X, this.wKey[12] ^ X[0], this.wKey[13] ^ X[1], this.wKey[14] ^ X[2], this.wKey[15] ^ X[3]);
        this.LT(X);
        this.sb4(X, this.wKey[16] ^ X[0], this.wKey[17] ^ X[1], this.wKey[18] ^ X[2], this.wKey[19] ^ X[3]);
        this.LT(X);
        this.sb5(X, this.wKey[20] ^ X[0], this.wKey[21] ^ X[1], this.wKey[22] ^ X[2], this.wKey[23] ^ X[3]);
        this.LT(X);
        this.sb6(X, this.wKey[24] ^ X[0], this.wKey[25] ^ X[1], this.wKey[26] ^ X[2], this.wKey[27] ^ X[3]);
        this.LT(X);
        this.sb7(X, this.wKey[28] ^ X[0], this.wKey[29] ^ X[1], this.wKey[30] ^ X[2], this.wKey[31] ^ X[3]);
        this.LT(X);
        this.sb0(X, this.wKey[32] ^ X[0], this.wKey[33] ^ X[1], this.wKey[34] ^ X[2], this.wKey[35] ^ X[3]);
        this.LT(X);
        this.sb1(X, this.wKey[36] ^ X[0], this.wKey[37] ^ X[1], this.wKey[38] ^ X[2], this.wKey[39] ^ X[3]);
        this.LT(X);
        this.sb2(X, this.wKey[40] ^ X[0], this.wKey[41] ^ X[1], this.wKey[42] ^ X[2], this.wKey[43] ^ X[3]);
        this.LT(X);
        this.sb3(X, this.wKey[44] ^ X[0], this.wKey[45] ^ X[1], this.wKey[46] ^ X[2], this.wKey[47] ^ X[3]);
        this.LT(X);
        this.sb4(X, this.wKey[48] ^ X[0], this.wKey[49] ^ X[1], this.wKey[50] ^ X[2], this.wKey[51] ^ X[3]);
        this.LT(X);
        this.sb5(X, this.wKey[52] ^ X[0], this.wKey[53] ^ X[1], this.wKey[54] ^ X[2], this.wKey[55] ^ X[3]);
        this.LT(X);
        this.sb6(X, this.wKey[56] ^ X[0], this.wKey[57] ^ X[1], this.wKey[58] ^ X[2], this.wKey[59] ^ X[3]);
        this.LT(X);
        this.sb7(X, this.wKey[60] ^ X[0], this.wKey[61] ^ X[1], this.wKey[62] ^ X[2], this.wKey[63] ^ X[3]);
        this.LT(X);
        this.sb0(X, this.wKey[64] ^ X[0], this.wKey[65] ^ X[1], this.wKey[66] ^ X[2], this.wKey[67] ^ X[3]);
        this.LT(X);
        this.sb1(X, this.wKey[68] ^ X[0], this.wKey[69] ^ X[1], this.wKey[70] ^ X[2], this.wKey[71] ^ X[3]);
        this.LT(X);
        this.sb2(X, this.wKey[72] ^ X[0], this.wKey[73] ^ X[1], this.wKey[74] ^ X[2], this.wKey[75] ^ X[3]);
        this.LT(X);
        this.sb3(X, this.wKey[76] ^ X[0], this.wKey[77] ^ X[1], this.wKey[78] ^ X[2], this.wKey[79] ^ X[3]);
        this.LT(X);
        this.sb4(X, this.wKey[80] ^ X[0], this.wKey[81] ^ X[1], this.wKey[82] ^ X[2], this.wKey[83] ^ X[3]);
        this.LT(X);
        this.sb5(X, this.wKey[84] ^ X[0], this.wKey[85] ^ X[1], this.wKey[86] ^ X[2], this.wKey[87] ^ X[3]);
        this.LT(X);
        this.sb6(X, this.wKey[88] ^ X[0], this.wKey[89] ^ X[1], this.wKey[90] ^ X[2], this.wKey[91] ^ X[3]);
        this.LT(X);
        this.sb7(X, this.wKey[92] ^ X[0], this.wKey[93] ^ X[1], this.wKey[94] ^ X[2], this.wKey[95] ^ X[3]);
        this.LT(X);
        this.sb0(X, this.wKey[96] ^ X[0], this.wKey[97] ^ X[1], this.wKey[98] ^ X[2], this.wKey[99] ^ X[3]);
        this.LT(X);
        this.sb1(X, this.wKey[100] ^ X[0], this.wKey[101] ^ X[1], this.wKey[102] ^ X[2], this.wKey[103] ^ X[3]);
        this.LT(X);
        this.sb2(X, this.wKey[104] ^ X[0], this.wKey[105] ^ X[1], this.wKey[106] ^ X[2], this.wKey[107] ^ X[3]);
        this.LT(X);
        this.sb3(X, this.wKey[108] ^ X[0], this.wKey[109] ^ X[1], this.wKey[110] ^ X[2], this.wKey[111] ^ X[3]);
        this.LT(X);
        this.sb4(X, this.wKey[112] ^ X[0], this.wKey[113] ^ X[1], this.wKey[114] ^ X[2], this.wKey[115] ^ X[3]);
        this.LT(X);
        this.sb5(X, this.wKey[116] ^ X[0], this.wKey[117] ^ X[1], this.wKey[118] ^ X[2], this.wKey[119] ^ X[3]);
        this.LT(X);
        this.sb6(X, this.wKey[120] ^ X[0], this.wKey[121] ^ X[1], this.wKey[122] ^ X[2], this.wKey[123] ^ X[3]);
        this.LT(X);
        this.sb7(X, this.wKey[124] ^ X[0], this.wKey[125] ^ X[1], this.wKey[126] ^ X[2], this.wKey[127] ^ X[3]);
        Pack.intToBigEndian(this.wKey[131] ^ X[3], output, outOff);
        Pack.intToBigEndian(this.wKey[130] ^ X[2], output, outOff + 4);
        Pack.intToBigEndian(this.wKey[129] ^ X[1], output, outOff + 8);
        Pack.intToBigEndian(this.wKey[128] ^ X[0], output, outOff + 12);
    }

    @Override
    protected void decryptBlock(byte[] input, int inOff, byte[] output, int outOff) {
        int[] X = new int[4];
        X[3] = this.wKey[131] ^ Pack.bigEndianToInt(input, inOff);
        X[2] = this.wKey[130] ^ Pack.bigEndianToInt(input, inOff + 4);
        X[1] = this.wKey[129] ^ Pack.bigEndianToInt(input, inOff + 8);
        X[0] = this.wKey[128] ^ Pack.bigEndianToInt(input, inOff + 12);
        this.ib7(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[124];
        X[1] = X[1] ^ this.wKey[125];
        X[2] = X[2] ^ this.wKey[126];
        X[3] = X[3] ^ this.wKey[127];
        this.inverseLT(X);
        this.ib6(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[120];
        X[1] = X[1] ^ this.wKey[121];
        X[2] = X[2] ^ this.wKey[122];
        X[3] = X[3] ^ this.wKey[123];
        this.inverseLT(X);
        this.ib5(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[116];
        X[1] = X[1] ^ this.wKey[117];
        X[2] = X[2] ^ this.wKey[118];
        X[3] = X[3] ^ this.wKey[119];
        this.inverseLT(X);
        this.ib4(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[112];
        X[1] = X[1] ^ this.wKey[113];
        X[2] = X[2] ^ this.wKey[114];
        X[3] = X[3] ^ this.wKey[115];
        this.inverseLT(X);
        this.ib3(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[108];
        X[1] = X[1] ^ this.wKey[109];
        X[2] = X[2] ^ this.wKey[110];
        X[3] = X[3] ^ this.wKey[111];
        this.inverseLT(X);
        this.ib2(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[104];
        X[1] = X[1] ^ this.wKey[105];
        X[2] = X[2] ^ this.wKey[106];
        X[3] = X[3] ^ this.wKey[107];
        this.inverseLT(X);
        this.ib1(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[100];
        X[1] = X[1] ^ this.wKey[101];
        X[2] = X[2] ^ this.wKey[102];
        X[3] = X[3] ^ this.wKey[103];
        this.inverseLT(X);
        this.ib0(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[96];
        X[1] = X[1] ^ this.wKey[97];
        X[2] = X[2] ^ this.wKey[98];
        X[3] = X[3] ^ this.wKey[99];
        this.inverseLT(X);
        this.ib7(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[92];
        X[1] = X[1] ^ this.wKey[93];
        X[2] = X[2] ^ this.wKey[94];
        X[3] = X[3] ^ this.wKey[95];
        this.inverseLT(X);
        this.ib6(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[88];
        X[1] = X[1] ^ this.wKey[89];
        X[2] = X[2] ^ this.wKey[90];
        X[3] = X[3] ^ this.wKey[91];
        this.inverseLT(X);
        this.ib5(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[84];
        X[1] = X[1] ^ this.wKey[85];
        X[2] = X[2] ^ this.wKey[86];
        X[3] = X[3] ^ this.wKey[87];
        this.inverseLT(X);
        this.ib4(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[80];
        X[1] = X[1] ^ this.wKey[81];
        X[2] = X[2] ^ this.wKey[82];
        X[3] = X[3] ^ this.wKey[83];
        this.inverseLT(X);
        this.ib3(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[76];
        X[1] = X[1] ^ this.wKey[77];
        X[2] = X[2] ^ this.wKey[78];
        X[3] = X[3] ^ this.wKey[79];
        this.inverseLT(X);
        this.ib2(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[72];
        X[1] = X[1] ^ this.wKey[73];
        X[2] = X[2] ^ this.wKey[74];
        X[3] = X[3] ^ this.wKey[75];
        this.inverseLT(X);
        this.ib1(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[68];
        X[1] = X[1] ^ this.wKey[69];
        X[2] = X[2] ^ this.wKey[70];
        X[3] = X[3] ^ this.wKey[71];
        this.inverseLT(X);
        this.ib0(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[64];
        X[1] = X[1] ^ this.wKey[65];
        X[2] = X[2] ^ this.wKey[66];
        X[3] = X[3] ^ this.wKey[67];
        this.inverseLT(X);
        this.ib7(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[60];
        X[1] = X[1] ^ this.wKey[61];
        X[2] = X[2] ^ this.wKey[62];
        X[3] = X[3] ^ this.wKey[63];
        this.inverseLT(X);
        this.ib6(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[56];
        X[1] = X[1] ^ this.wKey[57];
        X[2] = X[2] ^ this.wKey[58];
        X[3] = X[3] ^ this.wKey[59];
        this.inverseLT(X);
        this.ib5(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[52];
        X[1] = X[1] ^ this.wKey[53];
        X[2] = X[2] ^ this.wKey[54];
        X[3] = X[3] ^ this.wKey[55];
        this.inverseLT(X);
        this.ib4(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[48];
        X[1] = X[1] ^ this.wKey[49];
        X[2] = X[2] ^ this.wKey[50];
        X[3] = X[3] ^ this.wKey[51];
        this.inverseLT(X);
        this.ib3(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[44];
        X[1] = X[1] ^ this.wKey[45];
        X[2] = X[2] ^ this.wKey[46];
        X[3] = X[3] ^ this.wKey[47];
        this.inverseLT(X);
        this.ib2(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[40];
        X[1] = X[1] ^ this.wKey[41];
        X[2] = X[2] ^ this.wKey[42];
        X[3] = X[3] ^ this.wKey[43];
        this.inverseLT(X);
        this.ib1(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[36];
        X[1] = X[1] ^ this.wKey[37];
        X[2] = X[2] ^ this.wKey[38];
        X[3] = X[3] ^ this.wKey[39];
        this.inverseLT(X);
        this.ib0(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[32];
        X[1] = X[1] ^ this.wKey[33];
        X[2] = X[2] ^ this.wKey[34];
        X[3] = X[3] ^ this.wKey[35];
        this.inverseLT(X);
        this.ib7(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[28];
        X[1] = X[1] ^ this.wKey[29];
        X[2] = X[2] ^ this.wKey[30];
        X[3] = X[3] ^ this.wKey[31];
        this.inverseLT(X);
        this.ib6(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[24];
        X[1] = X[1] ^ this.wKey[25];
        X[2] = X[2] ^ this.wKey[26];
        X[3] = X[3] ^ this.wKey[27];
        this.inverseLT(X);
        this.ib5(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[20];
        X[1] = X[1] ^ this.wKey[21];
        X[2] = X[2] ^ this.wKey[22];
        X[3] = X[3] ^ this.wKey[23];
        this.inverseLT(X);
        this.ib4(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[16];
        X[1] = X[1] ^ this.wKey[17];
        X[2] = X[2] ^ this.wKey[18];
        X[3] = X[3] ^ this.wKey[19];
        this.inverseLT(X);
        this.ib3(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[12];
        X[1] = X[1] ^ this.wKey[13];
        X[2] = X[2] ^ this.wKey[14];
        X[3] = X[3] ^ this.wKey[15];
        this.inverseLT(X);
        this.ib2(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[8];
        X[1] = X[1] ^ this.wKey[9];
        X[2] = X[2] ^ this.wKey[10];
        X[3] = X[3] ^ this.wKey[11];
        this.inverseLT(X);
        this.ib1(X, X[0], X[1], X[2], X[3]);
        X[0] = X[0] ^ this.wKey[4];
        X[1] = X[1] ^ this.wKey[5];
        X[2] = X[2] ^ this.wKey[6];
        X[3] = X[3] ^ this.wKey[7];
        this.inverseLT(X);
        this.ib0(X, X[0], X[1], X[2], X[3]);
        Pack.intToBigEndian(X[3] ^ this.wKey[3], output, outOff);
        Pack.intToBigEndian(X[2] ^ this.wKey[2], output, outOff + 4);
        Pack.intToBigEndian(X[1] ^ this.wKey[1], output, outOff + 8);
        Pack.intToBigEndian(X[0] ^ this.wKey[0], output, outOff + 12);
    }

    @Override
    public BlockCipher newInstance() {
        return new TnepresEngine();
    }
}

