/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.util.ArrayList;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.ers.ERSRootNodeCalculator;
import org.bouncycastle.tsp.ers.ERSUtil;

public class BinaryTreeRootCalculator
implements ERSRootNodeCalculator {
    public byte[] computeRootHash(DigestCalculator digCalc, PartialHashtree[] nodes) {
        ArrayList<Object> newHashes;
        ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        for (int i = 0; i <= nodes.length - 2; i += 2) {
            byte[] left = ERSUtil.computeNodeHash(digCalc, nodes[i]);
            byte[] right = ERSUtil.computeNodeHash(digCalc, nodes[i + 1]);
            hashes.add(ERSUtil.calculateBranchHash(digCalc, left, right));
        }
        if (nodes.length % 2 == 1) {
            hashes.add(ERSUtil.computeNodeHash(digCalc, nodes[nodes.length - 1]));
        }
        do {
            newHashes = new ArrayList<Object>((hashes.size() + 1) / 2);
            for (int i = 0; i <= hashes.size() - 2; i += 2) {
                newHashes.add(ERSUtil.calculateBranchHash(digCalc, (byte[])hashes.get(i), (byte[])hashes.get(i + 1)));
            }
            if (hashes.size() % 2 != 1) continue;
            newHashes.add(hashes.get(hashes.size() - 1));
        } while ((hashes = newHashes).size() > 1);
        return (byte[])hashes.get(0);
    }
}

