/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import org.bouncycastle.asn1.tsp.PartialHashtree;
import org.bouncycastle.asn1.tsp.TSTInfo;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.ers.BinaryTreeRootCalculator;
import org.bouncycastle.tsp.ers.ERSArchiveTimeStamp;
import org.bouncycastle.tsp.ers.ERSData;
import org.bouncycastle.tsp.ers.ERSDataGroup;
import org.bouncycastle.tsp.ers.ERSException;
import org.bouncycastle.tsp.ers.ERSRootNodeCalculator;
import org.bouncycastle.tsp.ers.ERSUtil;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERSArchiveTimeStampGenerator {
    private final DigestCalculator digCalc;
    private List<ERSData> dataObjects = new ArrayList<ERSData>();
    private ERSRootNodeCalculator rootNodeCalculator = new BinaryTreeRootCalculator();

    public ERSArchiveTimeStampGenerator(DigestCalculator digCalc) {
        this.digCalc = digCalc;
    }

    public void addData(ERSData dataObject) {
        this.dataObjects.add(dataObject);
    }

    public void addAllData(List<ERSData> dataObjects) {
        this.dataObjects.addAll(dataObjects);
    }

    public TimeStampRequest generateTimeStampRequest(TimeStampRequestGenerator tspReqGenerator) throws TSPException, IOException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        return tspReqGenerator.generate(this.digCalc.getAlgorithmIdentifier(), rootHash);
    }

    public TimeStampRequest generateTimeStampRequest(TimeStampRequestGenerator tspReqGenerator, BigInteger nonce) throws TSPException, IOException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        return tspReqGenerator.generate(this.digCalc.getAlgorithmIdentifier(), rootHash, nonce);
    }

    public ERSArchiveTimeStamp generateArchiveTimeStamp(TimeStampResponse tspResponse) throws TSPException, ERSException {
        PartialHashtree[] reducedHashTree = this.getPartialHashtrees();
        byte[] rootHash = this.rootNodeCalculator.computeRootHash(this.digCalc, reducedHashTree);
        TSTInfo tstInfo = tspResponse.getTimeStampToken().getTimeStampInfo().toASN1Structure();
        if (!tstInfo.getMessageImprint().getHashAlgorithm().equals((Object)this.digCalc.getAlgorithmIdentifier())) {
            throw new ERSException("time stamp imprint for wrong algorithm");
        }
        if (!Arrays.areEqual((byte[])tstInfo.getMessageImprint().getHashedMessage(), (byte[])rootHash)) {
            throw new ERSException("time stamp imprint for wrong root hash");
        }
        ArchiveTimeStamp ats = reducedHashTree.length == 1 ? new ArchiveTimeStamp(null, null, tspResponse.getTimeStampToken().toCMSSignedData().toASN1Structure()) : new ArchiveTimeStamp(this.digCalc.getAlgorithmIdentifier(), reducedHashTree, tspResponse.getTimeStampToken().toCMSSignedData().toASN1Structure());
        return new ERSArchiveTimeStamp(ats, this.digCalc, this.rootNodeCalculator);
    }

    private PartialHashtree[] getPartialHashtrees() {
        int i;
        List<byte[]> hashes = ERSUtil.buildHashList(this.digCalc, this.dataObjects);
        PartialHashtree[] trees = new PartialHashtree[hashes.size()];
        HashSet<ERSDataGroup> dataGroupSet = new HashSet<ERSDataGroup>();
        for (i = 0; i != this.dataObjects.size(); ++i) {
            if (!(this.dataObjects.get(i) instanceof ERSDataGroup)) continue;
            dataGroupSet.add((ERSDataGroup)this.dataObjects.get(i));
        }
        for (i = 0; i != hashes.size(); ++i) {
            byte[] hash = hashes.get(i);
            ERSDataGroup found = null;
            for (ERSDataGroup data : dataGroupSet) {
                byte[] dHash = data.getHash(this.digCalc);
                if (!Arrays.areEqual((byte[])dHash, (byte[])hash)) continue;
                List<byte[]> dHashes = data.getHashes(this.digCalc);
                trees[i] = new PartialHashtree((byte[][])dHashes.toArray((T[])new byte[dHashes.size()][]));
                found = data;
                break;
            }
            if (found == null) {
                trees[i] = new PartialHashtree(hash);
                continue;
            }
            dataGroupSet.remove(found);
        }
        return trees;
    }
}

