/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp.ers;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.tsp.ers.ERSData;

public abstract class ERSCachingData
implements ERSData {
    private Map<AlgorithmIdentifier, byte[]> preCalcs = new HashMap<AlgorithmIdentifier, byte[]>();

    public byte[] getHash(DigestCalculator digestCalculator) {
        AlgorithmIdentifier digAlgID = digestCalculator.getAlgorithmIdentifier();
        if (this.preCalcs.containsKey(digAlgID)) {
            return this.preCalcs.get(digAlgID);
        }
        byte[] hash = this.calculateHash(digestCalculator);
        this.preCalcs.put(digAlgID, hash);
        return hash;
    }

    protected abstract byte[] calculateHash(DigestCalculator var1);
}

