/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.test.est;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ESTServerUtils {
    private static final Lock lock = new ReentrantLock();

    public static File makeRelativeToServerHome(String path) throws Exception {
        String ciscoHome = System.getenv("CISCO_EST_SERVER_HOME");
        if (ciscoHome == null) {
            File f = new File("cisco");
            if (f.exists()) {
                ciscoHome = f.getCanonicalPath();
            } else {
                throw new RuntimeException("CISCO_EST_SERVER_HOME not defined.");
            }
        }
        return new File(ciscoHome, path).getCanonicalFile();
    }

    public static ServerInstance startServer(final EstServerConfig config) {
        final CLibrary server = (CLibrary)Native.loadLibrary((String)"estserverwrap", CLibrary.class);
        final CountDownLatch exited = new CountDownLatch(1);
        Thread t = new Thread(new Runnable(){

            public void run() {
                block6: {
                    try {
                        if (lock.tryLock(60L, TimeUnit.SECONDS)) {
                            try {
                                server.start_server(config);
                                exited.countDown();
                                break block6;
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                        throw new IllegalStateException("Unable to obtain server lock.");
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t.getMessage(), t);
                    }
                }
            }
        });
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
        ESTServerUtils.waitForSocket(config.tcpPort);
        return new ServerInstance(server, config, exited);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForSocket(int port) {
        long notAfter = System.currentTimeMillis() + 5000L;
        while (System.currentTimeMillis() < notAfter) {
            Socket sock = null;
            try {
                Thread.sleep(100L);
                sock = new Socket("127.0.0.1", port);
                break;
            }
            catch (Exception exception) {}
            continue;
            finally {
                if (sock == null) continue;
                try {
                    sock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EstServerConfig
    extends Structure {
        public String srp;
        public boolean enforceCsr;
        public String httpAuthToken;
        public int manualEnroll;
        public boolean useDigestAuth;
        public boolean useBasicAuth;
        public boolean writeCSRToFile;
        public boolean disableHTTPAuth;
        public boolean disableHTTPWhenTLSSucceeds;
        public boolean verbose;
        public boolean enableCRLChecks;
        public boolean enableCheckPOPtoTLSUID;
        public boolean useIPV6;
        public int sleepDelay;
        public int tcpPort;
        public String serverCertPemFile;
        public String serverKeyPemFile;
        public String realm;
        public boolean fipsMode;
        public String estCSRAttr;
        public String estCACERTSResp;
        public String estTRUSTEDCerts;
        public String openSSLConfigFile;

        protected List<String> getFieldOrder() {
            return Arrays.asList("srp", "enforceCsr", "httpAuthToken", "manualEnroll", "useDigestAuth", "useBasicAuth", "writeCSRToFile", "disableHTTPAuth", "disableHTTPWhenTLSSucceeds", "verbose", "enableCRLChecks", "enableCheckPOPtoTLSUID", "useIPV6", "sleepDelay", "tcpPort", "serverCertPemFile", "serverKeyPemFile", "realm", "fipsMode", "estCSRAttr", "estCACERTSResp", "estTRUSTEDCerts", "openSSLConfigFile");
        }
    }

    public static interface CLibrary
    extends Library {
        public int start_server(EstServerConfig var1);

        public void stop_server();
    }

    public static class ServerInstance {
        private final CLibrary server;
        private final EstServerConfig estServerConfig;
        private final CountDownLatch exited;

        public ServerInstance(CLibrary server, EstServerConfig estServerConfig, CountDownLatch exited) {
            this.server = server;
            this.estServerConfig = estServerConfig;
            this.exited = exited;
        }

        public CLibrary getServer() {
            return this.server;
        }

        public EstServerConfig getEstServerConfig() {
            return this.estServerConfig;
        }

        public void stopServer() throws Exception {
            this.server.stop_server();
            this.exited.await(60L, TimeUnit.SECONDS);
        }
    }
}

